DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -8.50886383385411E-12   0.00000000000000E+00  -3.15728012862097E-10   1.62007058817718E-22
      8.82476145374374E-09   8.50903344088180E-09  -7.92652838203070E-19  -2.49110336317874E-01  -2.49110336321285E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41073657028996E-09   0.00000000000000E+00   3.41073657028996E-09
      3.70243398395254E-18  -2.49110336317875E-01  -2.45355022493275E-01   0.00000000000000E+00   1.00220414237176E-11
     -9.83304508698187E-23  -1.19297920525968E-08  -1.19197700111732E-08  -2.90978114574948E-18
      1.17500000000000E-12
      0.00000000000000E+00  -8.51749723915162E-12   0.00000000000000E+00  -2.08520972732442E-11   1.58785907416930E-22
      8.53860979122388E-09   8.51775769395080E-09  -7.94640859345741E-19  -2.48252192543809E-01  -2.48252192547021E-01
      0.00000000000000E+00   0.00000000000000E+00   3.21239898788671E-09   0.00000000000000E+00   3.21239898788671E-09
      3.70460235326937E-18  -2.48252192543813E-01  -2.44556663160700E-01   0.00000000000000E+00   1.35338918099457E-11
     -9.83194162763894E-23  -1.17436905736487E-08  -1.17301566818388E-08  -2.90996149392362E-18
      2.08625000000000E-12
      0.00000000000000E+00  -8.52760016024444E-12   0.00000000000000E+00  -6.84222481192492E-13   1.53560790618232E-22
      8.52823904812185E-09   8.52755482564081E-09  -7.97023785080289E-19  -2.47244517435901E-01  -2.47244517438811E-01
      0.00000000000000E+00   0.00000000000000E+00   2.90984813472455E-09   0.00000000000000E+00   2.90984813472455E-09
      3.70725395238213E-18  -2.47244517435905E-01  -2.43641133222674E-01   0.00000000000000E+00   1.54907891195301E-11
     -9.83048023544822E-23  -1.14528937494830E-08  -1.14374029603635E-08  -2.91023016730184E-18
      3.31643750000000E-12
      0.00000000000000E+00  -8.53926444186980E-12   0.00000000000000E+00   3.44736253506180E-13   1.46828574695951E-22
      8.53891163904680E-09   8.53925637530045E-09  -7.99785651219572E-19  -2.46075878863367E-01  -2.46075878865887E-01
      0.00000000000000E+00   0.00000000000000E+00   2.51986710760903E-09   0.00000000000000E+00   2.51986710760903E-09
      3.71035386139958E-18  -2.46075878863369E-01  -2.42591677183203E-01   0.00000000000000E+00   1.47291381764190E-11
     -9.82874633582946E-23  -1.10738526210860E-08  -1.10591234829097E-08  -2.91056821018001E-18
      4.97719062500000E-12
      0.00000000000000E+00  -8.55221454981606E-12   0.00000000000000E+00   3.38885669736468E-13   1.39286655803941E-22
      8.55193645525787E-09   8.55227534092775E-09  -8.02852569735713E-19  -2.44775766755823E-01  -2.44775766757901E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07744424576322E-09   0.00000000000000E+00   2.07744424576322E-09
      3.71380398342274E-18  -2.44775766755823E-01  -2.41426854953949E-01   0.00000000000000E+00   1.23675264219093E-11
     -9.82683441234165E-23  -1.06420871131124E-08  -1.06297195866906E-08  -2.91095141368703E-18
      7.21920734375000E-12
      0.00000000000000E+00  -8.56599126039719E-12   0.00000000000000E+00   3.02469367734252E-13   1.31596696493200E-22
      8.56571858726018E-09   8.56602105662805E-09  -8.06082300792519E-19  -2.43404171690086E-01  -2.43404171691707E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62093961321618E-09   0.00000000000000E+00   1.62093961321618E-09
      3.71743815713566E-18  -2.43404171690076E-01  -2.40194760917020E-01   0.00000000000000E+00   9.44504536857685E-12
     -9.82484254033717E-23  -1.01964057152126E-08  -1.01869606698441E-08  -2.91135585634314E-18
      1.02459299140625E-11
      0.00000000000000E+00  -8.57949243676670E-12   0.00000000000000E+00   2.79267659032465E-13   1.24357790593803E-22
      8.57934008132247E-09   8.57961934898162E-09  -8.09269512905717E-19  -2.42048458961086E-01  -2.42048458962273E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18680729878923E-09   0.00000000000000E+00   1.18680729878923E-09
      3.72103029357351E-18  -2.42048458961100E-01  -2.38971550820393E-01   0.00000000000000E+00   6.62890481279182E-12
     -9.82288968708640E-23  -9.77305555258348E-09  -9.76642664777078E-09  -2.91176078066780E-18
      1.43320053839844E-11
      0.00000000000000E+00  -8.59189147628971E-12   0.00000000000000E+00   2.65329509471529E-13   1.18089588251535E-22
      8.59177477239587E-09   8.59204010190546E-09  -8.12176075239522E-19  -2.40810670894360E-01  -2.40810670895167E-01
      0.00000000000000E+00   0.00000000000000E+00   8.06936964037211E-10   0.00000000000000E+00   8.06936964037211E-10
      3.72432749890804E-18  -2.40810670894333E-01  -2.37849541633390E-01   0.00000000000000E+00   4.25308221138432E-12
     -9.82110148462738E-23  -9.40323014815390E-09  -9.39897706594261E-09  -2.91215142366852E-18
      1.98482072683789E-11
      0.00000000000000E+00  -8.60217808685695E-12   0.00000000000000E+00   2.45069603190242E-13   1.13166796685806E-22
      8.60209181668970E-09   8.60233688629300E-09  -8.14587191411363E-19  -2.39783527978269E-01  -2.39783527978773E-01
      0.00000000000000E+00   0.00000000000000E+00   5.04434009105455E-10   0.00000000000000E+00   5.04434009105455E-10
      3.72711005873962E-18  -2.39783527978233E-01  -2.36914466577344E-01   0.00000000000000E+00   2.45981641897006E-12
     -9.81958110361917E-23  -9.10923071181718E-09  -9.10677089539831E-09  -2.91252286732825E-18
      2.72950798123115E-11
      0.00000000000000E+00  -8.60980120004518E-12   0.00000000000000E+00   2.02006180021916E-13   1.09742339274523E-22
      8.60974219623160E-09   8.60994420241174E-09  -8.16377478868299E-19  -2.39021762689128E-01  -2.39021762689417E-01
      0.00000000000000E+00   0.00000000000000E+00   2.88866339333738E-10   0.00000000000000E+00   2.88866339333738E-10
      3.72926120955087E-18  -2.39021762689168E-01  -2.36218216171801E-01   0.00000000000000E+00   1.26598744276939E-12
     -9.81837558948011E-23  -8.90007652918827E-09  -8.89881054174560E-09  -2.91288373068257E-18
      3.73483577466206E-11
      0.00000000000000E+00  -8.61476081585439E-12   0.00000000000000E+00   1.36351613580212E-13   1.07717385980762E-22
      8.61474884400022E-09   8.61488519561391E-09  -8.17553961131878E-19  -2.38523150870939E-01  -2.38523150871093E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54238492146284E-10   0.00000000000000E+00   1.54238492146284E-10
      3.73081181198058E-18  -2.38523150871110E-01  -2.35760448119368E-01   0.00000000000000E+00   5.85468252519007E-13
     -9.81745555806307E-23  -8.76970915601262E-09  -8.76912368776020E-09  -2.91325785084871E-18
      5.09202829579378E-11
      0.00000000000000E+00  -8.61769984744503E-12   0.00000000000000E+00   7.01041741904742E-14   1.06796767778385E-22
      8.61765974721477E-09   8.61772985138907E-09  -8.18244318773663E-19  -2.38233160519553E-01  -2.38233160519636E-01
      0.00000000000000E+00   0.00000000000000E+00   8.21830752997449E-11   0.00000000000000E+00   8.21830752997449E-11
      3.73192719453219E-18  -2.38233160519754E-01  -2.35492245272637E-01   0.00000000000000E+00   2.62279748934672E-13
     -9.81672255563901E-23  -8.70017520643765E-09  -8.69991292668882E-09  -2.91368287575853E-18
      6.92423819932160E-11
      0.00000000000000E+00  -8.61926120797756E-12   0.00000000000000E+00   2.62344594443110E-14   1.06617921786633E-22
      8.61926913706994E-09   8.61929537152949E-09  -8.18631827551193E-19  -2.38072713938076E-01  -2.38072713938126E-01
      0.00000000000000E+00   0.00000000000000E+00   4.97276531498651E-11   0.00000000000000E+00   4.97276531498651E-11
      3.73283830951799E-18  -2.38072713938262E-01  -2.35341518288916E-01   0.00000000000000E+00   1.34281187616343E-13
     -9.81604268604475E-23  -8.66915730586700E-09  -8.66902302467948E-09  -2.91420648196680E-18
      8.92423819932160E-11
      0.00000000000000E+00  -8.62017965534963E-12   0.00000000000000E+00   5.18415882722623E-15   1.06809527203511E-22
      8.62015509261166E-09   8.62016027677059E-09  -8.18846925831889E-19  -2.37984288749181E-01  -2.37984288749219E-01
      0.00000000000000E+00   0.00000000000000E+00   3.82198615834362E-11   0.00000000000000E+00   3.82198615834362E-11
      3.73360270674966E-18  -2.37984288749646E-01  -2.35256440022339E-01   0.00000000000000E+00   9.60204746234851E-14
     -9.81542089842326E-23  -8.65847615882852E-09  -8.65838013835399E-09  -2.91475578091777E-18
      1.09242381993216E-10
      0.00000000000000E+00  -8.62073072377288E-12   0.00000000000000E+00   1.78523155780020E-15   1.07117311006579E-22
      8.62076107350269E-09   8.62076285873436E-09  -8.18992003534970E-19  -2.37923746280423E-01  -2.37923746280458E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41865940037495E-11   0.00000000000000E+00   3.41865940037495E-11
      3.73428643862974E-18  -2.37923746281354E-01  -2.35196977463335E-01   0.00000000000000E+00   7.98249150120788E-14
     -9.81484138728975E-23  -8.65502927765307E-09  -8.65494945273816E-09  -2.91529443509477E-18
      1.29242381993216E-10
      0.00000000000000E+00  -8.62128179219612E-12   0.00000000000000E+00   1.90452617438243E-15   1.07457457774220E-22
      8.62127228602597E-09   8.62127419055225E-09  -8.19110586087095E-19  -2.37872644270035E-01  -2.37872644270067E-01
      0.00000000000000E+00   0.00000000000000E+00   3.25138006174143E-11   0.00000000000000E+00   3.25138006174143E-11
      3.73493671464209E-18  -2.37872644271884E-01  -2.35146241436720E-01   0.00000000000000E+00   7.25634423808842E-14
     -9.81427949081279E-23  -8.65386055461191E-09  -8.65378799116962E-09  -2.91582612855499E-18
      1.49242381993216E-10
      0.00000000000000E+00  -8.62174101588216E-12   0.00000000000000E+00   1.37655985529275E-15   1.07804030722625E-22
      8.62174711528327E-09   8.62174849184323E-09  -8.19216653888929E-19  -2.37825169788526E-01  -2.37825169788557E-01
      0.00000000000000E+00   0.00000000000000E+00   3.16013676185739E-11   0.00000000000000E+00   3.16013676185739E-11
      3.73556874199446E-18  -2.37825169791074E-01  -2.35098904813486E-01   0.00000000000000E+00   6.99271339911430E-14
     -9.81372716632783E-23  -8.65341978659571E-09  -8.65334985946181E-09  -2.91635208810553E-18
      1.69242381993216E-10
      0.00000000000000E+00  -8.62220023956820E-12   0.00000000000000E+00   1.18200452380845E-15   1.08149107704834E-22
      8.62220417955623E-09   8.62220536156087E-09  -8.19314899168302E-19  -2.37779467679906E-01  -2.37779467679937E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09463244483880E-11   0.00000000000000E+00   3.09463244483880E-11
      3.73618766848342E-18  -2.37779467683263E-01  -2.35053265058064E-01   0.00000000000000E+00   6.82756273797405E-14
     -9.81318176686117E-23  -8.65321996163660E-09  -8.65315168600932E-09  -2.91687276931513E-18
      1.89242381993216E-10
      0.00000000000000E+00  -8.62265946325423E-12   0.00000000000000E+00   1.25931668388462E-15   1.08490377494744E-22
      8.62264964550523E-09   8.62265090482202E-09  -8.19407078463410E-19  -2.37734924078602E-01  -2.37734924078632E-01
      0.00000000000000E+00   0.00000000000000E+00   3.03895462148540E-11   0.00000000000000E+00   3.03895462148540E-11
      3.73679545940772E-18  -2.37734924082363E-01  -2.35008756501715E-01   0.00000000000000E+00   6.68286274671300E-14
     -9.81264223637603E-23  -8.65310727966424E-09  -8.65304045103687E-09  -2.91738838094431E-18
      2.09242381993216E-10
      0.00000000000000E+00  -8.62311868694027E-12   0.00000000000000E+00   1.06776164859937E-15   1.08827255294838E-22
      8.62308575737506E-09   8.62308682513682E-09  -8.19494006903372E-19  -2.37691315804140E-01  -2.37691315804170E-01
      0.00000000000000E+00   0.00000000000000E+00   2.98798738075213E-11   0.00000000000000E+00   2.98798738075213E-11
      3.73739305688387E-18  -2.37691315807261E-01  -2.34965171376394E-01   0.00000000000000E+00   6.58589571157831E-14
     -9.81210812779477E-23  -8.65303255790132E-09  -8.65296669894431E-09  -2.91789904998050E-18
      2.29242381993216E-10
      0.00000000000000E+00  -8.62357791062631E-12   0.00000000000000E+00   9.46075148193505E-16   1.09159703145036E-22
      8.62351348347307E-09   8.62351442954833E-09  -8.19576180976323E-19  -2.37648545652441E-01  -2.37648545652470E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93999153335291E-11   0.00000000000000E+00   2.93999153335291E-11
      3.73798105519054E-18  -2.37648545652705E-01  -2.34922417651859E-01   0.00000000000000E+00   6.49331519940072E-14
     -9.81157920261513E-23  -8.65297927803385E-09  -8.65291434488195E-09  -2.91840487421422E-18
      2.49242381993216E-10
      0.00000000000000E+00  -8.62394528957514E-12   0.00000000000000E+00   1.02338016474213E-15   1.09487826785513E-22
      8.62393338977589E-09   8.62393441315616E-09  -8.19653980138914E-19  -2.37606557398803E-01  -2.37606557398831E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89431704635721E-11   0.00000000000000E+00   2.89431704635721E-11
      3.73855991859981E-18  -2.37606557393749E-01  -2.34880440973066E-01   0.00000000000000E+00   6.38896047219495E-14
     -9.81105525411351E-23  -8.65294147322432E-09  -8.65287758361970E-09  -2.91890593846090E-18
      2.69242381993216E-10
      0.00000000000000E+00  -8.62440451326118E-12   0.00000000000000E+00   9.22983966081144E-16   1.09811777086769E-22
      8.62434588957993E-09   8.62434681256401E-09  -8.19727730240710E-19  -2.37565309642090E-01  -2.37565309642118E-01
      0.00000000000000E+00   0.00000000000000E+00   2.85066085903283E-11   0.00000000000000E+00   2.85066085903283E-11
      3.73913005077162E-18  -2.37565309628487E-01  -2.34839200762700E-01   0.00000000000000E+00   6.30882189899993E-14
     -9.81053613491985E-23  -8.65291650937318E-09  -8.65285342115429E-09  -2.91940232053091E-18
      2.89242381993216E-10
      0.00000000000000E+00  -8.62477189221001E-12   0.00000000000000E+00   9.85228500778850E-16   1.10131705933927E-22
      8.62475133440142E-09   8.62475231963003E-09  -8.19797724667390E-19  -2.37524767353176E-01  -2.37524767353204E-01
      0.00000000000000E+00   0.00000000000000E+00   2.80883572431534E-11   0.00000000000000E+00   2.80883572431534E-11
      3.73969181791648E-18  -2.37524767328408E-01  -2.34798662471534E-01   0.00000000000000E+00   6.21802507334450E-14
     -9.81002169391184E-23  -8.65290285712377E-09  -8.65284067687314E-09  -2.91989409324909E-18
      3.09242381993216E-10
      0.00000000000000E+00  -8.62513927115884E-12   0.00000000000000E+00   9.07680695736758E-16   1.10447761252884E-22
      8.62515003741402E-09   8.62515094509483E-09  -8.19864232808790E-19  -2.37484898964988E-01  -2.37484898965015E-01
      0.00000000000000E+00   0.00000000000000E+00   2.76870189767869E-11   0.00000000000000E+00   2.76870189767869E-11
      3.74024555829602E-18  -2.37484898928406E-01  -2.34758794875997E-01   0.00000000000000E+00   6.14607016700107E-14
     -9.80951180856112E-23  -8.65289942477325E-09  -8.65283796407168E-09  -2.92038132548723E-18
      3.29242381993216E-10
      0.00000000000000E+00  -8.62559849484488E-12   0.00000000000000E+00   9.50268923744259E-16   1.10760080288913E-22
      8.62554229144158E-09   8.62554324171062E-09  -8.19927503187799E-19  -2.37445675440425E-01  -2.37445675440452E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73013795585544E-11   0.00000000000000E+00   2.73013795585544E-11
      3.74079158588719E-18  -2.37445675395298E-01  -2.34719569233266E-01   0.00000000000000E+00   6.06647717020623E-14
     -9.80900635486946E-23  -8.65290528604079E-09  -8.65284462126919E-09  -2.92086408269939E-18
      3.49242381993216E-10
      0.00000000000000E+00  -8.62596587379370E-12   0.00000000000000E+00   8.90305122068864E-16   1.11068792711790E-22
      8.62592836257514E-09   8.62592925288037E-09  -8.19987765970604E-19  -2.37407069766557E-01  -2.37407069766584E-01
      0.00000000000000E+00   0.00000000000000E+00   2.69303734045542E-11   0.00000000000000E+00   2.69303734045542E-11
      3.74133019335528E-18  -2.37407069722773E-01  -2.34680958788856E-01   0.00000000000000E+00   6.00099365422940E-14
     -9.80850522667516E-23  -8.65291963622131E-09  -8.65285962628487E-09  -2.92134242738468E-18
      3.69242381993216E-10
      0.00000000000000E+00  -8.62633325274254E-12   0.00000000000000E+00   9.18016304722148E-16   1.11374018168681E-22
      8.62630850525073E-09   8.62630942326714E-09  -8.20045234133030E-19  -2.37369056798966E-01  -2.37369056798992E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65730080430580E-11   0.00000000000000E+00   2.65730080430580E-11
      3.74186165351614E-18  -2.37369056774460E-01  -2.34642938638969E-01   0.00000000000000E+00   5.93023545737037E-14
     -9.80800831942581E-23  -8.65294173366471E-09  -8.65288243131024E-09  -2.92181641938311E-18
      3.89242381993216E-10
      0.00000000000000E+00  -8.62670063169137E-12   0.00000000000000E+00   8.71262130928006E-16   1.11675869420049E-22
      8.62668295062234E-09   8.62668382188458E-09  -8.20100105105968E-19  -2.37331613029282E-01  -2.37331613029308E-01
      0.00000000000000E+00   0.00000000000000E+00   2.62283893794159E-11   0.00000000000000E+00   2.62283893794159E-11
      3.74238622130373E-18  -2.37331613050639E-01  -2.34605485492701E-01   0.00000000000000E+00   5.87001572318399E-14
     -9.80751554063081E-23  -8.65297091142110E-09  -8.65291221126397E-09  -2.92228611619776E-18
      4.09242381993216E-10
      0.00000000000000E+00  -8.62706801064019E-12   0.00000000000000E+00   8.88197814363078E-16   1.11974450727175E-22
      8.62705192113852E-09   8.62705280933644E-09  -8.20152561639111E-19  -2.37294716519553E-01  -2.37294716519579E-01
      0.00000000000000E+00   0.00000000000000E+00   2.58956767800395E-11   0.00000000000000E+00   2.58956767800395E-11
      3.74290413483933E-18  -2.37294716619082E-01  -2.34568577612630E-01   0.00000000000000E+00   5.80624015642627E-14
     -9.80702680083277E-23  -8.65300654851798E-09  -8.65294848611652E-09  -2.92275157320022E-18
      4.29242381993216E-10
      0.00000000000000E+00  -8.62743538958903E-12   0.00000000000000E+00   8.51366285628729E-16   1.12269860448330E-22
      8.62741562155122E-09   8.62741647291762E-09  -8.20202773125843E-19  -2.37258346732683E-01  -2.37258346732709E-01
      0.00000000000000E+00   0.00000000000000E+00   2.55741077984545E-11   0.00000000000000E+00   2.55741077984545E-11
      3.74341561699530E-18  -2.37258346941254E-01  -2.34532194635883E-01   0.00000000000000E+00   5.75034180357781E-14
     -9.80654201905703E-23  -8.65304808413398E-09  -8.65299058071605E-09  -2.92321284386946E-18
      4.49242381993216E-10
      0.00000000000000E+00  -8.62780276853786E-12   0.00000000000000E+00   8.60594739287915E-16   1.12562189800111E-22
      8.62777424943384E-09   8.62777511002869E-09  -8.20250896361248E-19  -2.37222484477994E-01  -2.37222484478019E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52629651806404E-11   0.00000000000000E+00   2.52629651806404E-11
      3.74392087629891E-18  -2.37222484812062E-01  -2.34496317521136E-01   0.00000000000000E+00   5.69212277723135E-14
     -9.80606111767871E-23  -8.65309499643702E-09  -8.65303807520934E-09  -2.92366997993767E-18
      4.69242381993216E-10
      0.00000000000000E+00  -8.62817014748668E-12   0.00000000000000E+00   8.31237754459167E-16   1.12851524958535E-22
      8.62812798835985E-09   8.62812881959772E-09  -8.20297076652874E-19  -2.37187111772275E-01  -2.37187111772300E-01
      0.00000000000000E+00   0.00000000000000E+00   2.49615962256497E-11   0.00000000000000E+00   2.49615962256497E-11
      3.74442010822343E-18  -2.37187112214707E-01  -2.34460928399354E-01   0.00000000000000E+00   5.63980308807791E-14
     -9.80558402519420E-23  -8.65314681385413E-09  -8.65309041582335E-09  -2.92412303157055E-18
      4.89242381993216E-10
      0.00000000000000E+00  -8.62844568169831E-12   0.00000000000000E+00   8.35016863415572E-16   1.13137946084606E-22
      8.62847701571139E-09   8.62847785072837E-09  -8.20341448495553E-19  -2.37152211789693E-01  -2.37152211789718E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46693873865901E-11   0.00000000000000E+00   2.46693873865901E-11
      3.74491349597116E-18  -2.37152212267179E-01  -2.34426010525974E-01   0.00000000000000E+00   5.58604597176489E-14
     -9.80511067323616E-23  -8.65320309857463E-09  -8.65314723811501E-09  -2.92457204747561E-18
      5.09242381993216E-10
      0.00000000000000E+00  -8.62881306064714E-12   0.00000000000000E+00   8.11310975820190E-16   1.13421529002367E-22
      8.62882149533502E-09   8.62882230664611E-09  -8.20384136523581E-19  -2.37117768739169E-01  -2.37117768739193E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43857803558149E-11   0.00000000000000E+00   2.43857803558149E-11
      3.74540121157827E-18  -2.37117769100727E-01  -2.34391548156498E-01   0.00000000000000E+00   5.53671942760175E-14
     -9.80464099805652E-23  -8.65326345419607E-09  -8.65320808700189E-09  -2.92501707505469E-18
      5.29242381993216E-10
      0.00000000000000E+00  -8.62918043959597E-12   0.00000000000000E+00   8.11275358769779E-16   1.13702344434230E-22
      8.62916158483705E-09   8.62916239611252E-09  -8.20425256105431E-19  -2.37083767819644E-01  -2.37083767819668E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41102516069583E-11   0.00000000000000E+00   2.41102516069583E-11
      3.74588341661041E-18  -2.37083767825946E-01  -2.34357526516830E-01   0.00000000000000E+00   5.48657974809803E-14
     -9.80417493882376E-23  -8.65332751351682E-09  -8.65327264771944E-09  -2.92545816050498E-18
      5.49242381993216E-10
      0.00000000000000E+00  -8.62954781854480E-12   0.00000000000000E+00   7.91835342219079E-16   1.13980459267527E-22
      8.62949742126588E-09   8.62949821310133E-09  -8.20464914204758E-19  -2.37050195092060E-01  -2.37050195092083E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38423289994839E-11   0.00000000000000E+00   2.38423289994839E-11
      3.74636026319040E-18  -2.37050194429331E-01  -2.34323931699024E-01   0.00000000000000E+00   5.43977441541748E-14
     -9.80371243867747E-23  -8.65339493984486E-09  -8.65334054210081E-09  -2.92589534898565E-18
      5.69242381993216E-10
      0.00000000000000E+00  -8.62982335275642E-12   0.00000000000000E+00   7.89102365013983E-16   1.14255935910943E-22
      8.62982912699217E-09   8.62982991609465E-09  -8.20503209924064E-19  -2.37017037429594E-01  -2.37017037429618E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35815740928592E-11   0.00000000000000E+00   2.35815740928592E-11
      3.74683189467226E-18  -2.37017035763424E-01  -2.34290750655233E-01   0.00000000000000E+00   5.39258338492076E-14
     -9.80325344390852E-23  -8.65346541602132E-09  -8.65341149018757E-09  -2.92632868474820E-18
      5.89242381993216E-10
      0.00000000000000E+00  -8.63019073170525E-12   0.00000000000000E+00   7.72788461092792E-16   1.14528833308581E-22
      8.63015679728211E-09   8.63015757007069E-09  -8.20540235247425E-19  -2.36984282402914E-01  -2.36984282402937E-01
      0.00000000000000E+00   0.00000000000000E+00   2.33275954631960E-11   0.00000000000000E+00   2.33275954631960E-11
      3.74729844658152E-18  -2.36984279487272E-01  -2.34257971137805E-01   0.00000000000000E+00   5.34789377343399E-14
     -9.80279790506006E-23  -8.65353864447145E-09  -8.65348516553382E-09  -2.92675821133410E-18
      6.09242381993216E-10
      0.00000000000000E+00  -8.63046626591687E-12   0.00000000000000E+00   7.68069972777865E-16   1.14799206396084E-22
      8.63048050343992E-09   8.63048127151001E-09  -8.20576075533680E-19  -2.36951918227888E-01  -2.36951918227911E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30800340542160E-11   0.00000000000000E+00   2.30800340542160E-11
      3.74776004726261E-18  -2.36951914076071E-01  -2.34225581712627E-01   0.00000000000000E+00   5.30308592394724E-14
     -9.80234577661886E-23  -8.65361433642345E-09  -8.65356130556431E-09  -2.92718397172893E-18
      6.29242381993216E-10
      0.00000000000000E+00  -8.63083364486570E-12   0.00000000000000E+00   7.53926243628333E-16   1.15067106966869E-22
      8.63080028633145E-09   8.63080104025781E-09  -8.20610810128237E-19  -2.36919933676586E-01  -2.36919933676609E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28385700467173E-11   0.00000000000000E+00   2.28385700467173E-11
      3.74821681866354E-18  -2.36919928783104E-01  -2.34193571720869E-01   0.00000000000000E+00   5.26012855296518E-14
     -9.80189701798317E-23  -8.65369221158988E-09  -8.65363961030445E-09  -2.92760600853531E-18
      6.49242381993216E-10
      0.00000000000000E+00  -8.63110917907733E-12   0.00000000000000E+00   7.47655815724758E-16   1.15332583403997E-22
      8.63111617182539E-09   8.63111691948132E-09  -8.20644512701400E-19  -2.36888318073093E-01  -2.36888318073115E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26029029997532E-11   0.00000000000000E+00   2.26029029997532E-11
      3.74866887672354E-18  -2.36888313647528E-01  -2.34161931288223E-01   0.00000000000000E+00   5.21720313875293E-14
     -9.80145159278418E-23  -8.65377199451240E-09  -8.65371982248111E-09  -2.92802436402214E-18
      6.69242381993216E-10
      0.00000000000000E+00  -8.63147655802616E-12   0.00000000000000E+00   7.35014899323918E-16   1.15595681669079E-22
      8.63142818327793E-09   8.63142891829295E-09  -8.20677251615623E-19  -2.36857061288349E-01  -2.36857061288371E-01
      0.00000000000000E+00   0.00000000000000E+00   2.23727479820288E-11   0.00000000000000E+00   2.23727479820288E-11
      3.74911633168318E-18  -2.36857059421889E-01  -2.34130651249625E-01   0.00000000000000E+00   5.17563155834578E-14
     -9.80100946863435E-23  -8.65385342259041E-09  -8.65380166627492E-09  -2.92843908006756E-18
      6.89242381993216E-10
      0.00000000000000E+00  -8.63175209223778E-12   0.00000000000000E+00   7.27738261856116E-16   1.15856445539877E-22
      8.63173638262805E-09   8.63173711036643E-09  -8.20709089975899E-19  -2.36826153849339E-01  -2.36826153849362E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21478061618536E-11   0.00000000000000E+00   2.21478061618536E-11
      3.74955928780642E-18  -2.36826157493141E-01  -2.34099723066647E-01   0.00000000000000E+00   5.13420592353487E-14
     -9.80057061444905E-23  -8.65393625858742E-09  -8.65388491652828E-09  -2.92885019783052E-18
      7.09242381993216E-10
      0.00000000000000E+00  -8.63202762644940E-12   0.00000000000000E+00   7.16605765489030E-16   1.16114917968302E-22
      8.63204091199816E-09   8.63204162860404E-09  -8.20740085640083E-19  -2.36795587076038E-01  -2.36795587076060E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19277500756317E-11   0.00000000000000E+00   2.19277500756317E-11
      3.74999784280793E-18  -2.36795599672107E-01  -2.34069138608427E-01   0.00000000000000E+00   5.09384223371410E-14
     -9.80013499733256E-23  -8.65402031710189E-09  -8.65396937867965E-09  -2.92925775716785E-18
      7.29242381993216E-10
      0.00000000000000E+00  -8.63230316066102E-12   0.00000000000000E+00   7.09526794878352E-16   1.16371141818928E-22
      8.63234205433665E-09   8.63234276386356E-09  -8.20770290974012E-19  -2.36765353312895E-01  -2.36765353312917E-01
      0.00000000000000E+00   0.00000000000000E+00   2.17121938995913E-11   0.00000000000000E+00   2.17121938995913E-11
      3.75043208668592E-18  -2.36765377918340E-01  -2.34038889866832E-01   0.00000000000000E+00   5.05385116426248E-14
     -9.79970257661001E-23  -8.65410549627478E-09  -8.65405495776324E-09  -2.92966179571191E-18
      7.49242381993216E-10
      0.00000000000000E+00  -8.63267053960985E-12   0.00000000000000E+00   7.00992459465369E-16   1.16625161344157E-22
      8.63264028064715E-09   8.63264098163973E-09  -8.20799752658867E-19  -2.36735446143622E-01  -2.36735446143644E-01
      0.00000000000000E+00   0.00000000000000E+00   2.15006870176007E-11   0.00000000000000E+00   2.15006870176007E-11
      3.75086210042627E-18  -2.36735483931474E-01  -2.34008968534909E-01   0.00000000000000E+00   5.01494707396958E-14
     -9.79927329787579E-23  -8.65419181812789E-09  -8.65414166865725E-09  -2.93006234776740E-18
      7.69242381993216E-10
      0.00000000000000E+00  -8.63294607382148E-12   0.00000000000000E+00   6.96180373748340E-16   1.16877022610968E-22
      8.63293627323262E-09   8.63293696941311E-09  -8.20828511583650E-19  -2.36705860550181E-01  -2.36705860550202E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12927188228322E-11   0.00000000000000E+00   2.12927188228322E-11
      3.75128795480273E-18  -2.36705908717613E-01  -2.33979365564518E-01   0.00000000000000E+00   4.97688380905646E-14
     -9.79884708607256E-23  -8.65427945707400E-09  -8.65422968823601E-09  -2.93045944321908E-18
      7.89242381993216E-10
      0.00000000000000E+00  -8.63322160803310E-12   0.00000000000000E+00   6.91952382054010E-16   1.17126773605481E-22
      8.63323087783639E-09   8.63323156978889E-09  -8.20856603285456E-19  -2.36676592824319E-01  -2.36676592824340E-01
      0.00000000000000E+00   0.00000000000000E+00   2.10877721518994E-11   0.00000000000000E+00   2.10877721518994E-11
      3.75170971024577E-18  -2.36676642173780E-01  -2.33950070749015E-01   0.00000000000000E+00   4.94025517991375E-14
     -9.79842384254059E-23  -8.65436874449244E-09  -8.65431934194074E-09  -2.93085310696031E-18
      8.09242381993216E-10
      0.00000000000000E+00  -8.63349714224472E-12   0.00000000000000E+00   6.91017993654696E-16   1.17374462228848E-22
      8.63352496493104E-09   8.63352565594915E-09  -8.20884059131944E-19  -2.36647640120622E-01  -2.36647640120643E-01
      0.00000000000000E+00   0.00000000000000E+00   2.08854169035124E-11   0.00000000000000E+00   2.08854169035124E-11
      3.75212741858384E-18  -2.36647672954463E-01  -2.33921072604137E-01   0.00000000000000E+00   4.90503216509209E-14
     -9.79800344735938E-23  -8.65446012317420E-09  -8.65441107285265E-09  -2.93124335945189E-18
      8.29242381993216E-10
      0.00000000000000E+00  -8.63386452119355E-12   0.00000000000000E+00   6.90801198749804E-16   1.17620132491549E-22
      8.63381913948034E-09   8.63381983028165E-09  -8.20910908837611E-19  -2.36618999391679E-01  -2.36618999391700E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06854767634538E-11   0.00000000000000E+00   2.06854767634538E-11
      3.75254112811911E-18  -2.36618988789098E-01  -2.33892358724462E-01   0.00000000000000E+00   4.87146894980955E-14
     -9.79758577397974E-23  -8.65455402173449E-09  -8.65450530704509E-09  -2.93163021928150E-18
      8.49242381993216E-10
      0.00000000000000E+00  -8.63414005540518E-12   0.00000000000000E+00   6.90947216768898E-16   1.17863817532484E-22
      8.63411331565822E-09   8.63411400660556E-09  -8.20937184351311E-19  -2.36590665666863E-01  -2.36590665666883E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04882324998298E-11   0.00000000000000E+00   2.04882324998298E-11
      3.75295089276910E-18  -2.36590577628611E-01  -2.33863917000041E-01   0.00000000000000E+00   4.83918992661977E-14
     -9.79717071789139E-23  -8.65465063100462E-09  -8.65460223910546E-09  -2.93201370841779E-18
      8.69242381993217E-10
      0.00000000000000E+00  -8.63441558961680E-12   0.00000000000000E+00   6.87526211421727E-16   1.18105530729770E-22
      8.63440616358098E-09   8.63440685110731E-09  -8.20962925186182E-19  -2.36562629646007E-01  -2.36562629646027E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02946518215067E-11   0.00000000000000E+00   2.02946518215067E-11
      3.75335678580553E-18  -2.36562429798992E-01  -2.33835737871919E-01   0.00000000000000E+00   4.80749666665331E-14
     -9.79675824436168E-23  -8.65474957789538E-09  -8.65470150292882E-09  -2.93239386061935E-18
      8.79242381993216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.83868140084336E-16   1.18225932614869E-22
      8.63455196452927E-09   8.63455264839753E-09  -8.20975667648698E-19  -2.36548684501351E-01  -2.36548684501371E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01989051469493E-11   0.00000000000000E+00   2.01989051469493E-11
      3.75355877485700E-18  -2.36548420545262E-01  -2.33821712836901E-01   0.00000000000000E+00   4.79159767073600E-14
     -9.79655276654446E-23  -8.65479946952116E-09  -8.65475155354455E-09  -2.93258310720831E-18
      8.80929881993216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.86474521764579E-16   1.18246226359725E-22
      8.63457663983465E-09   8.63457732630929E-09  -8.20977814190814E-19  -2.36546333387393E-01  -2.36546333387413E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01827074199190E-11   0.00000000000000E+00   2.01827074199190E-11
      3.75359283317578E-18  -2.36546058417628E-01  -2.33819348035613E-01   0.00000000000000E+00   4.78862726688947E-14
     -9.79651792448722E-23  -8.65480792000115E-09  -8.65476003372858E-09  -2.93261501898496E-18
      8.83208006993216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.83250782754172E-16   1.18273605583890E-22
      8.63460980341950E-09   8.63461048667040E-09  -8.20980705520204E-19  -2.36543163116575E-01  -2.36543163116596E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01610096770017E-11   0.00000000000000E+00   2.01610096770017E-11
      3.75363876247595E-18  -2.36542872859968E-01  -2.33816158863769E-01   0.00000000000000E+00   4.78504441601926E-14
     -9.79647118323228E-23  -8.65481934679191E-09  -8.65477149634785E-09  -2.93265805695574E-18
      8.86283475743216E-10
      0.00000000000000E+00  -8.63469112382842E-12   0.00000000000000E+00   6.81362588947882E-16   1.18310528549293E-22
      8.63465445801710E-09   8.63465513937981E-09  -8.20984597215143E-19  -2.36538889980013E-01  -2.36538889980033E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01318832903263E-11   0.00000000000000E+00   2.01318832903263E-11
      3.75370067745388E-18  -2.36538578404428E-01  -2.33811859512769E-01   0.00000000000000E+00   4.78013990611388E-14
     -9.79640810120565E-23  -8.65483482406918E-09  -8.65478702267022E-09  -2.93271608023874E-18
      8.90435358555716E-10
      0.00000000000000E+00  -8.63469112382842E-12   0.00000000000000E+00   6.79229230958858E-16   1.18360293013647E-22
      8.63471456504421E-09   8.63471524427356E-09  -8.20989830286510E-19  -2.36533133387870E-01  -2.36533133387890E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00927906916128E-11   0.00000000000000E+00   2.00927906916128E-11
      3.75378410036621E-18  -2.36532791899021E-01  -2.33806066382192E-01   0.00000000000000E+00   4.77350740048808E-14
     -9.79632304381612E-23  -8.65485577003910E-09  -8.65480803496520E-09  -2.93279427007970E-18
      8.96040400352591E-10
      0.00000000000000E+00  -8.63478296856563E-12   0.00000000000000E+00   6.75772749383503E-16   1.18427319694390E-22
      8.63479532215282E-09   8.63479599792569E-09  -8.20996858306106E-19  -2.36525383766346E-01  -2.36525383766366E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00404561710640E-11   0.00000000000000E+00   2.00404561710640E-11
      3.75389642796068E-18  -2.36525000152678E-01  -2.33798265675328E-01   0.00000000000000E+00   4.76446548927870E-14
     -9.79620842485598E-23  -8.65488409875153E-09  -8.65483645409674E-09  -2.93289956965457E-18
      9.03607206778373E-10
      0.00000000000000E+00  -8.63487481330283E-12   0.00000000000000E+00   6.69545093031043E-16   1.18517516359901E-22
      8.63490339944016E-09   8.63490406898538E-09  -8.21006282631983E-19  -2.36514960370391E-01  -2.36514960370411E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99707505936001E-11   0.00000000000000E+00   1.99707505936001E-11
      3.75404754276460E-18  -2.36514517854439E-01  -2.33787771280516E-01   0.00000000000000E+00   4.75197540829734E-14
     -9.79605408169930E-23  -8.65492233933306E-09  -8.65487481957907E-09  -2.93304126013261E-18
      9.13822395453177E-10
      0.00000000000000E+00  -8.63505850277725E-12   0.00000000000000E+00   6.57398956441151E-16   1.18638743348848E-22
      8.63504681195003E-09   8.63504746934910E-09  -8.21018899410310E-19  -2.36500955602547E-01  -2.36500955602566E-01
      0.00000000000000E+00   0.00000000000000E+00   1.98787959441153E-11   0.00000000000000E+00   1.98787959441153E-11
      3.75425060841579E-18  -2.36500434129460E-01  -2.33773671334737E-01   0.00000000000000E+00   4.73426925481603E-14
     -9.79584647390773E-23  -8.65497360798579E-09  -8.65492626529334E-09  -2.93323170900548E-18
      9.27612900164164E-10
      0.00000000000000E+00  -8.63524219225167E-12   0.00000000000000E+00   6.31944466444188E-16   1.18801385371658E-22
      8.63523336167435E-09   8.63523399361894E-09  -8.21035768488469E-19  -2.36482159353204E-01  -2.36482159353224E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97598034619522E-11   0.00000000000000E+00   1.97598034619522E-11
      3.75452310607852E-18  -2.36481548858228E-01  -2.33754764770364E-01   0.00000000000000E+00   4.70781285947708E-14
     -9.79556774123794E-23  -8.65504087520942E-09  -8.65499379708093E-09  -2.93348733759005E-18
      9.46230081523995E-10
      0.00000000000000E+00  -8.63542588172608E-12   0.00000000000000E+00   5.77305348880705E-16   1.19019042528916E-22
      8.63546447180283E-09   8.63546504910830E-09  -8.21058335133148E-19  -2.36456947538651E-01  -2.36456947538670E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96118053019780E-11   0.00000000000000E+00   1.96118053019780E-11
      3.75488822261462E-18  -2.36456312737125E-01  -2.33729502459128E-01   0.00000000000000E+00   4.66444140677013E-14
     -9.79519538880162E-23  -8.65512349882421E-09  -8.65507685441025E-09  -2.93382988748147E-18
      9.51230081523995E-10
      0.00000000000000E+00  -8.63551772646329E-12   0.00000000000000E+00   5.60474246981485E-16   1.19077313361110E-22
      8.63552492340175E-09   8.63552548387612E-09  -8.21064382649802E-19  -2.36450187482604E-01  -2.36450187482624E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95729460730407E-11   0.00000000000000E+00   1.95729460730407E-11
      3.75498608734499E-18  -2.36449554382066E-01  -2.33722737300266E-01   0.00000000000000E+00   4.65209217526634E-14
     -9.79509496246552E-23  -8.65514495087060E-09  -8.65509842994894E-09  -2.93392170469519E-18
      9.57980081523995E-10
      0.00000000000000E+00  -8.63560957120050E-12   0.00000000000000E+00   5.34751234600615E-16   1.19155762170273E-22
      8.63560303737317E-09   8.63560357212452E-09  -8.21072528000114E-19  -2.36441079336757E-01  -2.36441079336776E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95225531652116E-11   0.00000000000000E+00   1.95225531652116E-11
      3.75511786457885E-18  -2.36440467411901E-01  -2.33713641596321E-01   0.00000000000000E+00   4.63427157482915E-14
     -9.79496068914447E-23  -8.65517246800535E-09  -8.65512612528970E-09  -2.93404533657874E-18
      9.67092581523995E-10
      0.00000000000000E+00  -8.63570141593770E-12   0.00000000000000E+00   4.94694028264154E-16   1.19261180941866E-22
      8.63570114770227E-09   8.63570164239642E-09  -8.21083502654267E-19  -2.36428810592358E-01  -2.36428810592377E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94584090574552E-11   0.00000000000000E+00   1.94584090574552E-11
      3.75529517933139E-18  -2.36428272294207E-01  -2.33701435778952E-01   0.00000000000000E+00   4.60763957453821E-14
     -9.79478040483472E-23  -8.65520612784977E-09  -8.65516005145412E-09  -2.93421167667712E-18
      9.79394456523995E-10
      0.00000000000000E+00  -8.63579326067491E-12   0.00000000000000E+00   4.30439247123790E-16   1.19402537530222E-22
      8.63581769098003E-09   8.63581812141940E-09  -8.21098311071526E-19  -2.36412283597178E-01  -2.36412283597198E-01
      0.00000000000000E+00   0.00000000000000E+00   1.93794996764047E-11   0.00000000000000E+00   1.93794996764047E-11
      3.75553358351397E-18  -2.36411956680726E-01  -2.33685108314087E-01   0.00000000000000E+00   4.56612770275555E-14
     -9.79453922734507E-23  -8.65524328237253E-09  -8.65519762109560E-09  -2.93443527244245E-18
      9.96001987773995E-10
      0.00000000000000E+00  -8.63597695014933E-12   0.00000000000000E+00   3.31261588684424E-16   1.19591528397838E-22
      8.63594186201407E-09   8.63594219327578E-09  -8.21118356428931E-19  -2.36390007893553E-01  -2.36390007893572E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92867172317774E-11   0.00000000000000E+00   1.92867172317774E-11
      3.75585388827311E-18  -2.36390247657217E-01  -2.33663389412769E-01   0.00000000000000E+00   4.49927674168234E-14
     -9.79421845479638E-23  -8.65527390327500E-09  -8.65522891050768E-09  -2.93473553184418E-18
      1.01600198777400E-09
      0.00000000000000E+00  -8.63606879488653E-12   0.00000000000000E+00   2.20210771142271E-16   1.19816465908453E-22
      8.63604686385398E-09   8.63604708406487E-09  -8.21142612346979E-19  -2.36363218010979E-01  -2.36363218010998E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91875476510975E-11   0.00000000000000E+00   1.91875476510975E-11
      3.75623763922613E-18  -2.36364646329740E-01  -2.33637786258995E-01   0.00000000000000E+00   4.40702120569083E-14
     -9.79384015115369E-23  -8.65527870192791E-09  -8.65523463171595E-09  -2.93509502687915E-18
      1.03600198777400E-09
      0.00000000000000E+00  -8.63606879488653E-12   0.00000000000000E+00   1.68928266590765E-16   1.20039061303056E-22
      8.63612966506088E-09   8.63612983398926E-09  -8.21166866624289E-19  -2.36336519366438E-01  -2.36336519366457E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90835249088000E-11   0.00000000000000E+00   1.90835249088000E-11
      3.75661930972431E-18  -2.36339635069107E-01  -2.33612781678505E-01   0.00000000000000E+00   4.31436305730476E-14
     -9.79346976859433E-23  -8.65525650252857E-09  -8.65521335889810E-09  -2.93545244310002E-18
      1.05600198777400E-09
      0.00000000000000E+00  -8.63625248436095E-12   0.00000000000000E+00   2.33282230471971E-16   1.20260059549830E-22
      8.63624032854235E-09   8.63624056182470E-09  -8.21190757471612E-19  -2.36310079783247E-01  -2.36310079783266E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89443745278277E-11   0.00000000000000E+00   1.89443745278277E-11
      3.75699819721486E-18  -2.36315177912768E-01  -2.33588333452779E-01   0.00000000000000E+00   4.24506461688979E-14
     -9.79310533498234E-23  -8.65522738699862E-09  -8.65518493635255E-09  -2.93580743974325E-18
      1.06100198777400E-09
      0.00000000000000E+00  -8.63625248436095E-12   0.00000000000000E+00   2.38682002092932E-16   1.20315496161277E-22
      8.63627074635340E-09   8.63627098503552E-09  -8.21196700612066E-19  -2.36303489265384E-01  -2.36303489265403E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89067435750762E-11   0.00000000000000E+00   1.89067435750762E-11
      3.75709273093274E-18  -2.36309097221273E-01  -2.33582255019625E-01   0.00000000000000E+00   4.23150592582054E-14
     -9.79435021097127E-23  -8.65522004366979E-09  -8.65517772861063E-09  -2.93589603032067E-18
      1.06775198777400E-09
      0.00000000000000E+00  -8.63634432909816E-12   0.00000000000000E+00   3.13638711067481E-16   1.20389680751605E-22
      8.63631900526139E-09   8.63631931890022E-09  -8.21204650049628E-19  -2.36294636586639E-01  -2.36294636586658E-01
      0.00000000000000E+00   0.00000000000000E+00   1.88496885061433E-11   0.00000000000000E+00   1.88496885061433E-11
      3.75721996633016E-18  -2.36300945767142E-01  -2.33574106312626E-01   0.00000000000000E+00   4.21266010335532E-14
     -9.79289507140731E-23  -8.65521113400712E-09  -8.65516900740618E-09  -2.93601531628053E-18
      1.07686448777400E-09
      0.00000000000000E+00  -8.63634432909816E-12   0.00000000000000E+00   4.28895868429261E-16   1.20489916802154E-22
      8.63640532531197E-09   8.63640575420796E-09  -8.21215185065284E-19  -2.36282795534772E-01  -2.36282795534791E-01
      0.00000000000000E+00   0.00000000000000E+00   1.87570921335866E-11   0.00000000000000E+00   1.87570921335866E-11
      3.75739089033222E-18  -2.36290029865710E-01  -2.33563192342328E-01   0.00000000000000E+00   4.20133427160336E-14
     -9.79272759863653E-23  -8.65520485968410E-09  -8.65516284634148E-09  -2.93617570526694E-18
      1.08916636277400E-09
      0.00000000000000E+00  -8.63661986330978E-12   0.00000000000000E+00   6.84973161130805E-16   1.20625513842219E-22
      8.63658525985658E-09   8.63658594482987E-09  -8.21228839626255E-19  -2.36267107961077E-01  -2.36267107961095E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85912390957206E-11   0.00000000000000E+00   1.85912390957206E-11
      3.75761959743167E-18  -2.36275388349012E-01  -2.33548546295498E-01   0.00000000000000E+00   4.21647226438585E-14
     -9.79250456788797E-23  -8.65521934864823E-09  -8.65517718392568E-09  -2.93639075780542E-18
      1.10577389402400E-09
      0.00000000000000E+00  -8.63698724225861E-12   0.00000000000000E+00   1.25616862127621E-15   1.20810291181510E-22
      8.63701921334098E-09   8.63702046950972E-09  -8.21245555057596E-19  -2.36246791711881E-01  -2.36246791711899E-01
      0.00000000000000E+00   0.00000000000000E+00   1.82606890170690E-11   0.00000000000000E+00   1.82606890170690E-11
      3.75792286239517E-18  -2.36255513606355E-01  -2.33528638778072E-01   0.00000000000000E+00   4.32029699323888E-14
     -9.79219523706080E-23  -8.65532436149661E-09  -8.65528115852678E-09  -2.93667730733758E-18
      1.12577389402400E-09
      0.00000000000000E+00  -8.63799753436789E-12   0.00000000000000E+00   2.29697557691328E-15   1.21037860760235E-22
      8.63796006280313E-09   8.63796235977883E-09  -8.21261786939852E-19  -2.36224237181659E-01  -2.36224237181676E-01
      0.00000000000000E+00   0.00000000000000E+00   1.76617909884124E-11   0.00000000000000E+00   1.76617909884124E-11
      3.75827609821494E-18  -2.36230650005617E-01  -2.33503667096636E-01   0.00000000000000E+00   4.61203098091755E-14
     -9.79179628270393E-23  -8.65567027107699E-09  -8.65562415076728E-09  -2.93701431127509E-18
      1.13577389402400E-09
      0.00000000000000E+00  -8.63854860279114E-12   0.00000000000000E+00   2.93500187006343E-15   1.21153261979582E-22
      8.63855223321875E-09   8.63855516822074E-09  -8.21268747222730E-19  -2.36213523539889E-01  -2.36213523539906E-01
      0.00000000000000E+00   0.00000000000000E+00   1.73077076988622E-11   0.00000000000000E+00   1.73077076988622E-11
      3.75844917529193E-18  -2.36217871855199E-01  -2.33490813735468E-01   0.00000000000000E+00   4.80102956222035E-14
     -9.79158798389300E-23  -8.65591088621503E-09  -8.65586287591951E-09  -2.93718042806920E-18
      1.14927389402400E-09
      0.00000000000000E+00  -8.63965073963763E-12   0.00000000000000E+00   3.83763106217885E-15   1.21312695913184E-22
      8.63960592139782E-09   8.63960975902900E-09  -8.21275631901534E-19  -2.36200281288710E-01  -2.36200281288727E-01
      0.00000000000000E+00   0.00000000000000E+00   1.67286751591551E-11   0.00000000000000E+00   1.67286751591551E-11
      3.75867501240658E-18  -2.36199660031514E-01  -2.33472452060732E-01   0.00000000000000E+00   5.15648366250949E-14
     -9.79128562103286E-23  -8.65638999902482E-09  -8.65633843418829E-09  -2.93739938050504E-18
      1.16749889402400E-09
      0.00000000000000E+00  -8.64148763438178E-12   0.00000000000000E+00   5.17100922801998E-15   1.21535408691787E-22
      8.64150606176031E-09   8.64151123276966E-09  -8.21279816268974E-19  -2.36184898393373E-01  -2.36184898393389E-01
      0.00000000000000E+00   0.00000000000000E+00   1.58027542057044E-11   0.00000000000000E+00   1.58027542057044E-11
      3.75896301760198E-18  -2.36172448581215E-01  -2.33444933248210E-01   0.00000000000000E+00   5.78007079135254E-14
     -9.79082655844880E-23  -8.65737178768311E-09  -8.65731398697529E-09  -2.93768320133300E-18
      1.18749889402399E-09
      0.00000000000000E+00  -8.64396744228638E-12   0.00000000000000E+00   6.11386587871612E-15   1.21786801351650E-22
      8.64396966539506E-09   8.64397577926106E-09  -8.21279220547205E-19  -2.36170611324860E-01  -2.36170611324875E-01
      0.00000000000000E+00   0.00000000000000E+00   1.47912670349266E-11   0.00000000000000E+00   1.47912670349266E-11
      3.75925884294267E-18  -2.36138544442074E-01  -2.33410571291873E-01   0.00000000000000E+00   6.53456900494132E-14
     -9.79025634341812E-23  -8.65883239198595E-09  -8.65876704629600E-09  -2.93797962239547E-18
      1.20749889402399E-09
      0.00000000000000E+00  -8.64635540545378E-12   0.00000000000000E+00   5.76704554439134E-15   1.22038086603169E-22
      8.64630233681622E-09   8.64630810386188E-09  -8.21277110607752E-19  -2.36157257445142E-01  -2.36157257445156E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41126328579362E-11   0.00000000000000E+00   1.41126328579362E-11
      3.75954109559983E-18  -2.36100567706939E-01  -2.33372073516488E-01   0.00000000000000E+00   7.11992161880092E-14
     -9.78963599864784E-23  -8.66049193593605E-09  -8.66042073671996E-09  -2.93826398499208E-18
      1.22749889402399E-09
      0.00000000000000E+00  -8.64764123177468E-12   0.00000000000000E+00   3.25322196163314E-15   1.22275316067957E-22
      8.64759845151992E-09   8.64760170474201E-09  -8.21280846373882E-19  -2.36141458535837E-01  -2.36141458535851E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42566553497100E-11   0.00000000000000E+00   1.42566553497100E-11
      3.75982622870683E-18  -2.36060091232317E-01  -2.33331144093136E-01   0.00000000000000E+00   7.14332644968857E-14
     -9.78901605419553E-23  -8.66192979335605E-09  -8.66185836009165E-09  -2.93854538233295E-18
      1.24749889402399E-09
      0.00000000000000E+00  -8.64653909492819E-12   0.00000000000000E+00  -2.55012372338902E-15   1.22476997938839E-22
      8.64655231005129E-09   8.64654975992769E-09  -8.21301918132993E-19  -2.36117893601317E-01  -2.36117893601332E-01
      0.00000000000000E+00   0.00000000000000E+00   1.58309014392197E-11   0.00000000000000E+00   1.58309014392197E-11
      3.76014284673561E-18  -2.36021094745715E-01  -2.33291983011943E-01   0.00000000000000E+00   6.11110671003979E-14
     -9.78849205656689E-23  -8.66244177243392E-09  -8.66238066136692E-09  -2.93884092860262E-18
      1.26749889402399E-09
      0.00000000000000E+00  -8.64157947911898E-12   0.00000000000000E+00  -1.21934282144612E-14   1.22615659555623E-22
      8.64160334778141E-09   8.64159115435332E-09  -8.21355215380264E-19  -2.36079611479503E-01  -2.36079611479523E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94334856328166E-11   0.00000000000000E+00   1.94334856328166E-11
      3.76053151644827E-18  -2.35990558955409E-01  -2.33261874406817E-01   0.00000000000000E+00   3.46750338398818E-14
     -9.78820767721190E-23  -8.66105931501978E-09  -8.66102463998604E-09  -2.93917630106801E-18
      1.28749889402399E-09
      0.00000000000000E+00  -8.63129286855174E-12   0.00000000000000E+00  -2.44162277794471E-14   1.22663077397288E-22
      8.63130529149975E-09   8.63128087527210E-09  -8.21456374280602E-19  -2.36019231422404E-01  -2.36019231422430E-01
      0.00000000000000E+00   0.00000000000000E+00   2.54180598064808E-11   0.00000000000000E+00   2.54180598064808E-11
      3.76103987764440E-18  -2.35978437290565E-01  -2.33251115859198E-01   0.00000000000000E+00  -1.30533484006482E-14
     -9.78834258995091E-23  -8.65668588173017E-09  -8.65669893507867E-09  -2.93958350336379E-18
      1.30749889402399E-09
      0.00000000000000E+00  -8.61494450532880E-12   0.00000000000000E+00  -4.01400559849810E-14   1.22600348673162E-22
      8.61497520327580E-09   8.61493506321994E-09  -8.21616534883698E-19  -2.35931351698678E-01  -2.35931351698712E-01
      0.00000000000000E+00   0.00000000000000E+00   3.35458193848819E-11   0.00000000000000E+00   3.35458193848819E-11
      3.76171079403209E-18  -2.35996465921470E-01  -2.33271733352714E-01   0.00000000000000E+00  -7.94172301533361E-14
     -9.78907526686095E-23  -8.64840146537450E-09  -8.64848088260476E-09  -2.94009425914840E-18
      1.32749889402399E-09
      0.00000000000000E+00  -8.59354468155945E-12   0.00000000000000E+00  -4.97016189667858E-14   1.22433315842807E-22
      8.59361958271537E-09   8.59356988109652E-09  -8.21834134822044E-19  -2.35816351781448E-01  -2.35816351781490E-01
      0.00000000000000E+00   0.00000000000000E+00   4.25526402000617E-11   0.00000000000000E+00   4.25526402000617E-11
      3.76256184683610E-18  -2.36055276329152E-01  -2.33334438227979E-01   0.00000000000000E+00  -1.62520305874840E-13
     -9.79051504240604E-23  -8.63596000099061E-09  -8.63612252129658E-09  -2.94072771201405E-18
      1.34749889402399E-09
      0.00000000000000E+00  -8.57095087620640E-12   0.00000000000000E+00  -5.59884577569045E-14   1.22211822477057E-22
      8.57102703422397E-09   8.57097104576634E-09  -8.22084386369797E-19  -2.35685312765804E-01  -2.35685312765854E-01
      0.00000000000000E+00   0.00000000000000E+00   4.97347096487682E-11   0.00000000000000E+00   4.97347096487682E-11
      3.76355654102907E-18  -2.36159384768474E-01  -2.33443402817911E-01   0.00000000000000E+00  -2.33570263523124E-13
     -9.79259886533955E-23  -8.62047218515156E-09  -8.62070575541518E-09  -2.94147215465927E-18
      1.36749889402399E-09
      0.00000000000000E+00  -8.55469435772066E-12   0.00000000000000E+00  -4.06388162239752E-14   1.22049282646550E-22
      8.55474328688466E-09   8.55470264806856E-09  -8.22308223932897E-19  -2.35565237875544E-01  -2.35565237875595E-01
      0.00000000000000E+00   0.00000000000000E+00   5.07179972077873E-11   0.00000000000000E+00   5.07179972077873E-11
      3.76457090097323E-18  -2.36300255102602E-01  -2.33589088804071E-01   0.00000000000000E+00  -2.68364139013005E-13
     -9.79496531057848E-23  -8.60515228113712E-09  -8.60542064527624E-09  -2.94226267704033E-18
      1.38749889402399E-09
      0.00000000000000E+00  -8.55653125246481E-12   0.00000000000000E+00   4.09883955473822E-15   1.22135056893967E-22
      8.55648832533604E-09   8.55649242417572E-09  -8.22404873606253E-19  -2.35502668717307E-01  -2.35502668717347E-01
      0.00000000000000E+00   0.00000000000000E+00   3.96783974545677E-11   0.00000000000000E+00   3.96783974545677E-11
      3.76536446892232E-18  -2.36448206337213E-01  -2.33739954414907E-01   0.00000000000000E+00  -2.16735070408998E-13
     -9.79683217362705E-23  -8.59595408655985E-09  -8.59617082163036E-09  -2.94295959531607E-18
      1.39749889402399E-09
      0.00000000000000E+00  -8.56360329722979E-12   0.00000000000000E+00   3.49430886318125E-14   1.22268977823377E-22
      8.56357274064866E-09   8.56360768373741E-09  -8.22406162612431E-19  -2.35492823842557E-01  -2.35492823842587E-01
      0.00000000000000E+00   0.00000000000000E+00   3.03657023181214E-11   0.00000000000000E+00   3.03657023181214E-11
      3.76566812594550E-18  -2.36518640490138E-01  -2.33811080991527E-01   0.00000000000000E+00  -1.62516311673647E-13
     -9.79751760112920E-23  -8.59381086974363E-09  -8.59397338605540E-09  -2.94326196333307E-18
      1.41099889402399E-09
      0.00000000000000E+00  -8.58959535785952E-12   0.00000000000000E+00   9.71915475036579E-14   1.22701171266651E-22
      8.58947621584094E-09   8.58957340738857E-09  -8.22275785500280E-19  -2.35540199221211E-01  -2.35540199221220E-01
      0.00000000000000E+00   0.00000000000000E+00   8.79616612928403E-12   0.00000000000000E+00   8.79616612928403E-12
      3.76578687418825E-18  -2.36587997496339E-01  -2.33879053820100E-01   0.00000000000000E+00  -2.15258122347163E-14
     -9.79755258910285E-23  -8.59834804770560E-09  -8.59836957351794E-09  -2.94351108868796E-18
      1.42922389402399E-09
      0.00000000000000E+00  -8.66747969501151E-12   0.00000000000000E+00   2.21442554419677E-13   1.23985484208091E-22
      8.66728645310726E-09   8.66750789566181E-09  -8.21728308320446E-19  -2.35776008787767E-01  -2.35776008787726E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.08825397871549E-11   0.00000000000000E+00  -4.08825397871549E-11
      3.76504178990062E-18  -2.36563611804161E-01  -2.33845768660321E-01   0.00000000000000E+00   3.33196537458233E-13
     -9.79463352596085E-23  -8.62695855241194E-09  -8.62662535587458E-09  -2.94331348158018E-18
      1.44922389402399E-09
      0.00000000000000E+00  -8.81755399560861E-12   0.00000000000000E+00   3.97224733392277E-13   1.26527225697916E-22
      8.81723359858416E-09   8.81763082331767E-09  -8.20529283356783E-19  -2.36313600811355E-01  -2.36313600811234E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21076102528032E-10   0.00000000000000E+00  -1.21076102528032E-10
      3.76262026785006E-18  -2.36271137646118E-01  -2.33531268050575E-01   0.00000000000000E+00   9.42843015958872E-13
     -9.78583486643327E-23  -8.69749756380554E-09  -8.69655472078967E-09  -2.94209098449328E-18
      1.46922389402399E-09
      0.00000000000000E+00  -9.03256252541143E-12   0.00000000000000E+00   5.63500911305035E-13   1.30315580478569E-22
      9.03203430820616E-09   9.03259780911759E-09  -8.18678602348142E-19  -2.37157846617310E-01  -2.37157846617091E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.19244774856776E-10   0.00000000000000E+00  -2.19244774856776E-10
      3.75823537235293E-18  -2.35578722620307E-01  -2.32802056840704E-01   0.00000000000000E+00   1.74916747066973E-12
     -9.76970281981945E-23  -8.81510220173138E-09  -8.81335303426081E-09  -2.93955677000479E-18
      1.48922389402399E-09
      0.00000000000000E+00  -9.28862565274601E-12   0.00000000000000E+00   6.55296700986990E-13   1.35092601231079E-22
      9.28798561790922E-09   9.28864091461034E-09  -8.16317997664493E-19  -2.38247339531606E-01  -2.38247339531291E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.14871714611083E-10   0.00000000000000E+00  -3.14871714611083E-10
      3.75193793806071E-18  -2.34382393709209E-01  -2.31555184364235E-01   0.00000000000000E+00   2.61699762952391E-12
     -9.74582502991812E-23  -8.97638619762862E-09  -8.97376919999920E-09  -2.93561994039621E-18
      1.50922389402399E-09
      0.00000000000000E+00  -9.52503400631818E-12   0.00000000000000E+00   5.88402574524960E-13   1.39975584977605E-22
      9.52444561006645E-09   9.52503401264111E-09  -8.13889174756471E-19  -2.39382540625783E-01  -2.39382540625412E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.70990610070289E-10   0.00000000000000E+00  -3.70990610070289E-10
      3.74451812585930E-18  -2.32677986659331E-01  -2.29793974094503E-01   0.00000000000000E+00   3.27196611457780E-12
     -9.71615208195563E-23  -9.15731536868542E-09  -9.15404340257094E-09  -2.93062895110283E-18
      1.52922389402399E-09
      0.00000000000000E+00  -9.63304341727424E-12   0.00000000000000E+00   3.24341702168006E-13   1.43217130489974E-22
      9.63279572773773E-09   9.63312006944004E-09  -8.12223955248385E-19  -2.40182710884929E-01  -2.40182710884597E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.32217478294265E-10   0.00000000000000E+00  -3.32217478294265E-10
      3.73787377629342E-18  -2.30661181089378E-01  -2.27730914990962E-01   0.00000000000000E+00   3.22466854853075E-12
     -9.68654562103879E-23  -9.30412725969422E-09  -9.30090259114578E-09  -2.92564982104503E-18
      1.54922389402399E-09
      0.00000000000000E+00  -9.45422171393118E-12   0.00000000000000E+00  -4.40109214542457E-13   1.42123795265361E-22
      9.45466411507857E-09   9.45422400586417E-09  -8.12604774249691E-19  -2.40054806580113E-01  -2.40054806579986E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.26315306805216E-10   0.00000000000000E+00  -1.26315306805216E-10
      3.73534747015731E-18  -2.28838306690968E-01  -2.25899512425255E-01   0.00000000000000E+00   2.11434676906734E-12
     -9.66813872956038E-23  -9.33002304582788E-09  -9.32790869905891E-09  -2.92274269590762E-18
      1.56922389402399E-09
      0.00000000000000E+00  -8.80478757713676E-12   0.00000000000000E+00  -1.60759536624829E-12   1.33434893503674E-22
      8.80643420956676E-09   8.80482661420064E-09  -8.16750626456581E-19  -2.38194183830437E-01  -2.38194183830760E-01
      0.00000000000000E+00   0.00000000000000E+00   3.22778050532006E-10   0.00000000000000E+00   3.22778050532006E-10
      3.74180303116795E-18  -2.28085761736012E-01  -2.25210070924106E-01   0.00000000000000E+00  -8.79726504940252E-13
     -9.67826222917581E-23  -9.12672493822753E-09  -9.12760466473257E-09  -2.92505240471137E-18
      1.58922389402399E-09
      0.00000000000000E+00  -7.54605545370761E-12   0.00000000000000E+00  -3.12223844356735E-12   1.14524374926810E-22
      7.54913415322476E-09   7.54601191478131E-09  -8.26660180635198E-19  -2.33649211202539E-01  -2.33649211203599E-01
      0.00000000000000E+00   0.00000000000000E+00   1.06053637796795E-09   0.00000000000000E+00   1.06053637796795E-09
      3.76301375872731E-18  -2.29526132126683E-01  -2.26814599105595E-01   0.00000000000000E+00  -6.36589535112684E-12
     -9.73859177861665E-23  -8.60018239739810E-09  -8.60654829274932E-09  -2.93635357809211E-18
      1.60922389402399E-09
      0.00000000000000E+00  -5.70649721217805E-12   0.00000000000000E+00  -4.57186787749039E-12   8.54591430474818E-23
      5.71107759778406E-09   5.70650572990666E-09  -8.44122694544017E-19  -2.25537980665763E-01  -2.25537980667801E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03802455885144E-09   0.00000000000000E+00   2.03802455885144E-09
      3.80377424990434E-18  -2.34093478805282E-01  -2.31653524824916E-01   0.00000000000000E+00  -1.47148242342031E-11
     -9.86907901882261E-23  -7.72981546452374E-09  -7.74453028875805E-09  -2.95965155536032E-18
      1.62922389402399E-09
      0.00000000000000E+00  -3.59324165377007E-12   0.00000000000000E+00  -5.27025816522688E-12   5.06897772861641E-23
      3.59848401205293E-09   3.59321375388776E-09  -8.69698226467737E-19  -2.13514258766396E-01  -2.13514258769446E-01
      0.00000000000000E+00   0.00000000000000E+00   3.05026103681958E-09   0.00000000000000E+00   3.05026103681958E-09
      3.86477947064073E-18  -2.41891205398384E-01  -2.39798139614997E-01   0.00000000000000E+00  -2.53410288097101E-11
     -1.00770554719006E-22  -6.61813376189749E-09  -6.64347479070730E-09  -2.99508124417299E-18
      1.64922389402399E-09
      0.00000000000000E+00  -1.75809195962648E-12   0.00000000000000E+00  -4.60801386655865E-12   1.80510289493047E-23
      1.76270596605451E-09   1.75809795218797E-09  -9.01063803445234E-19  -1.98559876638835E-01  -1.98559876642570E-01
      0.00000000000000E+00   0.00000000000000E+00   3.73481116119928E-09   0.00000000000000E+00   3.73481116119928E-09
      3.93947569386472E-18  -2.51907063288437E-01  -2.50176484170817E-01   0.00000000000000E+00  -3.56578758683637E-11
     -1.03457566376288E-22  -5.45725123751889E-09  -5.49290911338735E-09  -3.03841189041948E-18
      1.66922389402399E-09
      0.00000000000000E+00  -7.50463347722701E-13   0.00000000000000E+00  -2.57679169013661E-12  -5.32496231310475E-24
      7.52971465910973E-10   7.50394674220831E-10  -9.31471980718956E-19  -1.83821670313327E-01  -1.83821670317005E-01
      0.00000000000000E+00   0.00000000000000E+00   3.67759798855958E-09   0.00000000000000E+00   3.67759798855958E-09
      4.01302765363591E-18  -2.62620626959217E-01  -2.61225553823588E-01   0.00000000000000E+00  -4.05042083971949E-11
     -1.06283023793045E-22  -4.38748845438299E-09  -4.42799266278029E-09  -3.08155567291695E-18
      1.68922389402399E-09
      0.00000000000000E+00  -8.08601066375066E-13   0.00000000000000E+00   7.65589772450815E-14  -1.61374601404556E-23
      8.08517604496683E-10   8.08594163473912E-10  -9.50950619386997E-19  -1.74201216783324E-01  -1.74201216785981E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65717754460275E-09   0.00000000000000E+00   2.65717754460275E-09
      4.06617120452796E-18  -2.72893047711592E-01  -2.71801133509062E-01   0.00000000000000E+00  -3.43472816208930E-11
     -1.08554113018391E-22  -3.43142442645569E-09  -3.46577170807670E-09  -3.11522058514096E-18
      1.70922389402399E-09
      0.00000000000000E+00  -1.77930809392142E-12   0.00000000000000E+00   2.38555844393872E-12  -1.58219711421021E-23
      1.77688533379347E-09   1.77927089223739E-09  -9.51614272503334E-19  -1.73710077633983E-01  -1.73710077634889E-01
      0.00000000000000E+00   0.00000000000000E+00   9.05679690850864E-10   0.00000000000000E+00   9.05679690850864E-10
      4.08428479834498E-18  -2.82035724122451E-01  -2.81189826592989E-01   0.00000000000000E+00  -1.69487574801387E-11
     -1.09659271622649E-22  -2.66800182560797E-09  -2.68495058308822E-09  -3.13267052584165E-18
      1.72922389402399E-09
      0.00000000000000E+00  -3.37070185551623E-12   0.00000000000000E+00   3.98014259876532E-12  -3.22515859056820E-24
      3.36672470621337E-09   3.37070484881213E-09  -9.32412468453854E-19  -1.82833255139587E-01  -1.82833255138597E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.89940428428282E-10   0.00000000000000E+00  -9.89940428428282E-10
      4.06448598977641E-18  -2.89296958031182E-01  -2.88546917102311E-01   0.00000000000000E+00   4.37357423642939E-12
     -1.09405147629881E-22  -2.38513799462022E-09  -2.38076442038390E-09  -3.13207352132256E-18
      1.74922389402399E-09
      0.00000000000000E+00  -5.46503739805946E-12   0.00000000000000E+00   5.25808174065492E-12   2.66033665091748E-23
      5.45981135414437E-09   5.46506943588505E-09  -8.99071959245706E-19  -1.98543382678457E-01  -1.98543382675973E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.48304749392946E-09   0.00000000000000E+00  -2.48304749392946E-09
      4.01482503989783E-18  -2.93612621838525E-01  -2.92673175262934E-01   0.00000000000000E+00   2.07235230401030E-11
     -1.08046848505476E-22  -3.00274546499560E-09  -2.98202194195560E-09  -3.11575308065212E-18
      1.76922389402399E-09
      0.00000000000000E+00  -8.15140411664241E-12   0.00000000000000E+00   6.72165212385669E-12   7.66430898679581E-23
      8.14466581539154E-09   8.15138746751547E-09  -8.60251005914835E-19  -2.16524837107853E-01  -2.16524837104504E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.34952031614152E-09   0.00000000000000E+00  -3.34952031614152E-09
      3.94783463357500E-18  -2.93850845752351E-01  -2.92338068574791E-01   0.00000000000000E+00   2.85879573454645E-11
     -1.06023928802388E-22  -4.83045510871933E-09  -4.80186715137397E-09  -3.08758362766016E-18
      1.78922389402399E-09
      0.00000000000000E+00  -1.14658969929876E-11   0.00000000000000E+00   8.25815651165964E-12   1.45793299748463E-22
      1.14577109719656E-08   1.14659691284774E-08  -8.22946930528965E-19  -2.33582906405113E-01  -2.33582906401328E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.78510363499440E-09   0.00000000000000E+00  -3.78510363499440E-09
      3.87213256087511E-18  -2.88350125046216E-01  -2.85930318223065E-01   0.00000000000000E+00   3.20862379424776E-11
     -1.03568664543326E-22  -7.71295173142540E-09  -7.68086549348302E-09  -3.04918563034614E-18
      1.80922389402399E-09
      0.00000000000000E+00  -1.52862706818719E-11   0.00000000000000E+00   9.49037597619513E-12   2.28109569072846E-22
      1.52767837559576E-08   1.52862741319340E-08  -7.89882792562908E-19  -2.48700821765171E-01  -2.48700821760978E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.19284857116558E-09   0.00000000000000E+00  -4.19284857116558E-09
      3.78827558945180E-18  -2.75093110443114E-01  -2.71598157349245E-01   0.00000000000000E+00   3.61836994572028E-11
     -1.00604818159190E-22  -1.11296092602255E-08  -1.10934255607684E-08  -2.99839279688889E-18
      1.82922389402399E-09
      0.00000000000000E+00  -1.96256589807159E-11   0.00000000000000E+00   1.07665018692599E-11   3.20406212580766E-22
      1.96149048492189E-08   1.96256713510885E-08  -7.59751321138202E-19  -2.62679286761880E-01  -2.62679286756945E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.93532298726117E-09   0.00000000000000E+00  -4.93532298726117E-09
      3.68956912970657E-18  -2.52403046187071E-01  -2.47774841677653E-01   0.00000000000000E+00   4.14092855896348E-11
     -9.68777089756700E-23  -1.47317576494169E-08  -1.46903483638273E-08  -2.92981780856837E-18
      1.84922389402399E-09
      0.00000000000000E+00  -2.39419024057837E-11   0.00000000000000E+00   1.07084416242911E-11   4.13594368095331E-22
      2.39312293227900E-08   2.39419377644147E-08  -7.32492894490161E-19  -2.75711247786794E-01  -2.75711247780877E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.91678570438260E-09   0.00000000000000E+00  -5.91678570438260E-09
      3.57123341561892E-18  -2.19057340321699E-01  -2.13378437930554E-01   0.00000000000000E+00   4.47886126320356E-11
     -9.21828469140188E-23  -1.80699406726641E-08  -1.80251520600322E-08  -2.83874052112876E-18
      1.86922389402399E-09
      0.00000000000000E+00  -2.68413489146881E-11   0.00000000000000E+00   7.20857470761311E-12   4.82200931651432E-22
      2.68341025347937E-08   2.68413111095018E-08  -7.10884336294933E-19  -2.86661567091535E-01  -2.86661567084878E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.65653352218777E-09   0.00000000000000E+00  -6.65653352218777E-09
      3.43810274517516E-18  -1.76375933547257E-01  -1.70016562801417E-01   0.00000000000000E+00   4.33974750359569E-11
     -8.67874778004972E-23  -2.02281750623498E-08  -2.01847775873140E-08  -2.72721840888023E-18
      1.88922389402399E-09
      0.00000000000000E+00  -2.78818579425121E-11   0.00000000000000E+00   2.60793514870803E-12   5.11742903638440E-22
      2.78792555267046E-08   2.78818634618538E-08  -6.95109232006691E-19  -2.95410857487673E-01  -2.95410857480623E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.04995903940716E-09   0.00000000000000E+00  -7.04995903940716E-09
      3.29710356438702E-18  -1.29345066552909E-01  -1.22781754168893E-01   0.00000000000000E+00   3.73952618042752E-11
     -7.81464065439034E-23  -2.08692996842508E-08  -2.08319044224466E-08  -2.60199433238033E-18
      1.90922389402399E-09
      0.00000000000000E+00  -2.74354006749464E-11   0.00000000000000E+00  -1.07569293947665E-12   5.05893405792745E-22
      2.74364433892728E-08   2.74353676963338E-08  -6.82586421462495E-19  -3.02935186451646E-01  -3.02935186444445E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.20119191813872E-09   0.00000000000000E+00  -7.20119191813872E-09
      3.15307972602425E-18  -8.47418506437533E-02  -7.83668145144903E-02   0.00000000000000E+00   2.91048205860163E-11
     -2.74529685689238E-23  -2.02632805987811E-08  -2.02341757781952E-08  -2.47049330456175E-18
      1.92922389402399E-09
      0.00000000000000E+00  -2.55957505886796E-11   0.00000000000000E+00  -4.32842276462715E-12   4.88049110827898E-22
      2.56002388100524E-08   2.55959103872883E-08  -6.67119318573097E-19  -3.11475605222635E-01  -3.11475605215516E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.11883040268390E-09   0.00000000000000E+00  -7.11883040268390E-09
      3.01070311797057E-18  -5.06413721891365E-02  -4.48199628640997E-02   0.00000000000000E+00   2.11787075280489E-11
      1.32642112028246E-22  -1.84982586921326E-08  -1.84770799846044E-08  -2.34358379939747E-18
      1.94922389402399E-09
      0.00000000000000E+00  -2.29766142177326E-11   0.00000000000000E+00  -6.42265021370318E-12   4.91679028089227E-22
      2.29830472398087E-08   2.29766245895955E-08  -6.42719183433562E-19  -3.23118645394753E-01  -3.23118645387918E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.83533199327077E-09   0.00000000000000E+00  -6.83533199327077E-09
      2.87399647810515E-18  -3.10323770644704E-02  -2.59468194966887E-02   0.00000000000000E+00   1.52646543062888E-11
      3.39080029222642E-22  -1.61565572506313E-08  -1.61412925963247E-08  -2.23127729467159E-18
      1.96922389402399E-09
      0.00000000000000E+00  -2.09324259017046E-11   0.00000000000000E+00  -5.01261161430595E-12   5.08907600845183E-22
      2.09374263208299E-08   2.09324137092161E-08  -6.12054861569493E-19  -3.36910329113187E-01  -3.36910329106607E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.58027688263166E-09   0.00000000000000E+00  -6.58027688263166E-09
      2.74239094045252E-18  -2.13335544604963E-02  -1.68116857807866E-02   0.00000000000000E+00   1.01679685248784E-11
      5.14112992051396E-22  -1.43623047951099E-08  -1.43521368265845E-08  -2.13033607888303E-18
      1.98922389402399E-09
      0.00000000000000E+00  -1.96796636861940E-11   0.00000000000000E+00  -3.05900609190910E-12   5.15290971829821E-22
      1.96827040218425E-08   1.96796450157511E-08  -5.79477156756624E-19  -3.51344576584319E-01  -3.51344576577871E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.44840658163521E-09   0.00000000000000E+00  -6.44840658163521E-09
      2.61342280881982E-18  -1.63329224592130E-02  -1.21642049906733E-02   0.00000000000000E+00   6.91380139291460E-12
      6.24083962904657E-22  -1.32381522355094E-08  -1.32312384341159E-08  -2.03394565206319E-18
      2.00922389402399E-09
      0.00000000000000E+00  -1.89794394097238E-11   0.00000000000000E+00  -1.69513663082271E-12   5.03114137509216E-22
      1.89811583099389E-08   1.89794631733086E-08  -5.46531484342709E-19  -3.65943870458479E-01  -3.65943870452011E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46848987879474E-09   0.00000000000000E+00  -6.46848987879474E-09
      2.48405301124392E-18  -1.34199581464134E-02  -9.47816801873392E-03   0.00000000000000E+00   5.25245364742465E-12
      6.72003810117167E-22  -1.25162257481620E-08  -1.25109732945139E-08  -1.93752152690122E-18
      2.02922389402399E-09
      0.00000000000000E+00  -1.87886778905437E-11   0.00000000000000E+00  -4.38452776770086E-13   4.73692516812634E-22
      1.87891382836827E-08   1.87886998309064E-08  -5.12444793146896E-19  -3.81086149619210E-01  -3.81086149612471E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73863214511400E-09   0.00000000000000E+00  -6.73863214511400E-09
      2.34928036834164E-18  -1.15568467001371E-02  -7.76026939075202E-03   0.00000000000000E+00   4.40299088761309E-12
      6.71410735518925E-22  -1.20544706766807E-08  -1.20500676857924E-08  -1.83683557519475E-18
      2.04922389402399E-09
      0.00000000000000E+00  -1.88425907512846E-11   0.00000000000000E+00   1.65916468193099E-13   4.29206847666156E-22
      1.88423944520060E-08   1.88425603684746E-08  -4.77293483584655E-19  -3.96732765173368E-01  -3.96732765166314E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.05461966494772E-09   0.00000000000000E+00  -7.05461966494772E-09
      2.20818797504269E-18  -1.02839212594023E-02  -6.56992862863708E-03   0.00000000000000E+00   3.81462905963207E-12
      6.31426387190366E-22  -1.17917553325871E-08  -1.17879407035268E-08  -1.73089449145803E-18
      2.06922389402399E-09
      0.00000000000000E+00  -1.88331307433522E-11   0.00000000000000E+00   9.19947719979137E-15   3.69839887822748E-22
      1.88331643999068E-08   1.88331735993843E-08  -4.42239516999105E-19  -4.12358650864239E-01  -4.12358650857059E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.18073113317692E-09   0.00000000000000E+00  -7.18073113317692E-09
      2.06457335237915E-18  -9.35679943953757E-03  -5.68549501116100E-03   0.00000000000000E+00   3.33723027799438E-12
      5.57010357066872E-22  -1.16557796964859E-08  -1.16524424662074E-08  -1.62233383538004E-18
      2.07922389402399E-09
      0.00000000000000E+00  -1.88127412116921E-11   0.00000000000000E+00  -6.99598470476411E-14   3.34778887103762E-22
      1.88128766669847E-08   1.88128067071380E-08  -4.24849668608652E-19  -4.20111497167002E-01  -4.20111497159775E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.22696416157375E-09   0.00000000000000E+00  -7.22696416157375E-09
      1.99230371076341E-18  -8.97198543289836E-03  -5.32166314550017E-03   0.00000000000000E+00   3.18561763320131E-12
      5.07927307845246E-22  -1.15890281631982E-08  -1.15858425455645E-08  -1.56745404215476E-18
      2.09272389402399E-09
      0.00000000000000E+00  -1.87445924166841E-11   0.00000000000000E+00  -2.20043130568760E-13   2.86460094030599E-22
      1.87448588477190E-08   1.87446388045887E-08  -4.01715156756084E-19  -4.30406192424160E-01  -4.30406192417001E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.15865155824970E-09   0.00000000000000E+00  -7.15865155824970E-09
      1.89566191472704E-18  -8.55838515515835E-03  -4.90801549615131E-03   0.00000000000000E+00   2.74546500280947E-12
      4.37702434796864E-22  -1.15887327113422E-08  -1.15859872463390E-08  -1.49394675797096E-18
      2.11094889402399E-09
      0.00000000000000E+00  -1.85081840631120E-11   0.00000000000000E+00  -6.13547714164076E-13   2.22691386355272E-22
      1.85087919446078E-08   1.85081783968939E-08  -3.72167337156059E-19  -4.43511685592036E-01  -4.43511685585218E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.81752986666926E-09   0.00000000000000E+00  -6.81752986666926E-09
      1.77141243290699E-18  -8.13639577371848E-03  -4.45304843213504E-03   0.00000000000000E+00   2.22295763622572E-12
      3.41626966720750E-22  -1.16928714878612E-08  -1.16906485302246E-08  -1.39924509575093E-18
      2.13094889402399E-09
      0.00000000000000E+00  -1.74744715458412E-11   0.00000000000000E+00  -2.52680725265168E-12   1.58193904469081E-22
      1.74770264049941E-08   1.74744995977416E-08  -3.46280752962980E-19  -4.54995819119623E-01  -4.54995819114042E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58157141118789E-09   0.00000000000000E+00  -5.58157141118789E-09
      1.65978100468324E-18  -7.75640982805355E-03  -4.00932829553415E-03   0.00000000000000E+00   1.43064595778342E-12
      2.42322053350440E-22  -1.18943588325118E-08  -1.18929281865538E-08  -1.31350025172026E-18
      2.15094889402399E-09
      0.00000000000000E+00  -1.44160417968306E-11   0.00000000000000E+00  -7.52744064069811E-12   1.04158379642369E-22
      1.44235771112762E-08   1.44160496706356E-08  -3.37144048328741E-19  -4.59213801216324E-01  -4.59213801213944E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.37985989961142E-09   0.00000000000000E+00  -2.37985989961142E-09
      1.61218380669101E-18  -7.28278751375043E-03  -3.49056687861112E-03   0.00000000000000E+00   3.49793136115970E-13
      1.58964584389991E-22  -1.20365395641604E-08  -1.20361897710242E-08  -1.27503975836227E-18
      2.17094889402399E-09
      0.00000000000000E+00  -8.71147332413391E-12   0.00000000000000E+00  -1.40681311975697E-11   6.29032619933235E-23
      8.72549803602665E-09   8.71142990482914E-09  -3.58907684927158E-19  -4.50306990413421E-01  -4.50306990416795E-01
      0.00000000000000E+00   0.00000000000000E+00   3.37379734609715E-09   0.00000000000000E+00   3.37379734609715E-09
      1.67965975361295E-18  -6.66265595923744E-03  -2.85498394611358E-03   0.00000000000000E+00  -1.61080390848654E-12
      9.55806057954192E-23  -1.20836164470179E-08  -1.20852272509263E-08  -1.32075206868579E-18
      2.19094889402399E-09
      0.00000000000000E+00  -1.65430740658197E-12   0.00000000000000E+00  -1.74350646116563E-11   2.97744823408229E-23
      1.67177092082633E-09   1.65433585621470E-09  -4.23725444997067E-19  -4.23890852360632E-01  -4.23890852371045E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04129161549653E-08   0.00000000000000E+00   1.04129161549653E-08
      1.88791807671226E-18  -6.05671300500005E-03  -2.25470440120001E-03   0.00000000000000E+00  -4.90276788339974E-12
      4.32949484352116E-23  -1.20623492432966E-08  -1.20672520111800E-08  -1.46419263171519E-18
      2.21094889402399E-09
      0.00000000000000E+00   4.04392377924740E-12   0.00000000000000E+00  -1.41530208780153E-11  -4.27147725173448E-24
     -4.02976730618681E-09  -4.04392032706483E-09  -5.35927361137563E-19  -3.79095610353792E-01  -3.79095610369808E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60158087756641E-08   0.00000000000000E+00   1.60158087756641E-08
      2.20823425222554E-18  -5.91878955355405E-03  -2.14682905388453E-03   0.00000000000000E+00  -1.02048146445329E-11
     -1.55268463970897E-23  -1.19616836339549E-08  -1.19718884485994E-08  -1.67230689108798E-18
      2.23094889402399E-09
      0.00000000000000E+00   6.47891145209335E-12   0.00000000000000E+00  -6.21655843813149E-12  -3.19225878117549E-23
     -6.47268816377657E-09  -6.47890472221473E-09  -6.83977332267517E-19  -3.19056870679418E-01  -3.19056870697534E-01
      0.00000000000000E+00   0.00000000000000E+00   1.81162414229295E-08   0.00000000000000E+00   1.81162414229295E-08
      2.57055908068413E-18  -7.85343707253725E-03  -4.18688653647566E-03   0.00000000000000E+00  -1.89409086011301E-11
     -6.42895598137692E-23  -1.16183957921136E-08  -1.16373367007148E-08  -1.88658174841661E-18
      2.25094889402399E-09
      0.00000000000000E+00   6.73130078993964E-12   0.00000000000000E+00  -9.36025248869913E-13  -4.10962816579539E-23
     -6.73038725626381E-09  -6.73132328151273E-09  -8.35474304744986E-19  -2.52601728981073E-01  -2.52601728998326E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72530282619041E-08   0.00000000000000E+00   1.72530282619041E-08
      2.91561964592221E-18  -1.70235981928719E-02  -1.37085505108425E-02   0.00000000000000E+00  -3.23006097222070E-11
     -7.89533159037134E-23  -1.04894043706691E-08  -1.05217049803914E-08  -2.08014534117722E-18
      2.27094889402399E-09
      0.00000000000000E+00   6.34004220943557E-12   0.00000000000000E+00   5.66853276569971E-13  -4.33289756731136E-23
     -6.34064322619011E-09  -6.34007637291358E-09  -9.67622953534055E-19  -1.88771368464253E-01  -1.88771368479605E-01
      0.00000000000000E+00   0.00000000000000E+00   1.53524320155730E-08   0.00000000000000E+00   1.53524320155730E-08
      3.22266828623367E-18  -3.53532735263156E-02  -3.25137709685278E-02   0.00000000000000E+00  -5.22633322733378E-11
     -8.61598802137772E-23  -8.96009231038601E-09  -9.01235564265943E-09  -2.25504533269962E-18
      2.29094889402399E-09
      0.00000000000000E+00   5.49112130342640E-12   0.00000000000000E+00   1.62493259621460E-12  -4.50504065720323E-23
     -5.49278727859814E-09  -5.49116234600197E-09  -1.07768454518385E-18  -1.31104159731600E-01  -1.31104159744870E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32701236352984E-08   0.00000000000000E+00   1.32701236352984E-08
      3.48807075893964E-18  -5.99547986797613E-02  -5.75038957990578E-02   0.00000000000000E+00  -7.87274310538139E-11
     -9.49540246275846E-23  -7.70023385824250E-09  -7.77896128929641E-09  -2.41038621375579E-18
      2.30094889402399E-09
      0.00000000000000E+00   4.85353513773175E-12   0.00000000000000E+00   2.62490457351276E-12  -4.58189515040347E-23
     -4.85611371688591E-09  -4.85348881231244E-09  -1.12590121027016E-18  -1.04456087654257E-01  -1.04456087666195E-01
      0.00000000000000E+00   0.00000000000000E+00   1.19383087052432E-08   0.00000000000000E+00   1.19383087052432E-08
      3.60745384599207E-18  -7.38596831206969E-02  -7.16274721617590E-02   0.00000000000000E+00  -1.01144472926166E-10
     -9.92977394868179E-23  -6.98367542000435E-09  -7.08481989293062E-09  -2.48155263572191E-18
      2.31444889402399E-09
      0.00000000000000E+00   3.99855247906688E-12   0.00000000000000E+00   2.63283760452620E-12  -4.66804178466481E-23
     -4.00120096503228E-09  -3.99856812742780E-09  -1.17909832189253E-18  -7.39343898369443E-02  -7.39343898472697E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03254284288073E-08   0.00000000000000E+00   1.03254284288073E-08
      3.74684712978097E-18  -9.46481147179962E-02  -9.26547124359035E-02   0.00000000000000E+00  -1.15162834450072E-10
     -1.05012480121247E-22  -6.21169746692929E-09  -6.32686030137946E-09  -2.56774880788844E-18
      2.33267389402399E-09
      0.00000000000000E+00   2.68223370540861E-12   0.00000000000000E+00   3.18564352139680E-12  -4.74242006342762E-23
     -2.68542471806505E-09  -2.68223907454370E-09  -1.22675180637111E-18  -4.54409186638497E-02  -4.54409186717842E-02
      0.00000000000000E+00   0.00000000000000E+00   7.93440474562477E-09   0.00000000000000E+00   7.93440474562477E-09
      3.89145165626998E-18  -1.26033158016746E-01  -1.24378358917759E-01   0.00000000000000E+00  -1.23435278272925E-10
     -1.12165719254046E-22  -5.12873039280798E-09  -5.25216567108102E-09  -2.66469984989887E-18
      2.35267389402399E-09
      0.00000000000000E+00   1.40155068978686E-12   0.00000000000000E+00   2.95125947153251E-12  -4.77988426149000E-23
     -1.40453902454398E-09  -1.40158776507249E-09  -1.25341662368830E-18  -2.87730788563417E-02  -2.87730788618737E-02
      0.00000000000000E+00   0.00000000000000E+00   5.53202665061378E-09   0.00000000000000E+00   5.53202665061378E-09
      4.00209218928225E-18  -1.62613005833413E-01  -1.61311626212609E-01   0.00000000000000E+00  -1.23921255061375E-10
     -1.19086330953003E-22  -4.00651763047977E-09  -4.13043888554127E-09  -2.74867556559395E-18
      2.37267389402399E-09
      0.00000000000000E+00   6.84243292196074E-13   0.00000000000000E+00   1.67815578231838E-12  -4.79518676412702E-23
     -6.85914217444202E-10  -6.84236061661931E-10  -1.26575915910260E-18  -2.06482538231863E-02  -2.06482538271403E-02
      0.00000000000000E+00   0.00000000000000E+00   3.95394629481729E-09   0.00000000000000E+00   3.95394629481729E-09
      4.08117111517860E-18  -1.97597021073520E-01  -1.96566828360702E-01   0.00000000000000E+00  -1.20249092989519E-10
     -1.25094385791056E-22  -3.14946114016569E-09  -3.26971023315533E-09  -2.81541195607601E-18
      2.39267389402399E-09
      0.00000000000000E+00   3.80971969936821E-13   0.00000000000000E+00   7.07765678743646E-13  -4.80225060965799E-23
     -3.81704077231178E-10  -3.80996311552483E-10  -1.27206520056437E-18  -1.62959247209086E-02  -1.62959247238721E-02
      0.00000000000000E+00   0.00000000000000E+00   2.96350797686740E-09   0.00000000000000E+00   2.96350797686740E-09
      4.14044127471595E-18  -2.27772487239014E-01  -2.26958808895982E-01   0.00000000000000E+00  -1.10618695405980E-10
     -1.30146628219540E-22  -2.47189296990880E-09  -2.58251166531491E-09  -2.86837607415158E-18
      2.41267389402399E-09
      0.00000000000000E+00   2.57808177341528E-13   0.00000000000000E+00   2.83806813226729E-13  -4.80612096125271E-23
     -2.58106221187005E-10  -2.57822414373827E-10  -1.27593155559737E-18  -1.36012569797685E-02  -1.36012569820036E-02
      0.00000000000000E+00   0.00000000000000E+00   2.23507739807950E-09   0.00000000000000E+00   2.23507739807950E-09
      4.18514282267754E-18  -2.51555011594867E-01  -2.50932032331493E-01   0.00000000000000E+00  -9.36006700255168E-11
     -1.34139704314695E-22  -1.88365431368001E-09  -1.97725498370566E-09  -2.90921126708016E-18
      2.43267389402399E-09
      0.00000000000000E+00   2.00772595535653E-13   0.00000000000000E+00   1.29540019330038E-13  -4.80844313088612E-23
     -2.00908918400246E-10  -2.00779378380964E-10  -1.27867543592694E-18  -1.17640583762711E-02  -1.17640583779260E-02
      0.00000000000000E+00   0.00000000000000E+00   1.65494571209464E-09   0.00000000000000E+00   1.65494571209464E-09
      4.21824173691943E-18  -2.68899357239701E-01  -2.68441189936374E-01   0.00000000000000E+00  -7.20678034852650E-11
     -1.37070876153086E-22  -1.38209853022832E-09  -1.45416633371372E-09  -2.93956630099249E-18
      2.45267389402399E-09
      0.00000000000000E+00   1.70096453308340E-13   0.00000000000000E+00   6.93352494928712E-14  -4.80989159219828E-23
     -1.70147311758743E-10  -1.70077976509299E-10  -1.28081899303649E-18  -1.04419604862791E-02  -1.04419604874728E-02
      0.00000000000000E+00   0.00000000000000E+00   1.19364587083378E-09   0.00000000000000E+00   1.19364587083378E-09
      4.24211465433611E-18  -2.80559646187162E-01  -2.80237150820954E-01   0.00000000000000E+00  -4.98972813072573E-11
     -1.39042915176709E-22  -9.73670613017078E-10  -1.02356789432447E-09  -2.96129566129962E-18
      2.47267389402399E-09
      0.00000000000000E+00   1.48421095327363E-13   0.00000000000000E+00   5.03660125615837E-14  -4.81066966590763E-23
     -1.48456831489425E-10  -1.48406465476912E-10  -1.28253963063204E-18  -9.48237181272346E-03  -9.48237181358759E-03
      0.00000000000000E+00   0.00000000000000E+00   8.64135003146797E-10   0.00000000000000E+00   8.64135003146797E-10
      4.25939735439904E-18  -2.88083947907113E-01  -2.87858446410333E-01   0.00000000000000E+00  -3.21255278104153E-11
     -1.40295598558422E-22  -6.83603009859397E-10  -7.15728537669952E-10  -2.97685772376701E-18
      2.49267389402399E-09
      0.00000000000000E+00   1.27388650506840E-13   0.00000000000000E+00   5.20904012676153E-14  -4.81074562956232E-23
     -1.27401550897568E-10  -1.27349460496349E-10  -1.28384865179028E-18  -8.81041084099659E-03  -8.81041084170385E-03
      0.00000000000000E+00   0.00000000000000E+00   7.07255360288873E-10   0.00000000000000E+00   7.07255360288873E-10
      4.27354246160482E-18  -2.93940787954301E-01  -2.93758081394269E-01   0.00000000000000E+00  -2.43880037587386E-11
     -1.41232958431974E-22  -5.55517896033549E-10  -5.79905899792429E-10  -2.98969380981454E-18
      2.51267389402399E-09
      0.00000000000000E+00   1.14163008348956E-13   0.00000000000000E+00   3.47124113850001E-14  -4.81044880374170E-23
     -1.14165222336625E-10  -1.14130509925288E-10  -1.28490283466857E-18  -8.29101516282526E-03  -8.29101516348853E-03
      0.00000000000000E+00   0.00000000000000E+00   6.63274044000201E-10   0.00000000000000E+00   6.63274044000201E-10
      4.28680794248482E-18  -2.99544239900689E-01  -2.99371225847937E-01   0.00000000000000E+00  -2.31871809196262E-11
     -1.42106565134806E-22  -5.25956353155154E-10  -5.49143534074922E-10  -3.00190510781626E-18
      2.53267389402399E-09
      0.00000000000000E+00   1.04794845153788E-13   0.00000000000000E+00   2.62332206648806E-14  -4.80989783121339E-23
     -1.04855315546208E-10  -1.04829082325591E-10  -1.28578086093779E-18  -7.86332459012334E-03  -7.86332459078392E-03
      0.00000000000000E+00   0.00000000000000E+00   6.60586510193833E-10   0.00000000000000E+00   6.60586510193833E-10
      4.30001967268870E-18  -3.05374403732144E-01  -3.05199305683026E-01   0.00000000000000E+00  -2.43329712743018E-11
     -1.43005117188771E-22  -5.31424456593774E-10  -5.55757427868219E-10  -3.01423881175091E-18
      2.54267389402399E-09
      0.00000000000000E+00   9.73554214399784E-14   0.00000000000000E+00   4.11390432142832E-14  -4.80948426859361E-23
     -9.73995041962066E-11  -9.73583651530405E-11  -1.28614774162001E-18  -7.68675583060248E-03  -7.68675583127154E-03
      0.00000000000000E+00   0.00000000000000E+00   6.69063234910634E-10   0.00000000000000E+00   6.69063234910634E-10
      4.30671030503780E-18  -3.08459568887474E-01  -3.08279445946813E-01   0.00000000000000E+00  -2.59672106030567E-11
     -1.43477569528635E-22  -5.45737659154445E-10  -5.71704869757645E-10  -3.02056256341780E-18
      2.55617389402399E-09
      0.00000000000000E+00   8.28439529611891E-14   0.00000000000000E+00   5.94770577687021E-14  -4.80857820616959E-23
     -8.29284714474588E-11  -8.28689943897382E-11  -1.28645306746526E-18  -7.52044752134984E-03  -7.52044752213822E-03
      0.00000000000000E+00   0.00000000000000E+00   7.88374919875051E-10   0.00000000000000E+00   7.88374919875051E-10
      4.31735336645612E-18  -3.14120264423204E-01  -3.13897982866776E-01   0.00000000000000E+00  -3.65489127326983E-11
     -1.44356556229240E-22  -6.68957012752472E-10  -7.05505925485314E-10  -3.03090029899086E-18
      2.57439889402399E-09
      0.00000000000000E+00   7.09041371242107E-14   0.00000000000000E+00   4.07969653632465E-14  -4.80707094143420E-23
     -7.09145082337256E-11  -7.08737112684104E-11  -1.28665936283737E-18  -7.32971651434782E-03  -7.32971651534221E-03
      0.00000000000000E+00   0.00000000000000E+00   9.94390608619902E-10   0.00000000000000E+00   9.94390608619902E-10
      4.33547613529822E-18  -3.24881939784807E-01  -3.24590966627168E-01   0.00000000000000E+00  -5.40100288140429E-11
     -1.46072669429904E-22  -8.69506868537272E-10  -9.23516897351461E-10  -3.04881677246085E-18
      2.59439889402399E-09
      0.00000000000000E+00   7.14552055474558E-14   0.00000000000000E+00   6.38679366603500E-15  -4.80559340273251E-23
     -7.14433263837056E-11  -7.14369395900876E-11  -1.28691379638189E-18  -7.03767437401589E-03  -7.03767437515201E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13612149169775E-09   0.00000000000000E+00   1.13612149169775E-09
      4.35819856513217E-18  -3.38827605430178E-01  -3.38492152642499E-01   0.00000000000000E+00  -6.71084661128483E-11
     -1.48355715021326E-22  -9.97576085994671E-10  -1.06468455210767E-09  -3.07128476875029E-18
      2.61439889402399E-09
      0.00000000000000E+00   8.33031766472268E-14   0.00000000000000E+00  -2.41673892237311E-14  -4.80467458620953E-23
     -8.33245529000737E-11  -8.33487202893455E-11  -1.28742290287122E-18  -6.57385105977260E-03  -6.57385106095351E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18091718214887E-09   0.00000000000000E+00   1.18091718214887E-09
      4.38181690877515E-18  -3.53178550924800E-01  -3.52832736733745E-01   0.00000000000000E+00  -7.28454478940809E-11
     -1.50769309921026E-22  -1.02472301396523E-09  -1.09756846185946E-09  -3.09439400590393E-18
      2.63439889402399E-09
      0.00000000000000E+00   9.82738688120536E-14   0.00000000000000E+00  -3.46722592217755E-14  -4.80435894344558E-23
     -9.82350154348282E-11  -9.82696876940980E-11  -1.28824576874963E-18  -5.92477568057217E-03  -5.92477568175225E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18007211170355E-09   0.00000000000000E+00   1.18007211170355E-09
      4.40541835100922E-18  -3.67185356409906E-01  -3.66844509576319E-01   0.00000000000000E+00  -7.49514347396257E-11
     -1.53188873806298E-22  -1.00685098926972E-09  -1.08180242400950E-09  -3.11717258225959E-18
      2.65439889402399E-09
      0.00000000000000E+00   1.03876397781713E-13   0.00000000000000E+00  -1.30395996379264E-14  -4.80423153514593E-23
     -1.03838346047217E-10  -1.03851385646903E-10  -1.28919475026219E-18  -5.20955587779531E-03  -5.20955587894888E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15356857993051E-09   0.00000000000000E+00   1.15356857993051E-09
      4.42848972260783E-18  -3.80707435582604E-01  -3.80376698069461E-01   0.00000000000000E+00  -7.55548215778940E-11
     -1.55568536806562E-22  -9.74162372705617E-10  -1.04971719428367E-09  -3.13929497234564E-18
      2.67439889402399E-09
      0.00000000000000E+00   8.75280345587730E-14   0.00000000000000E+00   4.34482329025871E-14  -4.80343964238656E-23
     -8.75606882288408E-11  -8.75172399959863E-11  -1.28983166560826E-18  -4.69220902218592E-03  -4.69220902328031E-03
      0.00000000000000E+00   0.00000000000000E+00   1.09438188735828E-09   0.00000000000000E+00   1.09438188735828E-09
      4.45037736035500E-18  -3.93816695906804E-01  -3.93499460419345E-01   0.00000000000000E+00  -7.48395388247890E-11
     -1.57872303454644E-22  -9.32025108537362E-10  -1.00686464736231E-09  -3.16054569474673E-18
      2.69439889402399E-09
      0.00000000000000E+00   9.46000793237526E-15   0.00000000000000E+00   2.08794376485015E-13  -4.79957050281070E-23
     -9.61689915255738E-12  -9.40810477612036E-12  -1.28892419453753E-18  -5.11338700843479E-03  -5.11338700937563E-03
      0.00000000000000E+00   0.00000000000000E+00   9.40840249149365E-10   0.00000000000000E+00   9.40840249149365E-10
      4.46919416533799E-18  -4.06680102518750E-01  -4.06386634788326E-01   0.00000000000000E+00  -7.03160847998414E-11
     -1.59992086730040E-22  -8.61116059573161E-10  -9.31432144373162E-10  -3.18026997080046E-18
      2.71439889402399E-09
      0.00000000000000E+00  -4.02463638443382E-13   0.00000000000000E+00   1.09929951164779E-12  -4.77924268111482E-23
      4.01407413788652E-10   4.02506713300252E-10  -1.27981934331373E-18  -1.04603650956883E-02  -1.04603650959439E-02
      0.00000000000000E+00   0.00000000000000E+00   2.55622483752545E-10   0.00000000000000E+00   2.55622483752545E-10
      4.47430661501304E-18  -4.19858633131073E-01  -4.19651280597312E-01   0.00000000000000E+00  -4.37270121891402E-11
     -1.61285776272975E-22  -6.14402184863449E-10  -6.58129197052750E-10  -3.19448727169930E-18
      2.73439889402399E-09
      0.00000000000000E+00  -1.26213037870583E-12   0.00000000000000E+00   2.33976435240973E-12  -4.72648898153091E-23
      1.25981352313053E-09   1.26215328748289E-09  -1.25365078175944E-18  -2.58381622013256E-02  -2.58381622001885E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.13712119836318E-09   0.00000000000000E+00  -1.13712119836318E-09
      4.45156419104577E-18  -4.33951558354978E-01  -4.33912182464901E-01   0.00000000000000E+00   1.24739393085555E-11
     -1.60901470995679E-22  -1.37506028428199E-10  -1.25032089119804E-10  -3.19791340928633E-18
      2.75439889402399E-09
      0.00000000000000E+00  -1.97567214207111E-12   0.00000000000000E+00   2.06117227462534E-12  -4.65135867494764E-23
      1.97360149765123E-09   1.97566266992581E-09  -1.21357388224837E-18  -4.88354190078975E-02  -4.88354190056350E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.26251242451412E-09   0.00000000000000E+00  -2.26251242451412E-09
      4.40631394255549E-18  -4.48538946580747E-01  -4.48629352324252E-01   0.00000000000000E+00   5.53817817469390E-11
     -1.59231499050948E-22   2.31467972841591E-10   2.86849754588371E-10  -3.19274006030712E-18
      2.77439889402399E-09
      0.00000000000000E+00  -2.56402952862252E-12   0.00000000000000E+00   1.78819032810122E-12  -4.56037849695663E-23
      2.56222028529929E-09   2.56400847562734E-09  -1.16273618307934E-18  -7.70344100305744E-02  -7.70344100274594E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.11502618160626E-09   0.00000000000000E+00  -3.11502618160626E-09
      4.34401341892336E-18  -4.63233242976185E-01  -4.63406892106513E-01   0.00000000000000E+00   8.29431328278248E-11
     -1.56711148719424E-22   4.68074573151200E-10   5.51017705978869E-10  -3.18127723584403E-18
      2.78439889402399E-09
      0.00000000000000E+00  -2.99918989351179E-12   0.00000000000000E+00   2.47170000171585E-12  -4.50876473745140E-23
      2.99674110166396E-09   2.99921280166563E-09  -1.13350594737188E-18  -9.27951250447683E-02  -9.27951250410662E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.70208702216232E-09   0.00000000000000E+00  -3.70208702216232E-09
      4.30699254870174E-18  -4.70584604124454E-01  -4.70806101764139E-01   0.00000000000000E+00   9.87060573730163E-11
     -1.55197164240202E-22   6.04168163123960E-10   7.02874220496821E-10  -3.17348660132986E-18
      2.79789889402399E-09
      0.00000000000000E+00  -3.58938417480735E-12   0.00000000000000E+00   2.49199482030408E-12  -4.42908190017728E-23
      3.58691485724834E-09   3.58940685206860E-09  -1.08808899250297E-18  -1.16633580520386E-01  -1.16633580515994E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.39228787698816E-09   0.00000000000000E+00  -4.39228787698816E-09
      4.24769666236240E-18  -4.80460836043462E-01  -4.80713856735203E-01   0.00000000000000E+00   1.15922730413510E-10
     -1.52764482859312E-22   6.86958294506112E-10   8.02881024919469E-10  -3.15960766985944E-18
      2.81612389402399E-09
      0.00000000000000E+00  -4.56955121028608E-12   0.00000000000000E+00   2.96984656765239E-12  -4.25964899447391E-23
      4.56658520309235E-09   4.56955504965996E-09  -1.01863830357119E-18  -1.51664193350918E-01  -1.51664193345791E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.12726464622119E-09   0.00000000000000E+00  -5.12726464622119E-09
      4.15425226418502E-18  -4.92909719172327E-01  -4.93085531677100E-01   0.00000000000000E+00   1.29509205204445E-10
     -1.48993610753999E-22   4.28200391356858E-10   5.57709596561154E-10  -3.13561396061383E-18
      2.83612389402399E-09
      0.00000000000000E+00  -6.41691625447827E-12   0.00000000000000E+00   4.82199962182923E-12  -3.64853978205084E-23
      6.41212628379959E-09   6.41694828342138E-09  -9.39024938637923E-19  -1.89894316949185E-01  -1.89894316943599E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58613241305127E-09   0.00000000000000E+00  -5.58613241305127E-09
      4.04252961592399E-18  -5.03200240615883E-01  -5.02938673140108E-01   0.00000000000000E+00   1.32343848843160E-10
     -1.44535356340696E-22  -9.63159719213133E-10  -8.30815870370118E-10  -3.10350467728607E-18
      2.85612389402399E-09
      0.00000000000000E+00  -1.02794466777408E-11   0.00000000000000E+00   9.71602180718522E-12  -1.59640181999805E-23
      1.02696606256387E-08   1.02793766474458E-08  -8.62994852895028E-19  -2.24732773123829E-01  -2.24732773117970E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.85927637053865E-09   0.00000000000000E+00  -5.85927637053865E-09
      3.92534408851322E-18  -5.05855976430018E-01  -5.04463744172493E-01   0.00000000000000E+00   1.34405688690433E-10
     -1.39589205219255E-22  -4.55450596559758E-09  -4.42010027690729E-09  -3.06234923561819E-18
      2.87612389402399E-09
      0.00000000000000E+00  -1.69554569358815E-11   0.00000000000000E+00   1.65018734674349E-11   2.73999305071978E-23
      1.69388747572890E-08   1.69553766307564E-08  -7.96931477350788E-19  -2.54009454993375E-01  -2.54009454987249E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.12643019658787E-09   0.00000000000000E+00  -6.12643019658787E-09
      3.80281548458146E-18  -4.95330109087682E-01  -4.91918913482061E-01   0.00000000000000E+00   1.43046388581098E-10
     -1.33621012185144E-22  -1.09719928227494E-08  -1.08289464341684E-08  -3.00588400723068E-18
      2.89612389402399E-09
      0.00000000000000E+00  -2.52655687584185E-11   0.00000000000000E+00   2.06063603534800E-11   8.17884762991219E-23
      2.52450328467133E-08   2.52656392070669E-08  -7.44945336563851E-19  -2.76810919917739E-01  -2.76810919911312E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.42743902896643E-09   0.00000000000000E+00  -6.42743902896643E-09
      3.67426670400214E-18  -4.67517273331824E-01  -4.61582877336313E-01   0.00000000000000E+00   1.53187028267505E-10
     -1.26186677770034E-22  -1.89913872063679E-08  -1.88382001781005E-08  -2.92932136743828E-18
      2.91612389402399E-09
      0.00000000000000E+00  -3.24361629264218E-11   0.00000000000000E+00   1.77926217973553E-11   1.29819363927578E-22
      3.24183658079190E-08   3.24361584297165E-08  -7.07983542679370E-19  -2.93367949828946E-01  -2.93367949822216E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.72984554001160E-09   0.00000000000000E+00  -6.72984554001160E-09
      3.53966979320190E-18  -4.21505362878516E-01  -4.13407079800599E-01   0.00000000000000E+00   1.56459181649506E-10
     -1.17397573097279E-22  -2.58627720713544E-08  -2.57063128897050E-08  -2.83168625052253E-18
      2.93612389402399E-09
      0.00000000000000E+00  -3.59822882300044E-11   0.00000000000000E+00   8.82866120877095E-12   1.56215400364572E-22
      3.59734119110312E-08   3.59822405722401E-08  -6.84999103133946E-19  -3.04421499154928E-01  -3.04421499147915E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.01313914043313E-09   0.00000000000000E+00  -7.01313914043313E-09
      3.39940701039324E-18  -3.59111537900149E-01  -3.49985099273319E-01   0.00000000000000E+00   1.48916188672649E-10
     -1.08035475164226E-22  -2.91180176204794E-08  -2.89691014318068E-08  -2.71440790725930E-18
      2.95612389402399E-09
      0.00000000000000E+00  -3.55339940676944E-11   0.00000000000000E+00  -1.06888028929867E-12   1.57460755125107E-22
      3.55350522664137E-08   3.55339833861246E-08  -6.72780842028737E-19  -3.11359937511082E-01  -3.11359937503847E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23490468704004E-09   0.00000000000000E+00  -7.23490468704004E-09
      3.25470891665244E-18  -2.86689354397302E-01  -2.77773782277196E-01   0.00000000000000E+00   1.27064805787413E-10
     -9.87085455267377E-23  -2.84261435048719E-08  -2.82990786990846E-08  -2.58192807462371E-18
      2.97612389402399E-09
      0.00000000000000E+00  -3.34633544673507E-11   0.00000000000000E+00  -5.10339219048819E-12   1.45082679941746E-22
      3.34684823251951E-08   3.34633789330048E-08  -6.64787418006785E-19  -3.16739575636100E-01  -3.16739575628797E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30275093187803E-09   0.00000000000000E+00  -7.30275093187803E-09
      3.10865389801488E-18  -2.15966499349911E-01  -2.07724481973495E-01   0.00000000000000E+00   9.17265470488175E-11
     -8.90854953915456E-23  -2.62523545481755E-08  -2.61606280011268E-08  -2.44386648000809E-18
      2.99612389402399E-09
      0.00000000000000E+00  -3.14699562909986E-11   0.00000000000000E+00  -4.92132497634182E-12   1.29480074693650E-22
      3.14748857820024E-08   3.14699644570261E-08  -6.56982180577838E-19  -3.22093947991734E-01  -3.22093947984471E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26203706005663E-09   0.00000000000000E+00  -7.26203706005663E-09
      2.96341315681375E-18  -1.52398458487151E-01  -1.44771540923113E-01   0.00000000000000E+00   6.13110671422717E-11
     -8.20595076823069E-23  -2.42692384641117E-08  -2.42079273969695E-08  -2.30643097623591E-18
      3.01612389402399E-09
      0.00000000000000E+00  -2.96780654680797E-11   0.00000000000000E+00  -4.42075046711992E-12   1.14737321074638E-22
      2.96824711934134E-08   2.96780504429464E-08  -6.48121240912608E-19  -3.27870816493317E-01  -3.27870816486134E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.18249859472508E-09   0.00000000000000E+00  -7.18249859472508E-09
      2.81976318491925E-18  -9.68170234904194E-02  -8.97295367552513E-02   0.00000000000000E+00   4.17610331318257E-11
     -7.43182409220024E-23  -2.25373128813531E-08  -2.24955518482214E-08  -2.17164194400664E-18
      3.02612389402399E-09
      0.00000000000000E+00  -2.83393365785428E-11   0.00000000000000E+00  -6.59493429873570E-12   1.07729793904830E-22
      2.83459207456938E-08   2.83393258113952E-08  -6.42925857566000E-19  -3.31019010431759E-01  -3.31019010424636E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.12265911358933E-09   0.00000000000000E+00  -7.12265911358933E-09
      2.74853659378335E-18  -7.22910023538945E-02  -6.56064174725687E-02   0.00000000000000E+00   3.37565953771045E-11
     -6.24506079046055E-23  -2.12504232931828E-08  -2.12166666978058E-08  -2.10561073621735E-18
      3.03287389402399E-09
      0.00000000000000E+00  -2.71971554266300E-11   0.00000000000000E+00  -8.33379475772017E-12   1.04318382814542E-22
      2.72055214196096E-08   2.71971876248520E-08  -6.38188446884541E-19  -3.33567398359446E-01  -3.33567398352421E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02552071413690E-09   0.00000000000000E+00  -7.02552071413690E-09
      2.70111432896293E-18  -5.79904898784009E-02  -5.16351319688954E-02   0.00000000000000E+00   2.97500718061563E-11
     -4.66285085277444E-23  -2.02014169825211E-08  -2.01716669107150E-08  -2.06292588207839E-18
      3.04198639402399E-09
      0.00000000000000E+00  -2.55833515491566E-11   0.00000000000000E+00  -8.72399727072375E-12   1.03874524126692E-22
      2.55920922651337E-08   2.55833682678630E-08  -6.28578918440360E-19  -3.38119598676728E-01  -3.38119598669898E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.82992911965142E-09   0.00000000000000E+00  -6.82992911965142E-09
      2.63887659986010E-18  -4.31945261638962E-02  -3.72859864501741E-02   0.00000000000000E+00   2.47052558722773E-11
     -1.43125941311585E-23  -1.87781444040838E-08  -1.87534391482116E-08  -2.01029768141974E-18
      3.05428826902399E-09
      0.00000000000000E+00  -2.36098836807784E-11   0.00000000000000E+00  -7.89312244284491E-12   1.10385730290202E-22
      2.36177078889169E-08   2.36098147664742E-08  -6.10231574610658E-19  -3.46098585781518E-01  -3.46098585774959E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.55906712710201E-09   0.00000000000000E+00  -6.55906712710201E-09
      2.55818777594589E-18  -3.04724688257568E-02  -2.51003737303581E-02   0.00000000000000E+00   1.87841456858631E-11
      3.81609172330630E-23  -1.70695317850582E-08  -1.70507476393723E-08  -1.94795620133523E-18
      3.07089580027399E-09
      0.00000000000000E+00  -2.18258915052595E-11   0.00000000000000E+00  -5.27124348805431E-12   1.25784783930758E-22
      2.18311210487565E-08   2.18258498052685E-08  -5.80177496679928E-19  -3.58627358448316E-01  -3.58627358442023E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.29298930258449E-09   0.00000000000000E+00  -6.29298930258449E-09
      2.45367675944730E-18  -2.14683185568364E-02  -1.65744455563430E-02   0.00000000000000E+00   1.25688940926818E-11
      1.01605919461531E-22  -1.55454293967769E-08  -1.55328605026841E-08  -1.87349926276737E-18
      3.09089580027399E-09
      0.00000000000000E+00  -2.05900287213950E-11   0.00000000000000E+00  -3.01581664737374E-12   1.43009334272434E-22
      2.05929548122719E-08   2.05899389956247E-08  -5.42291110888100E-19  -3.74193447841451E-01  -3.74193447835350E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.10085390129734E-09   0.00000000000000E+00  -6.10085390129734E-09
      2.33165968142135E-18  -1.61040202736077E-02  -1.15389966782512E-02   0.00000000000000E+00   8.27691551044382E-12
      1.59441545909932E-22  -1.44973620098380E-08  -1.44890850943273E-08  -1.78936857053325E-18
      3.11089580027399E-09
      0.00000000000000E+00  -1.97441386917136E-11   0.00000000000000E+00  -2.05331890030227E-12   1.51652710461072E-22
      1.97461763112098E-08   1.97441229923097E-08  -5.05524407371955E-19  -3.89293541745383E-01  -3.89293541739411E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.97234234291931E-09   0.00000000000000E+00  -5.97234234291931E-09
      2.21221283456297E-18  -1.31117419892819E-02  -8.77271117881474E-03   0.00000000000000E+00   6.16858595844757E-12
      1.94306189616323E-22  -1.37779492353489E-08  -1.37717806493902E-08  -1.70668842719101E-18
      3.13089580027399E-09
      0.00000000000000E+00  -1.90424448994481E-11   0.00000000000000E+00  -1.70021047245950E-12   1.49345414798663E-22
      1.90441126705719E-08   1.90424124600996E-08  -4.70676237761427E-19  -4.03691696088033E-01  -4.03691696082166E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.86643095606995E-09   0.00000000000000E+00  -5.86643095606995E-09
      2.09488421544157E-18  -1.11931149341769E-02  -7.04179648464768E-03   0.00000000000000E+00   5.08910972789063E-12
      2.05596672374060E-22  -1.31810706137578E-08  -1.31759815040297E-08  -1.62420797768014E-18
      3.15089580027399E-09
      0.00000000000000E+00  -1.84284628312158E-11   0.00000000000000E+00  -1.48664243073551E-12   1.37153933784933E-22
      1.84299940913548E-08   1.84285074489242E-08  -4.37690124322371E-19  -4.17423107152896E-01  -4.17423107147123E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.77234033323682E-09   0.00000000000000E+00  -5.77234033323682E-09
      1.97943740877683E-18  -9.85587468028641E-03  -5.86832937538376E-03   0.00000000000000E+00   4.38035930867638E-12
      1.96397030544545E-22  -1.26605474749963E-08  -1.26561671156875E-08  -1.54174728445446E-18
      3.17089580027399E-09
      0.00000000000000E+00  -1.79062336554538E-11   0.00000000000000E+00  -1.26332799438160E-12   1.17939255587586E-22
      1.79074946000658E-08   1.79062312720715E-08  -4.06265997790145E-19  -4.30589839688289E-01  -4.30589839682600E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.68848040927645E-09   0.00000000000000E+00  -5.68848040927645E-09
      1.86566780059130E-18  -8.88357238314541E-03  -5.03415502201560E-03   0.00000000000000E+00   3.80619438630050E-12
      1.72303984555618E-22  -1.22215570571816E-08  -1.22177508627951E-08  -1.45940180280116E-18
      3.19089580027399E-09
      0.00000000000000E+00  -1.74826457274527E-11   0.00000000000000E+00  -1.02194188251364E-12   9.51924463602819E-23
      1.74836997940913E-08   1.74826778522089E-08  -3.76031130111758E-19  -4.43319594945708E-01  -4.43319594940081E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.62698210392038E-09   0.00000000000000E+00  -5.62698210392038E-09
      1.75312815851289E-18  -8.15503815030040E-03  -4.41969030858776E-03   0.00000000000000E+00   3.34154170304902E-12
      1.39907606151931E-22  -1.18590372899916E-08  -1.18556957482884E-08  -1.37709702840114E-18
      3.21089580027399E-09
      0.00000000000000E+00  -1.73469910505972E-11   0.00000000000000E+00  -3.13876713430413E-13   7.23960739262475E-23
      1.73472744145355E-08   1.73469605378222E-08  -3.45812129836894E-19  -4.56093595485307E-01  -4.56093595479563E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.74449152672793E-09   0.00000000000000E+00  -5.74449152672793E-09
      1.63823832797833E-18  -7.63356996960912E-03  -3.97800367222626E-03   0.00000000000000E+00   2.91963810601978E-12
      1.05543183829152E-22  -1.16053886492005E-08  -1.16024690110944E-08  -1.29242619814144E-18
      3.23089580027399E-09
      0.00000000000000E+00  -1.76759788992746E-11   0.00000000000000E+00   8.31932055730372E-13   5.20030920735233E-23
      1.76751351281874E-08   1.76759670602432E-08  -3.14076655872311E-19  -4.69579954436123E-01  -4.69579954429963E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.15992379825428E-09   0.00000000000000E+00  -6.15992379825428E-09
      1.51503985201325E-18  -7.31213093416976E-03  -3.68379267945440E-03   0.00000000000000E+00   2.47673422185028E-12
      7.37930188235675E-23  -1.15185199962107E-08  -1.15160432619888E-08  -1.20096319614094E-18
      3.25089580027399E-09
      0.00000000000000E+00  -1.79857711978755E-11   0.00000000000000E+00   7.86908309605317E-13   3.50867239095596E-23
      1.79850254806338E-08   1.79858123889435E-08  -2.81776783763055E-19  -4.83409671621190E-01  -4.83409671614725E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46507548354976E-09   0.00000000000000E+00  -6.46507548354976E-09
      1.38573834234226E-18  -7.07663787688264E-03  -3.44681894142235E-03   0.00000000000000E+00   2.16754704130912E-12
      4.71784313527651E-23  -1.15229044524350E-08  -1.15207369053937E-08  -1.10396155857920E-18
      3.25589580027399E-09
      0.00000000000000E+00  -1.80725644745367E-11   0.00000000000000E+00   8.76934497855521E-13   3.08315461568215E-23
      1.80716948179937E-08   1.80725717524915E-08  -2.73764350736757E-19  -4.86869375569618E-01  -4.86869375563038E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.58058323644750E-09   0.00000000000000E+00  -6.58058323644750E-09
      1.35283542616002E-18  -7.01421992983811E-03  -3.39345833470067E-03   0.00000000000000E+00   2.37591065760675E-12
      4.03767452666656E-23  -1.14943644267020E-08  -1.14919885160444E-08  -1.07907107542326E-18
      3.26264580027399E-09
      0.00000000000000E+00  -1.81619294038396E-11   0.00000000000000E+00   6.76010930049322E-13   2.58343648376832E-23
      1.81612601111672E-08   1.81619361220973E-08  -2.62935485853855E-19  -4.91556441877707E-01  -4.91556441871057E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64924175242148E-09   0.00000000000000E+00  -6.64924175242148E-09
      1.30795304433117E-18  -6.95498273535456E-03  -3.32769665471986E-03   0.00000000000000E+00   1.91495549871677E-12
      3.24949272579901E-23  -1.15146093251746E-08  -1.15126943696759E-08  -1.04501755847732E-18
      3.27175830027399E-09
      0.00000000000000E+00  -1.82612135647609E-11   0.00000000000000E+00   5.59099415375209E-13   2.03849427692173E-23
      1.82606803596002E-08   1.82612394590156E-08  -2.48401956211592E-19  -4.97874118845623E-01  -4.97874118838921E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.70145869219230E-09   0.00000000000000E+00  -6.70145869219230E-09
      1.24688600199857E-18  -6.88741465928031E-03  -3.24529233739053E-03   0.00000000000000E+00   1.75784983129223E-12
      2.39395549424174E-23  -1.15615386166545E-08  -1.15597807668232E-08  -9.98484045786976E-19
      3.27790923777399E-09
      0.00000000000000E+00  -1.83477313072104E-11   0.00000000000000E+00   7.12849927387439E-13   1.71992969181110E-23
      1.83470067661150E-08   1.83477196160424E-08  -2.38668035554111E-19  -5.02129123533365E-01  -5.02129123526618E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74704945549841E-09   0.00000000000000E+00  -6.74704945549841E-09
      1.20538532248839E-18  -6.85211666624722E-03  -3.19711084380799E-03   0.00000000000000E+00   1.63339599619424E-12
      1.89287369393370E-23  -1.16023035565402E-08  -1.16006701605440E-08  -9.66717286934278E-19
      3.28621300339899E-09
      0.00000000000000E+00  -1.84840288972264E-11   0.00000000000000E+00   8.29478704156591E-13   1.38093152199296E-23
      1.84832394872432E-08   1.84840689659474E-08  -2.25630467382964E-19  -5.07857628684674E-01  -5.07857628677891E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.78310447612855E-09   0.00000000000000E+00  -6.78310447612855E-09
      1.14906001270873E-18  -6.82984651638335E-03  -3.14324033461202E-03   0.00000000000000E+00   1.31781348949278E-12
      1.36291101978705E-23  -1.17022823033082E-08  -1.17009644898187E-08  -9.23429545325765E-19
      3.29742308699274E-09
      0.00000000000000E+00  -1.86273066872701E-11   0.00000000000000E+00   6.50335992068918E-13   1.05132422853347E-23
      1.86266502812737E-08   1.86273006172658E-08  -2.08428603470494E-19  -5.15469850589755E-01  -5.15469850582997E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.75801097617669E-09   0.00000000000000E+00  -6.75801097617669E-09
      1.07330214473831E-18  -6.81721751669984E-03  -3.07757640317182E-03   0.00000000000000E+00   1.09080720551522E-12
      8.53514928805238E-24  -1.18703804482947E-08  -1.18692896410892E-08  -8.64873541267815E-19
      3.31255669984430E-09
      0.00000000000000E+00  -1.84601492655524E-11   0.00000000000000E+00  -5.24509219509573E-13   7.60445783747666E-24
      1.84606482450085E-08   1.84601237357890E-08  -1.86985268064204E-19  -5.25039817920331E-01  -5.25039817913919E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.41172096862725E-09   0.00000000000000E+00  -6.41172096862725E-09
      9.76269641886859E-19  -6.76107252787723E-03  -2.96499735588834E-03   0.00000000000000E+00   1.06918813805812E-12
      4.22476513098826E-24  -1.20494719552997E-08  -1.20484027671616E-08  -7.89284373822655E-19
      3.33255669984430E-09
      0.00000000000000E+00  -1.70631908126259E-11   0.00000000000000E+00  -3.42810052542211E-12   5.21171524038962E-24
      1.70666406237360E-08   1.70632125232106E-08  -1.65963960189496E-19  -5.34470296489390E-01  -5.34470296484471E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.91924489353276E-09   0.00000000000000E+00  -4.91924489353276E-09
      8.77884744016204E-19  -6.55575889207526E-03  -2.72957300690584E-03   0.00000000000000E+00   9.68780515788308E-13
      1.09212351273590E-24  -1.21449364101935E-08  -1.21439676296777E-08  -7.11920783826706E-19
      3.35255669984430E-09
      0.00000000000000E+00  -1.34832666457510E-11   0.00000000000000E+00  -8.81609871300046E-12   3.34710060785592E-24
      1.34920636899842E-08   1.34832475912712E-08  -1.60672248264450E-19  -5.36688037734713E-01  -5.36688037733388E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.32421082467601E-09   0.00000000000000E+00  -1.32421082467601E-09
      8.51400527522683E-19  -6.16582806605451E-03  -2.33489326754724E-03   0.00000000000000E+00   2.86508227436111E-13
     -8.18199790993628E-25  -1.21593232748226E-08  -1.21590367665952E-08  -6.90728279258233E-19
      3.37255669984430E-09
      0.00000000000000E+00  -7.09950634140461E-12   0.00000000000000E+00  -1.57360304141660E-11   1.28768105820784E-24
      7.11524335393373E-09   7.09950732351956E-09  -1.82846902020187E-19  -5.26295798656360E-01  -5.26295798661411E-01
      0.00000000000000E+00   0.00000000000000E+00   5.05103694932790E-09   0.00000000000000E+00   5.05103694932790E-09
      9.52421266509241E-19  -5.55772498135433E-03  -1.72946500402101E-03   0.00000000000000E+00  -1.17293928585246E-12
     -2.57873813073689E-24  -1.21493713335617E-08  -1.21505442728475E-08  -7.69574364489056E-19
      3.39255669984430E-09
      0.00000000000000E+00   9.85677719711177E-13   0.00000000000000E+00  -1.99467501866625E-11  -1.85072748233643E-24
     -9.65712442910736E-10  -9.85659193097401E-10  -2.43368348667635E-19  -4.99139777682499E-01  -4.99139777695615E-01
      0.00000000000000E+00   0.00000000000000E+00   1.31162442771044E-08   0.00000000000000E+00   1.31162442771044E-08
      1.21474615205133E-18  -4.80240279876097E-03  -9.80431488401516E-04   0.00000000000000E+00  -3.43254808109657E-12
     -5.92069468635595E-24  -1.21271525359259E-08  -1.21305850840070E-08  -9.71377803383696E-19
      3.41255669984430E-09
      0.00000000000000E+00   8.12137088757555E-12   0.00000000000000E+00  -1.76589190700523E-11  -8.40410890938906E-24
     -8.10374750745940E-09  -8.12140642652946E-09  -3.49218401501068E-19  -4.54204737148674E-01  -4.54204737168888E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02137569249762E-08   0.00000000000000E+00   2.02137569249762E-08
      1.61902129055085E-18  -4.06796043396335E-03  -2.58037394935948E-04   0.00000000000000E+00  -6.76121615949654E-12
     -1.58004960248891E-23  -1.20855892822872E-08  -1.20923504984468E-08  -1.26980288904979E-18
      3.43255669984430E-09
      0.00000000000000E+00   1.17316956624662E-11   0.00000000000000E+00  -9.05510884646732E-12  -2.27832889099989E-23
     -1.17225904889930E-08  -1.17316455978395E-08  -5.02101627161014E-19  -3.92826308946045E-01  -3.92826308969809E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37637147842446E-08   0.00000000000000E+00   2.37637147842446E-08
      2.09429558623575E-18  -3.54229834365361E-03   2.48629468335642E-04   0.00000000000000E+00  -1.23294385820013E-11
     -4.17776816555292E-23  -1.20197397478231E-08  -1.20320691864052E-08  -1.59219395907473E-18
      3.45255669984430E-09
      0.00000000000000E+00   1.08729473695758E-11   0.00000000000000E+00   1.85425761030501E-12  -3.73750277375720E-23
     -1.08747720815469E-08  -1.08729178239366E-08  -6.85833751319960E-19  -3.18928808087915E-01  -3.18928808110623E-01
      0.00000000000000E+00   0.00000000000000E+00   2.27079342046505E-08   0.00000000000000E+00   2.27079342046505E-08
      2.54845427032876E-18  -4.19391707626147E-03  -4.65079347101002E-04   0.00000000000000E+00  -2.21235048254788E-11
     -6.95568155479244E-23  -1.18128928758882E-08  -1.18350163807138E-08  -1.86262051900879E-18
      3.47255669984430E-09
      0.00000000000000E+00   8.41545773611405E-12   0.00000000000000E+00   5.69289989269863E-12  -4.19131930655004E-23
     -8.42122050327172E-09  -8.41552760337906E-09  -8.57471635453118E-19  -2.43326878128833E-01  -2.43326878148015E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91818193160096E-08   0.00000000000000E+00   1.91818193160096E-08
      2.93209065664895E-18  -1.20052240325929E-02  -8.61311186857460E-03   0.00000000000000E+00  -3.62290041765712E-11
     -7.94127520040566E-23  -1.07300627084539E-08  -1.07662917126306E-08  -2.07461902119583E-18
      3.49255669984430E-09
      0.00000000000000E+00   6.81487950079848E-12   0.00000000000000E+00   3.50671302012071E-12  -4.38666939124984E-23
     -6.81832899397863E-09  -6.81482228095856E-09  -9.95989147557294E-19  -1.75408244956002E-01  -1.75408244971961E-01
      0.00000000000000E+00   0.00000000000000E+00   1.59589109798072E-08   0.00000000000000E+00   1.59589109798072E-08
      3.25126887624509E-18  -3.00692618213691E-02  -2.71882536036415E-02   0.00000000000000E+00  -5.65246306877629E-11
     -8.74811764960399E-23  -9.08756406816081E-09  -9.14408869884866E-09  -2.25527972868780E-18
      3.50255669984430E-09
      0.00000000000000E+00   6.01766718183715E-12   0.00000000000000E+00   3.41547936805411E-12  -4.47415480273884E-23
     -6.02100490443692E-09  -6.01758942506891E-09  -1.05646420241669E-18  -1.43708971727852E-01  -1.43708971742163E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43113358011882E-08   0.00000000000000E+00   1.43113358011882E-08
      3.39438223425698E-18  -4.15627880303240E-02  -3.89496869907088E-02   0.00000000000000E+00  -7.73451569014352E-11
     -9.18638516846206E-23  -8.21640121921775E-09  -8.29374637611928E-09  -2.33791803184029E-18
      3.51605669984430E-09
      0.00000000000000E+00   5.20943349441092E-12   0.00000000000000E+00   2.41833861235400E-12  -4.58139659166426E-23
     -5.21186570851425E-09  -5.20944736990194E-09  -1.12627248210396E-18  -1.05381528619103E-01  -1.05381528631797E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26940429273803E-08   0.00000000000000E+00   1.26940429273803E-08
      3.56575181377661E-18  -5.97397134103434E-02  -5.73815490203028E-02   0.00000000000000E+00  -9.54815524129251E-11
     -9.77820967561110E-23  -7.38911400506537E-09  -7.48459555747839E-09  -2.43947933167265E-18
      3.53428169984430E-09
      0.00000000000000E+00   4.06137427931683E-12   0.00000000000000E+00   2.59166484053250E-12  -4.70264963184219E-23
     -4.06397248958806E-09  -4.06138082474757E-09  -1.19908344622404E-18  -6.32841206169348E-02  -6.32841206274617E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05268846191354E-08   0.00000000000000E+00   1.05268846191354E-08
      3.75760428596035E-18  -8.81537664042702E-02  -8.61166851217774E-02   0.00000000000000E+00  -1.15210301527250E-10
     -1.05573539482515E-22  -6.35029349286050E-09  -6.46550379438785E-09  -2.55852083973631E-18
      3.53928169984430E-09
      0.00000000000000E+00   3.44730036634731E-12   0.00000000000000E+00   5.53291595332475E-12  -4.72837266135223E-23
     -3.45279517972066E-09  -3.44726226376738E-09  -1.21597564717494E-18  -5.32159483372793E-02  -5.32159483466871E-02
      0.00000000000000E+00   0.00000000000000E+00   9.40781375689349E-09   0.00000000000000E+00   9.40781375689349E-09
      3.80464335474482E-18  -9.65216561351062E-02  -9.46436596388580E-02   0.00000000000000E+00  -1.28373991106265E-10
     -1.07722609929219E-22  -5.83217750201994E-09  -5.96055149312632E-09  -2.58866770756987E-18
      3.54603169984430E-09
      0.00000000000000E+00   2.69646963967578E-12   0.00000000000000E+00   5.08502434320157E-12  -4.75598044098584E-23
     -2.70153610728059E-09  -2.69645108293744E-09  -1.23369872498223E-18  -4.24656349343798E-02  -4.24656349424803E-02
      0.00000000000000E+00   0.00000000000000E+00   8.10043022819367E-09   0.00000000000000E+00   8.10043022819367E-09
      3.85932125878513E-18  -1.08646146126326E-01  -1.06943508531265E-01   0.00000000000000E+00  -1.28803483531830E-10
     -1.10473232492766E-22  -5.27517566172443E-09  -5.40397914525637E-09  -2.62562253380290E-18
      3.55514419984430E-09
      0.00000000000000E+00   1.85471262316880E-12   0.00000000000000E+00   4.27577185948971E-12  -4.77845560849741E-23
     -1.85900278301205E-09  -1.85472701115260E-09  -1.24994753392567E-18  -3.23779755997907E-02  -3.23779756064016E-02
      0.00000000000000E+00   0.00000000000000E+00   6.61093831077501E-09   0.00000000000000E+00   6.61093831077501E-09
      3.91956343414206E-18  -1.26094429945610E-01  -1.24595884784999E-01   0.00000000000000E+00  -1.26876062823200E-10
     -1.13913941027642E-22  -4.62933523679897E-09  -4.75621129962229E-09  -2.66961590021640E-18
      3.56744607484430E-09
      0.00000000000000E+00   1.10158577806708E-12   0.00000000000000E+00   2.85982104839008E-12  -4.79432391205621E-23
     -1.10446779400534E-09  -1.10160797295699E-09  -1.26262382035121E-18  -2.42213289128180E-02  -2.42213289180210E-02
      0.00000000000000E+00   0.00000000000000E+00   5.20294443352029E-09   0.00000000000000E+00   5.20294443352029E-09
      3.98356940619518E-18  -1.50480047052060E-01  -1.49187833267897E-01   0.00000000000000E+00  -1.25078221490094E-10
     -1.18175306533451E-22  -3.97625823907307E-09  -4.10133646056329E-09  -2.72094558584397E-18
      3.58405360609430E-09
      0.00000000000000E+00   5.91020883930435E-13   0.00000000000000E+00   1.44174928541596E-12  -4.80070916104587E-23
     -5.92458780059715E-10  -5.91017030774347E-10  -1.27128052746548E-18  -1.83082705143562E-02  -1.83082705184535E-02
      0.00000000000000E+00   0.00000000000000E+00   4.09726177441972E-09   0.00000000000000E+00   4.09726177441972E-09
      4.05161480915328E-18  -1.82817357715771E-01  -1.81712639099615E-01   0.00000000000000E+00  -1.24844776124541E-10
     -1.23454427884358E-22  -3.38139996752074E-09  -3.50624474364540E-09  -2.78033428168780E-18
      3.60405360609430E-09
      0.00000000000000E+00   3.28712314465738E-13   0.00000000000000E+00   6.15815987570546E-13  -4.80937654164625E-23
     -3.29362045870819E-10  -3.28746229883296E-10  -1.27649661576879E-18  -1.44447906572087E-02  -1.44447906604905E-02
      0.00000000000000E+00   0.00000000000000E+00   3.28178585605313E-09   0.00000000000000E+00   3.28178585605313E-09
      4.11725052627434E-18  -2.18487463287717E-01  -2.17557042011226E-01   0.00000000000000E+00  -1.23525530123068E-10
     -1.29197753268483E-22  -2.82951409604670E-09  -2.95303962616990E-09  -2.84075391050556E-18
      3.62405360609430E-09
      0.00000000000000E+00   2.16478045598141E-13   0.00000000000000E+00   2.64225128980480E-13  -4.81187531246203E-23
     -2.16780935437980E-10  -2.16516710309048E-10  -1.27949981213742E-18  -1.20850901353194E-02  -1.20850901379514E-02
      0.00000000000000E+00   0.00000000000000E+00   2.63205380000002E-09   0.00000000000000E+00   2.63205380000002E-09
      4.16989160227435E-18  -2.48870770969837E-01  -2.48109699787533E-01   0.00000000000000E+00  -1.15712810309367E-10
     -1.34150503242774E-22  -2.29982427938152E-09  -2.41553708969102E-09  -2.89039179013693E-18
      3.64405360609430E-09
      0.00000000000000E+00   1.67157421717699E-13   0.00000000000000E+00   1.16985628878962E-13  -4.81298272352809E-23
     -1.67280401878568E-10  -1.67163416249737E-10  -1.28154142677021E-18  -1.04887603400258E-02  -1.04887603420867E-02
      0.00000000000000E+00   0.00000000000000E+00   2.06098174693209E-09   0.00000000000000E+00   2.06098174693209E-09
      4.21111123721299E-18  -2.72950865854980E-01  -2.72354173807006E-01   0.00000000000000E+00  -9.92852763197751E-11
     -1.38135258325093E-22  -1.79453305436237E-09  -1.89381833068228E-09  -2.92956981044278E-18
      3.66405360609430E-09
      0.00000000000000E+00   1.42451187408874E-13   0.00000000000000E+00   5.99232610275228E-14  -4.81341930522997E-23
     -1.42501470636750E-10  -1.42441547375771E-10  -1.28310841222251E-18  -9.34828263938009E-03  -9.34828264094856E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56847552677654E-09   0.00000000000000E+00   1.56847552677654E-09
      4.24248074774852E-18  -2.90846769495152E-01  -2.90397465092378E-01   0.00000000000000E+00  -7.79252446410574E-11
     -1.41121586120438E-22  -1.34810873475956E-09  -1.42603397940076E-09  -2.95937233552601E-18
      3.68405360609430E-09
      0.00000000000000E+00   1.29041855776575E-13   0.00000000000000E+00   3.38263841676753E-14  -4.81351568814479E-23
     -1.29060497173251E-10  -1.29026670789132E-10  -1.28442216189870E-18  -8.50544578940074E-03  -8.50544579055836E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15761862368519E-09   0.00000000000000E+00   1.15761862368519E-09
      4.26563312022222E-18  -3.03218800269139E-01  -3.02894721568462E-01   0.00000000000000E+00  -5.53068228903451E-11
     -1.43179532063515E-22  -9.73285130005586E-10  -1.02859195289607E-09  -2.98121095832352E-18
      3.70405360609430E-09
      0.00000000000000E+00   1.21326897851143E-13   0.00000000000000E+00   2.05975021543260E-14  -4.81412669169573E-23
     -1.21345747224303E-10  -1.21325149722197E-10  -1.28559308446491E-18  -7.86802142114862E-03  -7.86802142197009E-03
      0.00000000000000E+00   0.00000000000000E+00   8.21474994840939E-10   0.00000000000000E+00   8.21474994840939E-10
      4.28206262011904E-18  -3.10888063206857E-01  -3.10667470530143E-01   0.00000000000000E+00  -3.39112240333998E-11
     -1.44425702810568E-22  -6.66238621085263E-10  -7.00149845118807E-10  -2.99646953565413E-18
      3.72405360609430E-09
      0.00000000000000E+00   1.09754460962994E-13   0.00000000000000E+00   3.16731075378828E-14  -4.81342453225205E-23
     -1.09789951767928E-10  -1.09758278660438E-10  -1.28654185957666E-18  -7.43113413901034E-03  -7.43113413962369E-03
      0.00000000000000E+00   0.00000000000000E+00   6.13342450283790E-10   0.00000000000000E+00   6.13342450283790E-10
      4.29432946912472E-18  -3.15823881775878E-01  -3.15665223451107E-01   0.00000000000000E+00  -2.05727859912174E-11
     -1.45179439899952E-22  -4.83011385631845E-10  -5.03584171623207E-10  -3.00778760954805E-18
      3.74405360609430E-09
      0.00000000000000E+00   9.48756135353751E-14   0.00000000000000E+00   4.19732193199783E-14  -4.81140921667781E-23
     -9.49449681300790E-11  -9.49029949108071E-11  -1.28720283907795E-18  -7.16706409870503E-03  -7.16706409927335E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68328575706505E-10   0.00000000000000E+00   5.68328575706505E-10
      4.30569604063885E-18  -3.20542189074421E-01  -3.20393033009893E-01   0.00000000000000E+00  -1.92146652714397E-11
     -1.45869624633797E-22  -4.54210915524255E-10  -4.73425580795840E-10  -3.01849320156090E-18
      3.75405360609430E-09
      0.00000000000000E+00   9.10181345726590E-14   0.00000000000000E+00   2.49771166454869E-14  -4.81109812313568E-23
     -9.10652435297640E-11  -9.10402664131666E-11  -1.28749701972288E-18  -7.05630228928131E-03  -7.05630228983348E-03
      0.00000000000000E+00   0.00000000000000E+00   5.52173030187329E-10   0.00000000000000E+00   5.52173030187329E-10
      4.31121777094072E-18  -3.22834559472013E-01  -3.22689276608759E-01   0.00000000000000E+00  -1.85837554643809E-11
     -1.46199994960408E-22  -4.42549008309594E-10  -4.61132763774121E-10  -3.02372075121784E-18
      3.76755360609430E-09
      0.00000000000000E+00   8.51400713913773E-14   0.00000000000000E+00   2.81066438253388E-14  -4.81059172558945E-23
     -8.51720488203866E-11  -8.51439421766094E-11  -1.28781910456240E-18  -6.93490680701018E-03  -6.93490680760061E-03
      0.00000000000000E+00   0.00000000000000E+00   5.90429017459296E-10   0.00000000000000E+00   5.90429017459296E-10
      4.31918856267642E-18  -3.26443935277038E-01  -3.26284740603221E-01   0.00000000000000E+00  -2.24811244405139E-11
     -1.46730052975511E-22  -4.82803950841916E-10  -5.05285075282577E-10  -3.03136945811402E-18
      3.78577860609430E-09
      0.00000000000000E+00   7.86190950496429E-14   0.00000000000000E+00   2.50769148444303E-14  -4.80933721647813E-23
     -7.85874565627251E-11  -7.85623796479288E-11  -1.28814318761891E-18  -6.79927779870429E-03  -6.79927779936905E-03
      0.00000000000000E+00   0.00000000000000E+00   6.64758693484496E-10   0.00000000000000E+00   6.64758693484496E-10
      4.33130378986518E-18  -3.32504605022671E-01  -3.32319916441358E-01   0.00000000000000E+00  -2.93086212786119E-11
     -1.47646501705155E-22  -5.56887692557870E-10  -5.86196313836630E-10  -3.04316060224626E-18
      3.79077860609430E-09
      0.00000000000000E+00   7.22818081823236E-14   0.00000000000000E+00   6.99786450245515E-14  -4.80894512658835E-23
     -7.23338105366678E-11  -7.22638318916914E-11  -1.28820134085468E-18  -6.77650490763884E-03  -6.77650490833152E-03
      0.00000000000000E+00   0.00000000000000E+00   6.92683424756553E-10   0.00000000000000E+00   6.92683424756553E-10
      4.33476720698896E-18  -3.34321004424790E-01  -3.34125532425245E-01   0.00000000000000E+00  -3.25374357472596E-11
     -1.47922258450375E-22  -5.87882157117530E-10  -6.20419592864937E-10  -3.04656586613428E-18
      3.79752860609430E-09
      0.00000000000000E+00   5.96990791848924E-14   0.00000000000000E+00   1.01463984253201E-13  -4.80870050516561E-23
     -5.98619604989055E-11  -5.97604965147004E-11  -1.28819700018895E-18  -6.77784797599741E-03  -6.77784797679645E-03
      0.00000000000000E+00   0.00000000000000E+00   7.99037411333989E-10   0.00000000000000E+00   7.99037411333989E-10
      4.34016070951546E-18  -3.37453223530083E-01  -3.37220301106026E-01   0.00000000000000E+00  -4.28774302800446E-11
     -1.48407508181238E-22  -6.96399484539298E-10  -7.39276914819491E-10  -3.05196370932652E-18
      3.80664110609430E-09
      0.00000000000000E+00   5.25351896827053E-14   0.00000000000000E+00   5.05663128879008E-14  -4.80752343564633E-23
     -5.26273505079756E-11  -5.25767841951358E-11  -1.28812895439452E-18  -6.78348462542116E-03  -6.78348462637915E-03
      0.00000000000000E+00   0.00000000000000E+00   9.57987451127192E-10   0.00000000000000E+00   9.57987451127192E-10
      4.34889037016386E-18  -3.42870914689508E-01  -3.42585645924034E-01   0.00000000000000E+00  -5.70088621048466E-11
     -1.49270983483288E-22  -8.48401804826855E-10  -9.05410666931851E-10  -3.06076141576934E-18
      3.81894298109430E-09
      0.00000000000000E+00   5.18922765222526E-14   0.00000000000000E+00   1.40442672290526E-14  -4.80599806438882E-23
     -5.19191424327352E-11  -5.19050981655542E-11  -1.28803547830545E-18  -6.74883732854602E-03  -6.74883732966177E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11574338065229E-09   0.00000000000000E+00   1.11574338065229E-09
      4.36261610576472E-18  -3.51663173162705E-01  -3.51327986252534E-01   0.00000000000000E+00  -7.12329903019721E-11
     -1.50709810170135E-22  -9.92605292184728E-10  -1.06383828248685E-09  -3.07458062745927E-18
      3.83555051234430E-09
      0.00000000000000E+00   5.78621844407419E-14   0.00000000000000E+00  -7.95078309277322E-15  -4.80451142225660E-23
     -5.78682590220996E-11  -5.78762098052404E-11  -1.28802100072324E-18  -6.60128252841317E-03  -6.60128252962057E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20739216742618E-09   0.00000000000000E+00   1.20739216742618E-09
      4.38266790891626E-18  -3.64563101267432E-01  -3.64200918672135E-01   0.00000000000000E+00  -8.07706362375315E-11
     -1.52872446861808E-22  -1.06874532138326E-09  -1.14951595762095E-09  -3.09464690819302E-18
      3.85555051234430E-09
      0.00000000000000E+00   6.97101555405128E-14   0.00000000000000E+00  -2.20682266047186E-14  -4.80346798206074E-23
     -6.97196557307295E-11  -6.97417239573823E-11  -1.28825843546738E-18  -6.26405977233722E-03  -6.26405977356058E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22335765303325E-09   0.00000000000000E+00   1.22335765303325E-09
      4.40713506197692E-18  -3.80071413849609E-01  -3.79707939331388E-01   0.00000000000000E+00  -8.47011804298080E-11
     -1.55539667125220E-22  -1.06891474864590E-09  -1.15361592907587E-09  -3.11887662650954E-18
      3.87555051234430E-09
      0.00000000000000E+00   8.75280345587730E-14   0.00000000000000E+00  -4.01816059105015E-14  -4.79432116887215E-23
     -8.74861048055604E-11  -8.75262864115189E-11  -1.28886772154780E-18  -5.71385527432299E-03  -5.71385527553278E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20978996926392E-09   0.00000000000000E+00   1.20978996926392E-09
      4.43133086136220E-18  -3.94965971237017E-01  -3.94612375029467E-01   0.00000000000000E+00  -8.59254310493441E-11
     -1.58179234210808E-22  -1.03633825180291E-09  -1.12226368285241E-09  -3.14246313981440E-18
      3.89555051234430E-09
      0.00000000000000E+00   1.02957950409637E-13   0.00000000000000E+00  -3.75849345848810E-14  -4.80198672620109E-23
     -1.02958898764871E-10  -1.02996483699504E-10  -1.28980114185359E-18  -4.98378390880441E-03  -4.98378390999048E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18606105701142E-09   0.00000000000000E+00   1.18606105701142E-09
      4.45505208250243E-18  -4.09149439144571E-01  -4.08808193732916E-01   0.00000000000000E+00  -8.61464761726880E-11
     -1.60765139906328E-22  -9.96918097139001E-10  -1.08306457331185E-09  -3.16525094064884E-18
      3.91555051234430E-09
      0.00000000000000E+00   1.06172516211901E-13   0.00000000000000E+00  -8.14696831286403E-15  -4.80218709967175E-23
     -1.06162563305651E-10  -1.06170710274012E-10  -1.29081191839680E-18  -4.22239500347045E-03  -4.22239500461670E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14624574063624E-09   0.00000000000000E+00   1.14624574063624E-09
      4.47797699731515E-18  -4.22691291204140E-01  -4.22363591000921E-01   0.00000000000000E+00  -8.55776640224260E-11
     -1.63279589483225E-22  -9.54497366339731E-10  -1.04007503036232E-09  -3.18716507891836E-18
      3.93555051234430E-09
      0.00000000000000E+00   9.48756135353751E-14   0.00000000000000E+00   2.91164362304435E-14  -4.80179081001757E-23
     -9.49378128736555E-11  -9.49086964374731E-11  -1.29161121211773E-18  -3.60178497739671E-03  -3.60178497848541E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08869641685433E-09   0.00000000000000E+00   1.08869641685433E-09
      4.49975092565224E-18  -4.35689856054235E-01  -4.35376740227136E-01   0.00000000000000E+00  -8.41815459043033E-11
     -1.65704440499562E-22  -9.09606174512400E-10  -9.93787720416869E-10  -3.20813971353451E-18
      3.95555051234430E-09
      0.00000000000000E+00   4.67489712386311E-14   0.00000000000000E+00   1.28054544840431E-13  -4.79998516711935E-23
     -4.68933913473642E-11  -4.67653368025718E-11  -1.29146320663370E-18  -3.56344493686972E-03  -3.56344493784641E-03
      0.00000000000000E+00   0.00000000000000E+00   9.76692575249121E-10   0.00000000000000E+00   9.76692575249121E-10
      4.51928477715722E-18  -4.48263066438673E-01  -4.47970072318710E-01   0.00000000000000E+00  -8.01664929234361E-11
     -1.67971465794085E-22  -8.49760745522964E-10  -9.29927238446568E-10  -3.22782157052353E-18
      3.97555051234430E-09
      0.00000000000000E+00  -3.45703590849131E-13   0.00000000000000E+00   1.04109608022366E-12  -4.78164369314235E-23
      3.44631827393494E-10   3.45672923473670E-10  -1.28350406238133E-18  -8.23048186958069E-03  -8.23048186989722E-03
      0.00000000000000E+00   0.00000000000000E+00   3.16529981335260E-10   0.00000000000000E+00   3.16529981335260E-10
      4.52561537678393E-18  -4.60936800340096E-01  -4.60728164699230E-01   0.00000000000000E+00  -5.01361641711728E-11
     -1.69360574426209E-22  -6.12066740637582E-10  -6.62202904808925E-10  -3.24211131440260E-18
      3.99555051234430E-09
      0.00000000000000E+00  -1.24513910232244E-12   0.00000000000000E+00   2.43471050226023E-12  -4.72829123324930E-23
      1.24266563069273E-09   1.24510034119494E-09  -1.25768354706527E-18  -2.34324428578063E-02  -2.34324428566608E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.14556362151830E-09   0.00000000000000E+00  -1.14556362151830E-09
      4.50270410435356E-18  -4.74335717007993E-01  -4.74304377411608E-01   0.00000000000000E+00   1.82884363093103E-11
     -1.68817151292522E-22  -1.17825155985785E-10  -9.95367196766435E-11  -3.24502055728830E-18
      4.01555051234430E-09
      0.00000000000000E+00  -1.98706088948484E-12   0.00000000000000E+00   2.13977890770388E-12  -4.65230269555802E-23
      1.98496838045183E-09   1.98710815935948E-09  -1.21738574566247E-18  -4.66019219699053E-02  -4.66019219675827E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.32263043522583E-09   0.00000000000000E+00  -2.32263043522583E-09
      4.45625149564904E-18  -4.88047166607807E-01  -4.88152915545544E-01   0.00000000000000E+00   7.03235716269260E-11
     -1.66790440703930E-22   2.65198704239563E-10   3.35522275866323E-10  -3.23886574998657E-18
      4.01558957484430E-09
      0.00000000000000E+00  -1.99312264214054E-12   0.00000000000000E+00   4.65466550922721E-12  -4.65214096284960E-23
      1.98842516332833E-09   1.99307982883751E-09  -1.21730680851699E-18  -4.66471979873579E-02  -4.66471979850280E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.32985965570223E-09   0.00000000000000E+00  -2.32985965570223E-09
      4.45616048550624E-18  -4.88073811091650E-01  -4.88179953869044E-01   0.00000000000000E+00   7.04118682430128E-11
     -1.66786458146344E-22   2.66367958657109E-10   3.36779826899955E-10  -3.23885367698925E-18
      4.01564230921930E-09
      0.00000000000000E+00  -2.00469507902869E-12   0.00000000000000E+00   7.99670109881749E-12  -4.65190701832707E-23
      1.99667491748153E-09   2.00467161858030E-09  -1.21719963689039E-18  -4.67086265800685E-02  -4.67086265777244E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.34408395304125E-09   0.00000000000000E+00  -2.34408395304125E-09
      4.45603687170403E-18  -4.88109667825924E-01  -4.88216640073699E-01   0.00000000000000E+00   7.09735168481802E-11
     -1.66781051984257E-22   2.68438817630444E-10   3.39412334478458E-10  -3.23883723481365E-18
      4.01571350062555E-09
      0.00000000000000E+00  -2.02168635541208E-12   0.00000000000000E+00   1.04040643314389E-11  -4.64977201080088E-23
      2.01128825044650E-09   2.02169231477790E-09  -1.21705375126932E-18  -4.67922110852617E-02  -4.67922110828958E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.36593985539170E-09   0.00000000000000E+00  -2.36593985539170E-09
      4.45586843711863E-18  -4.88158011158039E-01  -4.88266507123834E-01   0.00000000000000E+00   7.20973859486174E-11
     -1.66773666919081E-22   2.72150154628196E-10   3.44247540576646E-10  -3.23881468584931E-18
      4.01580960902399E-09
      0.00000000000000E+00  -2.04308617918143E-12   0.00000000000000E+00   1.09737549035720E-11  -4.64452285414174E-23
      2.03211767421415E-09   2.04309142911768E-09  -1.21685476248682E-18  -4.69060933276777E-02  -4.69060933252827E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.39504673495581E-09   0.00000000000000E+00  -2.39504673495581E-09
      4.45563825301274E-18  -4.88223275604394E-01  -4.88334200423860E-01   0.00000000000000E+00   7.36083206165441E-11
     -1.66763535029979E-22   2.78346985244478E-10   3.51955305860856E-10  -3.23878349052592E-18
      4.01593935536188E-09
      0.00000000000000E+00  -2.06724134506701E-12   0.00000000000000E+00   9.89691187225852E-12  -4.62580802611636E-23
      2.05738872969850E-09   2.06728564157072E-09  -1.21658301228498E-18  -4.70613113898084E-02  -4.70613113873782E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.43016429203835E-09   0.00000000000000E+00  -2.43016429203835E-09
      4.45532294809538E-18  -4.88311444236168E-01  -4.88425811148323E-01   0.00000000000000E+00   7.52471914064579E-11
     -1.66749604190130E-22   2.87631459054336E-10   3.62878650460627E-10  -3.23873993581040E-18
      4.01611451291803E-09
      0.00000000000000E+00  -2.09268233727350E-12   0.00000000000000E+00   7.98156598657310E-12  -4.52281235184976E-23
      2.08468476028635E-09   2.09266632627288E-09  -1.21621174689761E-18  -4.72728663939776E-02  -4.72728663915080E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.46957191299008E-09   0.00000000000000E+00  -2.46957191299008E-09
      4.45489038391436E-18  -4.88430583060317E-01  -4.88549369854186E-01   0.00000000000000E+00   7.68402109127448E-11
     -1.66730429911207E-22   3.00065375799584E-10   3.76905586712162E-10  -3.23867863701675E-18
      4.01635097561884E-09
      0.00000000000000E+00  -2.11812332947998E-12   0.00000000000000E+00   6.02099641817902E-12  -4.49729782258702E-23
      2.11211646716851E-09   2.11813746358664E-09  -1.21570459458434E-18  -4.75611959948153E-02  -4.75611959923037E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.51154897743933E-09   0.00000000000000E+00  -2.51154897743933E-09
      4.45429649625995E-18  -4.88591581071469E-01  -4.88715568700865E-01   0.00000000000000E+00   7.83383006233726E-11
     -1.66704001297496E-22   3.15073213226687E-10   3.93411513849893E-10  -3.23859190167561E-18
      4.01667020026493E-09
      0.00000000000000E+00  -2.14356432168647E-12   0.00000000000000E+00   4.46908621967150E-12  -4.54395905984985E-23
      2.13908476404776E-09   2.14355385026738E-09  -1.21501197154460E-18  -4.79542256729573E-02  -4.79542256704023E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.55496364852557E-09   0.00000000000000E+00  -2.55496364852557E-09
      4.45348088889348E-18  -4.88809169063627E-01  -4.88938827654892E-01   0.00000000000000E+00   7.97797994947617E-11
     -1.66667547530492E-22   3.31629998772362E-10   4.11409798266957E-10  -3.23846891734888E-18
      4.01710115353715E-09
      0.00000000000000E+00  -2.16983191652782E-12   0.00000000000000E+00   3.44019831015562E-12  -4.60696881797211E-23
      2.16647726005360E-09   2.16991745836371E-09  -1.21406584130057E-18  -4.84902934530923E-02  -4.84902934504923E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.59994007514060E-09   0.00000000000000E+00  -2.59994007514060E-09
      4.45236043621053E-18  -4.89103306827078E-01  -4.89238830000617E-01   0.00000000000000E+00   8.12593828085390E-11
     -1.66617245219203E-22   3.48763233967469E-10   4.30022616775841E-10  -3.23829459490996E-18
      4.01768294045464E-09
      0.00000000000000E+00  -2.19922223243423E-12   0.00000000000000E+00   2.84412924458583E-12  -4.46664035367445E-23
      2.19639260190608E-09   2.19923673115062E-09  -1.21277201940022E-18  -4.92223835623890E-02  -4.92223835597406E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.64833614059139E-09   0.00000000000000E+00  -2.64833614059139E-09
      4.45081966889080E-18  -4.89501046868470E-01  -4.89642580881593E-01   0.00000000000000E+00   8.29140458469430E-11
     -1.66547750073472E-22   3.66185363593380E-10   4.49099409440157E-10  -3.23804764949059E-18
      4.01846835279326E-09
      0.00000000000000E+00  -2.23412323257309E-12   0.00000000000000E+00   2.52358052663815E-12  -4.54767554121269E-23
      2.23162414123927E-09   2.23414772176587E-09  -1.21099891051527E-18  -5.02242690240189E-02  -5.02242690213152E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.70368889661280E-09   0.00000000000000E+00  -2.70368889661280E-09
      4.44869615827162E-18  -4.90039015346586E-01  -4.90186990400392E-01   0.00000000000000E+00   8.49051600963432E-11
     -1.68425549461181E-22   3.84636014753039E-10   4.69541174849214E-10  -3.23769724775635E-18
      4.01899850612182E-09
      0.00000000000000E+00  -2.25781917477263E-12   0.00000000000000E+00   2.51694694770465E-12  -3.89360186855667E-23
      2.25531713450402E-09   2.25783408145169E-09  -1.20978996381599E-18  -5.09066623892383E-02  -5.09066623864981E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.74020856858451E-09   0.00000000000000E+00  -2.74020856858451E-09
      4.44724342757802E-18  -4.90402491680780E-01  -4.90554510439197E-01   0.00000000000000E+00   8.62437293022173E-11
     -1.66748435155449E-22   3.96130757829512E-10   4.82374487131563E-10  -3.23745346376202E-18
      4.01971421311539E-09
      0.00000000000000E+00  -2.28757686962787E-12   0.00000000000000E+00   2.37450615026865E-12  -3.89068537399486E-23
      2.28520015371251E-09   2.28757465986274E-09  -1.20813746585392E-18  -5.18382839185612E-02  -5.18382839157754E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.78578890167514E-09   0.00000000000000E+00  -2.78578890167514E-09
      4.44524961897849E-18  -4.90893816274080E-01  -4.91050826104610E-01   0.00000000000000E+00   8.79468067763896E-11
     -1.66350578279020E-22   4.10267435038739E-10   4.98214241814963E-10  -3.23711215312457E-18
      4.01995576422572E-09
      0.00000000000000E+00  -2.29841454861836E-12   0.00000000000000E+00   2.50867322805249E-12  -4.01858303483947E-23
      2.29594136671963E-09   2.29845003994765E-09  -1.20757722249085E-18  -5.21539464806218E-02  -5.21539464778197E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.80210373348999E-09   0.00000000000000E+00  -2.80210373348999E-09
      4.44457276771041E-18  -4.91059666361141E-01  -4.91218390146678E-01   0.00000000000000E+00   8.85410319540147E-11
     -1.66634012655355E-22   4.15112661582687E-10   5.03653693536535E-10  -3.23699554521956E-18
      4.02028185822466E-09
      0.00000000000000E+00  -2.31246679341111E-12   0.00000000000000E+00   2.44855768703529E-12  -4.21957126507160E-23
      2.31003717506542E-09   2.31248573275241E-09  -1.20681650433644E-18  -5.25822955208760E-02  -5.25822955180526E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.82335998667735E-09   0.00000000000000E+00  -2.82335998667735E-09
      4.44365208696190E-18  -4.91283674965011E-01  -4.91444673940240E-01   0.00000000000000E+00   8.93390812872287E-11
     -1.66287158734764E-22   4.21535172638213E-10   5.10874253925276E-10  -3.23683558262546E-18
      4.02072208512324E-09
      0.00000000000000E+00  -2.33046836190378E-12   0.00000000000000E+00   2.33828444412957E-12  -4.39325325853871E-23
      2.32806961971585E-09   2.33040790415994E-09  -1.20578199362977E-18  -5.31643590195069E-02  -5.31643590166563E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.85061266321711E-09   0.00000000000000E+00  -2.85061266321711E-09
      4.44239717059014E-18  -4.91586277615866E-01  -4.91750216624084E-01   0.00000000000000E+00   9.03572684571891E-11
     -1.66172285014123E-22   4.29847490602357E-10   5.20204759059380E-10  -3.23661517696036E-18
      4.02131639143631E-09
      0.00000000000000E+00  -2.35352139094287E-12   0.00000000000000E+00   2.24732174888508E-12  -4.50660018891699E-23
      2.35129707387413E-09   2.35354439562297E-09  -1.20437230831118E-18  -5.39567266726586E-02  -5.39567266697729E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.88569787803277E-09   0.00000000000000E+00  -2.88569787803277E-09
      4.44068218212360E-18  -4.91995087744782E-01  -4.92162791791042E-01   0.00000000000000E+00   9.16641705272240E-11
     -1.66085857710676E-22   4.40489311881466E-10   5.32153482408524E-10  -3.23630987381242E-18
      4.02211870495896E-09
      0.00000000000000E+00  -2.38364646474694E-12   0.00000000000000E+00   2.17788566770975E-12  -4.33152177111570E-23
      2.38149105597155E-09   2.38366894163922E-09  -1.20244630448234E-18  -5.50378976318234E-02  -5.50378976288923E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.93112050822254E-09   0.00000000000000E+00  -2.93112050822254E-09
      4.43833050450333E-18  -4.92547420306820E-01  -4.92719944790058E-01   0.00000000000000E+00   9.33521828526282E-11
     -1.65976728267097E-22   4.54099383730311E-10   5.47451566582773E-10  -3.23588420002099E-18
      4.02266026658675E-09
      0.00000000000000E+00  -2.40495444377909E-12   0.00000000000000E+00   2.25700102907974E-12  -4.41640353132189E-23
      2.40272992718524E-09   2.40498692821428E-09  -1.20113529436167E-18  -5.57730419508431E-02  -5.57730419478802E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.96288481219444E-09   0.00000000000000E+00  -2.96288481219444E-09
      4.43672591978149E-18  -4.92920350996627E-01  -4.93096167118206E-01   0.00000000000000E+00   9.45089977327163E-11
     -1.66080242464261E-22   4.63388886247046E-10   5.57897883979597E-10  -3.23559062541981E-18
      4.02339137478426E-09
      0.00000000000000E+00  -2.43223233072972E-12   0.00000000000000E+00   2.17135095472149E-12  -4.50004141826269E-23
      2.43010678445612E-09   2.43227813541080E-09  -1.19934658520177E-18  -5.67747804778427E-02  -5.67747804748389E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.00372552611344E-09   0.00000000000000E+00  -3.00372552611344E-09
      4.43452987142626E-18  -4.93424083004244E-01  -4.93604168596220E-01   0.00000000000000E+00   9.60070723454800E-11
     -1.65817164895976E-22   4.75440318356698E-10   5.71447390702012E-10  -3.23518328622449E-18
      4.02388487281759E-09
      0.00000000000000E+00  -2.45142788080610E-12   0.00000000000000E+00   2.22978499736021E-12  -4.61291805178987E-23
      2.44916296954852E-09   2.45139275454584E-09  -1.19813029603024E-18  -5.74552487171480E-02  -5.74552487141160E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.03205137145869E-09   0.00000000000000E+00  -3.03205137145869E-09
      4.43303356003751E-18  -4.93764157811074E-01  -4.93947145868097E-01   0.00000000000000E+00   9.70195969419135E-11
     -1.65739283407014E-22   4.83639019974936E-10   5.80658616916684E-10  -3.23490326400728E-18
      4.02455109516257E-09
      0.00000000000000E+00  -2.47585858090330E-12   0.00000000000000E+00   2.14653505547020E-12  -4.61211619198750E-23
      2.47374453563576E-09   2.47589107069118E-09  -1.19647296603837E-18  -5.83813643077421E-02  -5.83813643046736E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.06850434411003E-09   0.00000000000000E+00  -3.06850434411003E-09
      4.43098925387778E-18  -4.94223441371938E-01  -4.94410196367341E-01   0.00000000000000E+00   9.83356382923665E-11
     -1.65637587868547E-22   4.94277635124593E-10   5.92613273416794E-10  -3.23451628783942E-18
      4.02545049532830E-09
      0.00000000000000E+00  -2.50772870471431E-12   0.00000000000000E+00   2.07601891806705E-12  -4.54969658047001E-23
      2.50561194453111E-09   2.50768796344914E-09  -1.19420884167389E-18  -5.96446142124348E-02  -5.96446142093192E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.11558983976873E-09   0.00000000000000E+00  -3.11558983976873E-09
      4.42818709185955E-18  -4.94843744914655E-01  -4.95035317399056E-01   0.00000000000000E+00   1.00020546794476E-10
     -1.65506685793122E-22   5.07881329526000E-10   6.07901876320310E-10  -3.23397825018566E-18
      4.02666468555204E-09
      0.00000000000000E+00  -2.54942621540653E-12   0.00000000000000E+00   2.02780262034796E-12  -4.56909481851800E-23
      2.54739428647101E-09   2.54942208909131E-09  -1.19110521538025E-18  -6.13726915432914E-02  -6.13726915401145E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.17685398030536E-09   0.00000000000000E+00  -3.17685398030536E-09
      4.42432978681442E-18  -4.95681504309828E-01  -4.95879230796324E-01   0.00000000000000E+00   1.02187616272615E-10
     -1.65326691344981E-22   5.25244274941034E-10   6.27431891213483E-10  -3.23322457143417E-18
      4.02830384235408E-09
      0.00000000000000E+00  -2.60444121299384E-12   0.00000000000000E+00   1.99119175762187E-12  -4.57679843625792E-23
      2.60250294641072E-09   2.60449413816830E-09  -1.18683218419372E-18  -6.37452049685720E-02  -6.37452049653152E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.25681680530326E-09   0.00000000000000E+00  -3.25681680530326E-09
      4.41899135339500E-18  -4.96812844288332E-01  -4.97018414028241E-01   0.00000000000000E+00   1.04967533724795E-10
     -1.65076989928630E-22   5.47355133409582E-10   6.52322667134212E-10  -3.23215916920128E-18
      4.03051670403684E-09
      0.00000000000000E+00  -2.67764146854824E-12   0.00000000000000E+00   1.96704073656607E-12  -4.57460626277045E-23
      2.67569242011518E-09   2.67765946085170E-09  -1.18091617590486E-18  -6.70172813456734E-02  -6.70172813423119E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.36154592368535E-09   0.00000000000000E+00  -3.36154592368535E-09
      4.41155271722564E-18  -4.98340335207744E-01  -4.98555851003948E-01   0.00000000000000E+00   1.08520636858260E-10
     -1.64728113554256E-22   5.75365825974812E-10   6.83886462832907E-10  -3.23063654132078E-18
      4.03350406730856E-09
      0.00000000000000E+00  -2.77646640578353E-12   0.00000000000000E+00   1.96935663026275E-12  -4.55498890472248E-23
      2.77445328955413E-09   2.77642264618435E-09  -1.17266509971456E-18  -7.15565728260276E-02  -7.15565728225273E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.50024259041179E-09   0.00000000000000E+00  -3.50024259041179E-09
      4.40109622106892E-18  -5.00402006105865E-01  -5.00630105499933E-01   0.00000000000000E+00   1.13080639897887E-10
     -1.64236547720523E-22   6.10739304330005E-10   7.23819944227728E-10  -3.22843112135436E-18
      4.03753700772539E-09
      0.00000000000000E+00  -2.91414166685762E-12   0.00000000000000E+00   2.02591462424831E-12  -4.52390097652413E-23
      2.91212393849650E-09   2.91414985312070E-09  -1.16103883805906E-18  -7.79054913889703E-02  -7.79054913852815E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.68883377132531E-09   0.00000000000000E+00  -3.68883377132531E-09
      4.38621937426158E-18  -5.03183408869531E-01  -5.03427536572885E-01   0.00000000000000E+00   1.19054664600863E-10
     -1.63536245382083E-22   6.55629253603366E-10   7.74683918204065E-10  -3.22518053620252E-18
      4.04298147728811E-09
      0.00000000000000E+00  -3.11564902029093E-12   0.00000000000000E+00   2.16991657595987E-12  -4.47734883734188E-23
      3.11346295146045E-09   3.11563286803636E-09  -1.14441068905955E-18  -8.68920605197211E-02  -8.68920605157658E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.95535930877376E-09   0.00000000000000E+00  -3.95535930877376E-09
      4.36468454089535E-18  -5.06933238804105E-01  -5.07197863494428E-01   0.00000000000000E+00   1.27136959341822E-10
     -1.62523321747603E-22   7.12589481396081E-10   8.39726440737740E-10  -3.22027385183580E-18
      4.05033151119778E-09
      0.00000000000000E+00  -3.42103277150596E-12   0.00000000000000E+00   2.39793206905306E-12  -4.46364799697553E-23
      3.41868052518955E-09   3.42107845725856E-09  -1.12016115025670E-18  -9.98051270430979E-02  -9.98051270387615E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.33635863068653E-09   0.00000000000000E+00  -4.33635863068653E-09
      4.33281215791532E-18  -5.11976473182001E-01  -5.12264909602414E-01   0.00000000000000E+00   1.37951070282495E-10
     -1.61031736077876E-22   7.77329103145628E-10   9.15280173427961E-10  -3.21265100765861E-18
      4.06025405697583E-09
      0.00000000000000E+00  -3.87391917067627E-12   0.00000000000000E+00   2.59834542501113E-12  -4.40075852513095E-23
      3.87135788250203E-09   3.87395622792699E-09  -1.08432218002510E-18  -1.18484691756847E-01  -1.18484691752021E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.82544969407649E-09   0.00000000000000E+00  -4.82544969407649E-09
      4.28493141242615E-18  -5.18679370160679E-01  -5.18979229644110E-01   0.00000000000000E+00   1.49875683658555E-10
     -1.58824547686774E-22   8.01617782491143E-10   9.51493466149540E-10  -3.20060923240105E-18
      4.07364949377621E-09
      0.00000000000000E+00  -4.55338653653755E-12   0.00000000000000E+00   2.82933044642796E-12  -4.28230656057740E-23
      4.55055549263079E-09   4.55338482307717E-09  -1.03205479522364E-18  -1.44901435468179E-01  -1.44901435462877E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30161111092466E-09   0.00000000000000E+00  -5.30161111092466E-09
      4.21391401584960E-18  -5.27199425686288E-01  -5.27435272315689E-01   0.00000000000000E+00   1.57178611182199E-10
     -1.55649872291701E-22   5.91047676665555E-10   7.48226287847599E-10  -3.18185922062596E-18
      4.09173333345671E-09
      0.00000000000000E+00  -5.96182558161498E-12   0.00000000000000E+00   4.11872565147066E-12  -3.85971035036352E-23
      5.95768939029314E-09   5.96180811594457E-09  -9.59268470550090E-19  -1.80183703146312E-01  -1.80183703140684E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.62783422153676E-09   0.00000000000000E+00  -5.62783422153676E-09
      4.11214116403889E-18  -5.36386398089025E-01  -5.36281365223758E-01   0.00000000000000E+00   1.56543951999626E-10
     -1.51248602204080E-22  -4.90517846407350E-10  -3.33973894407875E-10  -3.15287269348879E-18
      4.11173333345671E-09
      0.00000000000000E+00  -9.27944117902526E-12   0.00000000000000E+00   8.38835538514015E-12  -2.28365677982664E-23
      9.27108761357086E-09   9.27947596895598E-09  -8.81560562291107E-19  -2.16138099829275E-01  -2.16138099823430E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.84489781703787E-09   0.00000000000000E+00  -5.84489781703787E-09
      3.99524320769813E-18  -5.40245129699410E-01  -5.39163401884861E-01   0.00000000000000E+00   1.55317853935908E-10
     -1.46119384890075E-22  -3.58989600585389E-09  -3.43457815191812E-09  -3.11368264540702E-18
      4.13173333345671E-09
      0.00000000000000E+00  -1.54813489037007E-11   0.00000000000000E+00   1.54384207892564E-11   1.56793271052486E-23
      1.54658917591911E-08   1.54813301799804E-08  -8.12418279063251E-19  -2.46937997100532E-01  -2.46937997094454E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.07729096485521E-09   0.00000000000000E+00  -6.07729096485521E-09
      3.87369738840102E-18  -5.32528816346080E-01  -5.29566625692570E-01   0.00000000000000E+00   1.61493250260321E-10
     -1.40209924205907E-22  -9.56553246538535E-09  -9.40403921512517E-09  -3.06127910933777E-18
      4.15173333345671E-09
      0.00000000000000E+00  -2.39522808610881E-11   0.00000000000000E+00   2.10071589265190E-11   6.95608181403597E-23
      2.39312279697192E-08   2.39522351286458E-08  -7.56363162929820E-19  -2.71470718525509E-01  -2.71470718519153E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35603542033458E-09   0.00000000000000E+00  -6.35603542033458E-09
      3.74657667999433E-18  -5.08642088399094E-01  -5.03099116076270E-01   0.00000000000000E+00   1.71933855390744E-10
     -1.32936019705478E-22  -1.77681335637018E-08  -1.75961997083112E-08  -2.99021351706452E-18
      4.17173333345671E-09
      0.00000000000000E+00  -3.22020506912798E-11   0.00000000000000E+00   2.04615327294012E-11   1.22301438124078E-22
      3.21815728771418E-08   3.22020344098713E-08  -7.14930162846075E-19  -2.89787617673999E-01  -2.89787617667354E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64521276359260E-09   0.00000000000000E+00  -6.64521276359260E-09
      3.61367242472248E-18  -4.66994065897491E-01  -4.58943069017040E-01   0.00000000000000E+00   1.76265211387110E-10
     -1.24133513778179E-22  -2.57330868576656E-08  -2.55568216462786E-08  -2.89874226187640E-18
      4.19173333345671E-09
      0.00000000000000E+00  -3.74901951254776E-11   0.00000000000000E+00   1.31430262037237E-11   1.57178784519822E-22
      3.74770771798385E-08   3.74902202060424E-08  -6.87478145396313E-19  -3.02533778815219E-01  -3.02533778808299E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.91972561314818E-09   0.00000000000000E+00  -6.91972561314818E-09
      3.47527791245952E-18  -4.08579945949885E-01  -3.98949179878907E-01   0.00000000000000E+00   1.69536585063302E-10
     -1.14348029148701E-22  -3.07400311779575E-08  -3.05704945928943E-08  -2.78779976706320E-18
      4.21173333345671E-09
      0.00000000000000E+00  -3.82751920943903E-11   0.00000000000000E+00   1.99057236227905E-12   1.65259866133135E-22
      3.82731794695093E-08   3.82751700418717E-08  -6.72450501635211E-19  -3.10499562219300E-01  -3.10499562212126E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.17426284644291E-09   0.00000000000000E+00  -7.17426284644291E-09
      3.33179265553066E-18  -3.36432651952328E-01  -3.26634507201510E-01   0.00000000000000E+00   1.52115273968334E-10
     -1.04485384308036E-22  -3.12530224693969E-08  -3.11009071954287E-08  -2.65934215389545E-18
      4.23173333345671E-09
      0.00000000000000E+00  -3.58090690556310E-11   0.00000000000000E+00  -6.07576036817352E-12   1.53030994762693E-22
      3.58151629106095E-08   3.58090871502415E-08  -6.65271140644329E-19  -3.15524234555497E-01  -3.15524234548163E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.33397742395906E-09   0.00000000000000E+00  -7.33397742395906E-09
      3.18511310705148E-18  -2.59755787850959E-01  -2.50784680989655E-01   0.00000000000000E+00   1.19579907076375E-10
     -9.44174427632080E-23  -2.85946896333587E-08  -2.84751097262824E-08  -2.51984196640715E-18
      4.25173333345671E-09
      0.00000000000000E+00  -3.30612582078562E-11   0.00000000000000E+00  -6.78984959507846E-12   1.34388692064401E-22
      3.30680467670670E-08   3.30612569174720E-08  -6.59170339649914E-19  -3.20205958138833E-01  -3.20205958131507E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32613041924064E-09   0.00000000000000E+00  -7.32613041924064E-09
      3.03859049866666E-18  -1.89766195434874E-01  -1.81658181155820E-01   0.00000000000000E+00   8.03040017772755E-11
     -8.50595055459173E-23  -2.58154305000085E-08  -2.57351264982313E-08  -2.37942015901675E-18
      4.26173333345671E-09
      0.00000000000000E+00  -3.16252657416165E-11   0.00000000000000E+00  -7.09556464027288E-12   1.24168757748687E-22
      3.16323385233867E-08   3.16252429587465E-08  -6.56352659579845E-19  -3.22471775968030E-01  -3.22471775960713E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.31728576084837E-09   0.00000000000000E+00  -7.31728576084837E-09
      2.96541764105818E-18  -1.57061911726021E-01  -1.49403482416198E-01   0.00000000000000E+00   6.07382682347084E-11
     -8.18320610123387E-23  -2.43686954661327E-08  -2.43079571978981E-08  -2.30906498147833E-18
      4.27523333345671E-09
      0.00000000000000E+00  -3.02761583967752E-11   0.00000000000000E+00  -4.94069600978928E-12   1.12585729343505E-22
      3.02811246748975E-08   3.02761839788879E-08  -6.51260385248622E-19  -3.26043155915516E-01  -3.26043155908278E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23773173476255E-09   0.00000000000000E+00  -7.23773173476255E-09
      2.86770826263889E-18  -1.17371448768640E-01  -1.10112936999675E-01   0.00000000000000E+00   4.59796867667454E-11
     -7.81055940943662E-23  -2.30844319308919E-08  -2.30384522441253E-08  -2.21644787739026E-18
      4.29345833345671E-09
      0.00000000000000E+00  -2.85241281898044E-11   0.00000000000000E+00  -4.73998721118766E-12   1.01209334178259E-22
      2.85288494958010E-08   2.85241095085899E-08  -6.41410986308089E-19  -3.31950265137954E-01  -3.31950265130850E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.10460115592394E-09   0.00000000000000E+00  -7.10460115592394E-09
      2.73822690657217E-18  -7.23350800889933E-02  -6.55865870799038E-02   0.00000000000000E+00   3.35698773817873E-11
     -6.28037095059017E-23  -2.14530782300476E-08  -2.14195083526659E-08  -2.09681592026408E-18
      4.29845833345671E-09
      0.00000000000000E+00  -2.75525945596232E-11   0.00000000000000E+00  -9.54225449698213E-12   9.81684230485048E-23
      2.75621107166754E-08   2.75525684621785E-08  -6.38293103500782E-19  -3.33692451415904E-01  -3.33692451408844E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.06017157877995E-09   0.00000000000000E+00  -7.06017157877995E-09
      2.70292604867827E-18  -6.12224494355267E-02  -5.47660440754869E-02   0.00000000000000E+00   3.19615306768398E-11
     -5.24312906639828E-23  -2.05243584140757E-08  -2.04923968833989E-08  -2.06463294517749E-18
      4.30520833345671E-09
      0.00000000000000E+00  -2.62876169940639E-11   0.00000000000000E+00  -9.24225546883975E-12   9.62685306157250E-23
      2.62968557081629E-08   2.62876134526942E-08  -6.32251815275577E-19  -3.36687435102105E-01  -3.36687435095186E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.91868864467990E-09   0.00000000000000E+00  -6.91868864467990E-09
      2.65622490032668E-18  -4.88533239165336E-02  -4.27508718460802E-02   0.00000000000000E+00   2.69701185171091E-11
     -3.21506024261968E-23  -1.93958949265311E-08  -1.93689248080141E-08  -2.02397308505110E-18
      4.31432083345671E-09
      0.00000000000000E+00  -2.46356057059121E-11   0.00000000000000E+00  -8.92890695687046E-12   9.81498001327788E-23
      2.46444541575274E-08   2.46355252505706E-08  -6.20640584867771E-19  -3.41918749214580E-01  -3.41918749207879E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.70135580400981E-09   0.00000000000000E+00  -6.70135580400981E-09
      2.59515879556264E-18  -3.67400083562873E-02  -3.10895846251709E-02   0.00000000000000E+00   2.20315664671706E-11
      3.44337840879120E-24  -1.79562010130280E-08  -1.79341694465608E-08  -1.97451821069487E-18
      4.32662270845671E-09
      0.00000000000000E+00  -2.28697987883602E-11   0.00000000000000E+00  -7.05849009620789E-12   1.06699944907349E-22
      2.28768349660374E-08   2.28697764759413E-08  -6.00328798009546E-19  -3.50553158509334E-01  -3.50553158502886E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.44763117882946E-09   0.00000000000000E+00  -6.44763117882946E-09
      2.51584084275458E-18  -2.67357167522190E-02  -2.15616676212957E-02   0.00000000000000E+00   1.62203217484185E-11
      5.27879762949303E-23  -1.64383656188603E-08  -1.64221452971119E-08  -1.91551204474504E-18
      4.34323023970671E-09
      0.00000000000000E+00  -2.14029464904188E-11   0.00000000000000E+00  -4.32722986111766E-12   1.22042300097612E-22
      2.14073333674869E-08   2.14030061376259E-08  -5.69262903634690E-19  -3.63393507321687E-01  -3.63393507315465E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.22178385943550E-09   0.00000000000000E+00  -6.22178385943550E-09
      2.41251237287826E-18  -1.96095043977567E-02  -1.48264175175531E-02   0.00000000000000E+00   1.08230063929834E-11
      1.09334056248582E-22  -1.51920452845835E-08  -1.51812222781904E-08  -1.84324946924357E-18
      4.36323023970671E-09
      0.00000000000000E+00  -2.03616108599599E-11   0.00000000000000E+00  -2.53522407609289E-12   1.36785347943555E-22
      2.03641052392823E-08   2.03615700152064E-08  -5.31340196695194E-19  -3.78929102049430E-01  -3.78929102043374E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.05598828210420E-09   0.00000000000000E+00  -6.05598828210420E-09
      2.29139260723618E-18  -1.51517402580528E-02  -1.06445304273021E-02   0.00000000000000E+00   7.41633016021457E-12
      1.58637675240222E-22  -1.43129980632626E-08  -1.43055817331022E-08  -1.76005241054098E-18
      4.38323023970671E-09
      0.00000000000000E+00  -1.95850636068702E-11   0.00000000000000E+00  -1.88241470956678E-12   1.42322066322332E-22
      1.95869841429048E-08   1.95851017281954E-08  -4.94902818280827E-19  -3.93879107676703E-01  -3.93879107670767E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.93611706093864E-09   0.00000000000000E+00  -5.93611706093864E-09
      2.17267026601740E-18  -1.25337427341960E-02  -8.23339945813049E-03   0.00000000000000E+00   5.77287169682318E-12
      1.85725729816648E-22  -1.36547575389537E-08  -1.36489846672567E-08  -1.67776744773658E-18
      4.40323023970671E-09
      0.00000000000000E+00  -1.89108313910298E-11   0.00000000000000E+00  -1.63329861644976E-12   1.37505996734267E-22
      1.89124156174019E-08   1.89107823187856E-08  -4.60419035808138E-19  -4.08118108942405E-01  -4.08118108936572E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.83249491810221E-09   0.00000000000000E+00  -5.83249491810221E-09
      2.05602036765536E-18  -1.08005554895910E-02  -6.68001614797350E-03   0.00000000000000E+00   4.87082757146639E-12
      1.90950128459286E-22  -1.30831582282551E-08  -1.30782874006834E-08  -1.59560133184722E-18
      4.42323023970671E-09
      0.00000000000000E+00  -1.83183409913040E-11   0.00000000000000E+00  -1.43440277307422E-12   1.23959216092615E-22
      1.83197825996843E-08   1.83183481969114E-08  -4.27746291002658E-19  -4.21707866040672E-01  -4.21707866034933E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.73928294733040E-09   0.00000000000000E+00  -5.73928294733040E-09
      1.94123470870875E-18  -9.57410808660492E-03  -5.61085415996689E-03   0.00000000000000E+00   4.21999447924040E-12
      1.78012795135127E-22  -1.25832852440604E-08  -1.25790652495810E-08  -1.51348841770609E-18
      4.44323023970671E-09
      0.00000000000000E+00  -1.78144807629835E-11   0.00000000000000E+00  -1.21844973648047E-12   1.04653115674211E-22
      1.78157373978961E-08   1.78145189481597E-08  -3.96593475335645E-19  -4.34746508833815E-01  -4.34746508828160E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.65491882162949E-09   0.00000000000000E+00  -5.65491882162949E-09
      1.82813633227616E-18  -8.67450642138453E-03  -4.84340969483056E-03   0.00000000000000E+00   3.67584726421522E-12
      1.52643684308061E-22  -1.21632759737946E-08  -1.21596001265302E-08  -1.43154285694052E-18
      4.46323023970671E-09
      0.00000000000000E+00  -1.74006283771264E-11   0.00000000000000E+00  -9.98674711249679E-13   8.29294544281508E-23
      1.74016164126810E-08   1.74006177379698E-08  -3.66639566163703E-19  -4.47344451759408E-01  -4.47344451753820E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58880285218591E-09   0.00000000000000E+00  -5.58880285218591E-09
      1.71636027523244E-18  -7.99490172950422E-03  -4.27337865348472E-03   0.00000000000000E+00   3.23573348439720E-12
      1.21141306865029E-22  -1.18150506192684E-08  -1.18118148857839E-08  -1.34972070906874E-18
      4.48323023970671E-09
      0.00000000000000E+00  -1.72705762292405E-11   0.00000000000000E+00  -3.00395028644388E-13   6.19553177122512E-23
      1.72708758199435E-08   1.72705754249149E-08  -3.36753821144759E-19  -4.59971704549811E-01  -4.59971704544110E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.70064917115011E-09   0.00000000000000E+00  -5.70064917115011E-09
      1.60234729180944E-18  -7.50851859370944E-03  -3.86320489101836E-03   0.00000000000000E+00   2.82592516401875E-12
      8.92586497631012E-23  -1.15727521789289E-08  -1.15699262537648E-08  -1.26559347066468E-18
      4.50323023970671E-09
      0.00000000000000E+00  -1.76202291437896E-11   0.00000000000000E+00   8.82144735582159E-13   4.38309303183993E-23
      1.76193165392211E-08   1.76201986839567E-08  -3.05363812244540E-19  -4.73320289286340E-01  -4.73320289280216E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.12400086778779E-09   0.00000000000000E+00  -6.12400086778779E-09
      1.47986727445368E-18  -7.21658106310064E-03  -3.59449493257476E-03   0.00000000000000E+00   2.38467647605239E-12
      6.09224675371091E-23  -1.14985824926451E-08  -1.14961978161689E-08  -1.17450346220914E-18
      4.52323023970671E-09
      0.00000000000000E+00  -1.79478393214088E-11   0.00000000000000E+00   8.30415285388425E-13   2.92802516085282E-23
      1.79470489597026E-08   1.79478793749881E-08  -2.73421461911182E-19  -4.87021430617307E-01  -4.87021430610870E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.43726879409360E-09   0.00000000000000E+00  -6.43726879409360E-09
      1.35112189857181E-18  -7.00385460290706E-03  -3.37722566391702E-03   0.00000000000000E+00   2.08845858018006E-12
      3.80082406697139E-23  -1.15126990394746E-08  -1.15106105808944E-08  -1.07770043666063E-18
      4.53323023970671E-09
      0.00000000000000E+00  -1.80929540061967E-11   0.00000000000000E+00   7.37128508027005E-13   2.28366952385231E-23
      1.80921890615461E-08   1.80929261900541E-08  -2.57557467962233E-19  -4.93890573036178E-01  -4.93890573029594E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.58411447942896E-09   0.00000000000000E+00  -6.58411447942896E-09
      1.28528075377752E-18  -6.90760023280083E-03  -3.28153720600369E-03   0.00000000000000E+00   2.04100709654841E-12
      2.78107375325059E-23  -1.15108527177217E-08  -1.15088117106251E-08  -1.02772328581529E-18
      4.54673023970671E-09
      0.00000000000000E+00  -1.82342112120219E-11   0.00000000000000E+00   5.37746531504521E-13   1.64100437007895E-23
      1.82336408005057E-08   1.82341785470372E-08  -2.36347592552142E-19  -5.03139342746661E-01  -5.03139342739998E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66236406688340E-09   0.00000000000000E+00  -6.66236406688340E-09
      1.19533883887460E-18  -6.81280597734889E-03  -3.16689173284960E-03   0.00000000000000E+00   1.72695004065572E-12
      1.77655392091414E-23  -1.15735414301944E-08  -1.15718144801538E-08  -9.58991246322455E-19
      4.55584273970671E-09
      0.00000000000000E+00  -1.83819893941888E-11   0.00000000000000E+00   8.18617127216451E-13   1.29444460762279E-23
      1.83811928179880E-08   1.83820114351152E-08  -2.22202543946563E-19  -5.09362919282063E-01  -5.09362919275332E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73004370287625E-09   0.00000000000000E+00  -6.73004370287625E-09
      1.13401131563214E-18  -6.77861396268868E-03  -3.10744499510208E-03   0.00000000000000E+00   1.45082471307425E-12
      1.23434048945206E-23  -1.16534185569520E-08  -1.16519677322389E-08  -9.11808771685575E-19
      4.56814461470671E-09
      0.00000000000000E+00  -1.85641175080713E-11   0.00000000000000E+00   7.49324190774238E-13   9.69501000479395E-24
      1.85633310999313E-08   1.85640804241221E-08  -2.03495399523370E-19  -5.17660514619116E-01  -5.17660514612383E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73219823982325E-09   0.00000000000000E+00  -6.73219823982325E-09
      1.05119265441061E-18  -6.76905676358166E-03  -3.04120129926423E-03   0.00000000000000E+00   1.08346063697649E-12
      7.33193860096449E-24  -1.18329656449359E-08  -1.18318821842989E-08  -8.47697254887242E-19
      4.58475214595671E-09
      0.00000000000000E+00  -1.84216663206625E-11   0.00000000000000E+00  -4.03149017306912E-13   6.94868930889107E-24
      1.84220909136533E-08   1.84216877646360E-08  -1.80232920505051E-19  -5.28078441090566E-01  -5.28078441084180E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.38657344982479E-09   0.00000000000000E+00  -6.38657344982479E-09
      9.45127436262227E-19  -6.71976999158978E-03  -2.92788126669896E-03   0.00000000000000E+00   1.01792184344350E-12
      3.29368826659289E-24  -1.20361322366547E-08  -1.20351143148112E-08  -7.64894515757175E-19
      4.60475214595671E-09
      0.00000000000000E+00  -1.70624560547283E-11   0.00000000000000E+00  -3.33525658932387E-12   4.86650291853239E-24
      1.70657700783549E-08   1.70624348217656E-08  -1.59376376286405E-19  -5.37473360754873E-01  -5.37473360749949E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.92333638973436E-09   0.00000000000000E+00  -4.92333638973436E-09
      8.46660708467539E-19  -6.52698760335697E-03  -2.70233561021112E-03   0.00000000000000E+00   9.28451622201765E-13
      6.32096345095214E-25  -1.21400268836534E-08  -1.21390984320312E-08  -6.87284332181135E-19
      4.62475214595671E-09
      0.00000000000000E+00  -1.35194534722107E-11   0.00000000000000E+00  -8.72476809444410E-12   3.18665005280054E-24
      1.35281952249616E-08   1.35194704568672E-08  -1.53961576786483E-19  -5.39758168543153E-01  -5.39758168541790E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36261905259788E-09   0.00000000000000E+00  -1.36261905259788E-09
      8.19408327415582E-19  -6.14545522848836E-03  -2.31520876299658E-03   0.00000000000000E+00   2.83308865709787E-13
     -1.00314600847530E-24  -1.21571347131351E-08  -1.21568514042694E-08  -6.65446750629098E-19
      4.64475214595671E-09
      0.00000000000000E+00  -7.16159338375690E-12   0.00000000000000E+00  -1.56676606682523E-11   1.25750026556858E-24
      7.17725398754423E-09   7.16158632687598E-09  -1.75639521889083E-19  -5.29548640770072E-01  -5.29548640775059E-01
      0.00000000000000E+00   0.00000000000000E+00   4.98752925995918E-09   0.00000000000000E+00   4.98752925995918E-09
      9.19158912614765E-19  -5.54289838552058E-03  -1.71508958679204E-03   0.00000000000000E+00  -1.14303261562846E-12
     -2.56743865333535E-24  -1.21479725542195E-08  -1.21491155868351E-08  -7.43519390725683E-19
      4.66475214595672E-09
      0.00000000000000E+00   9.43888364281752E-13   0.00000000000000E+00  -1.99961016019457E-11  -1.71574579190751E-24
     -9.23855520708398E-10  -9.43851622310345E-10  -2.35274021047191E-19  -5.02658670786966E-01  -5.02658670800040E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30737963265082E-08   0.00000000000000E+00   1.30737963265082E-08
      1.18063483914493E-18  -4.78836351913219E-03  -9.66593533040833E-04   0.00000000000000E+00  -3.35084970069027E-12
     -5.62669921179532E-24  -1.21265938544971E-08  -1.21299447041978E-08  -9.45360818097737E-19
      4.68475214595672E-09
      0.00000000000000E+00   8.16600742985841E-12   0.00000000000000E+00  -1.78713346914622E-11  -7.90208828714658E-24
     -8.14809400850747E-09  -8.16596534319895E-09  -3.39890135610008E-19  -4.58034324774399E-01  -4.58034324794658E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02588629378811E-08   0.00000000000000E+00   2.02588629378811E-08
      1.58581209790255E-18  -4.04715627601404E-03  -2.37059973971004E-04   0.00000000000000E+00  -6.59326392687642E-12
     -1.48036579336284E-23  -1.20863043307553E-08  -1.20928975946822E-08  -1.24592196229254E-18
      4.70475214595672E-09
      0.00000000000000E+00   1.19153851368813E-11   0.00000000000000E+00  -9.39442783180891E-12  -2.18158549911959E-23
     -1.19059084138796E-08  -1.19153028417114E-08  -4.91592839332920E-19  -3.96972258392530E-01  -3.96972258416481E-01
      0.00000000000000E+00   0.00000000000000E+00   2.39509358873206E-08   0.00000000000000E+00   2.39509358873206E-08
      2.06483081564896E-18  -3.49467434130673E-03   2.97376770283367E-04   0.00000000000000E+00  -1.19900585377842E-11
     -3.98306997983605E-23  -1.20236429870714E-08  -1.20356330456092E-08  -1.57323797631604E-18
      4.72475214595672E-09
      0.00000000000000E+00   1.11415932259079E-11   0.00000000000000E+00   1.64996120231294E-12  -3.69047482183676E-23
     -1.11432533580871E-08  -1.11416033968848E-08  -6.75651948728943E-19  -3.23156136868381E-01  -3.23156136891385E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30042545165597E-08   0.00000000000000E+00   2.30042545165597E-08
      2.52491590598016E-18  -3.95381757511089E-03  -2.16272564786021E-04   0.00000000000000E+00  -2.15469782774111E-11
     -6.85967831078799E-23  -1.18411041413975E-08  -1.18626511196750E-08  -1.84926395725121E-18
      4.74475214595672E-09
      0.00000000000000E+00   8.56837922356459E-12   0.00000000000000E+00   5.98194629838590E-12  -4.17945080619271E-23
     -8.57435324897922E-09  -8.56837130268088E-09  -8.49436075179855E-19  -2.47078366180547E-01  -2.47078366199976E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94282714694522E-08   0.00000000000000E+00   1.94282714694522E-08
      2.91348133536920E-18  -1.11332105702481E-02  -7.71160520257709E-03   0.00000000000000E+00  -3.54239309918744E-11
     -7.90137407938623E-23  -1.08244762357793E-08  -1.08599001667712E-08  -2.06404526018934E-18
      4.76475214595672E-09
      0.00000000000000E+00   6.89680500638760E-12   0.00000000000000E+00   3.68512761314859E-12  -4.37904373030591E-23
     -6.90041079311438E-09  -6.89672566550127E-09  -9.89761021032320E-19  -1.78613974522140E-01  -1.78613974538264E-01
      0.00000000000000E+00   0.00000000000000E+00   1.61235326169372E-08   0.00000000000000E+00   1.61235326169372E-08
      3.23595198770795E-18  -2.87097313748906E-02  -2.58026613701868E-02   0.00000000000000E+00  -5.52427831505088E-11
     -8.70237261271585E-23  -9.17156416828534E-09  -9.22680695143593E-09  -2.24619096667562E-18
      4.78475214595672E-09
      0.00000000000000E+00   5.64845133826289E-12   0.00000000000000E+00   2.56907244710568E-12  -4.55170919894036E-23
     -5.65106094005248E-09  -5.64849186760542E-09  -1.10225281804332E-18  -1.18761338905407E-01  -1.18761338918957E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35503840963560E-08   0.00000000000000E+00   1.35503840963560E-08
      3.50695966963507E-18  -5.34082837064606E-02  -5.09186489556702E-02   0.00000000000000E+00  -8.27951902532496E-11
     -9.56959165807018E-23  -7.81909703849740E-09  -7.90189222875074E-09  -2.40470685159174E-18
      4.78975214595672E-09
      0.00000000000000E+00   5.19767736804835E-12   0.00000000000000E+00   3.86026071371282E-12  -4.59210905596813E-23
     -5.20148820552378E-09  -5.19762794481011E-09  -1.12804867609580E-18  -1.04390765472310E-01  -1.04390765484931E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26207976795954E-08   0.00000000000000E+00   1.26207976795954E-08
      3.57006365803304E-18  -6.02064879383899E-02  -5.78676704690677E-02   0.00000000000000E+00  -1.02854671947357E-10
     -9.79375751243155E-23  -7.32031506283735E-09  -7.42316973478481E-09  -2.44201498193724E-18
      4.79650214595672E-09
      0.00000000000000E+00   4.69418451867669E-12   0.00000000000000E+00   3.11902498997835E-12  -4.64225286918169E-23
     -4.69731652988787E-09  -4.69419750489794E-09  -1.15936770913717E-18  -8.65615097576708E-02  -8.65615097693489E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16780920644707E-08   0.00000000000000E+00   1.16780920644707E-08
      3.64889077946822E-18  -7.00739836912131E-02  -6.78735669057939E-02   0.00000000000000E+00  -1.12205517338843E-10
     -1.00934025412891E-22  -6.87168904223411E-09  -6.98389455957305E-09  -2.48952307033105E-18
      4.80561464595672E-09
      0.00000000000000E+00   3.98964353955775E-12   0.00000000000000E+00   3.28477936604537E-12  -4.69917393604681E-23
     -3.99294735999723E-09  -3.98966258063123E-09  -1.19512931798491E-18  -6.56841176361431E-02  -6.56841176465437E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04005596275754E-08   0.00000000000000E+00   1.04005596275754E-08
      3.74366587907450E-18  -8.45321006485304E-02  -8.25122175472107E-02   0.00000000000000E+00  -1.20467649440787E-10
     -1.04883675730896E-22  -6.29042939750325E-09  -6.41089704694414E-09  -2.54853656108959E-18
      4.81176558345672E-09
      0.00000000000000E+00   3.37042632130461E-12   0.00000000000000E+00   4.47421612447326E-12  -4.73031587810842E-23
     -3.37489981580606E-09  -3.37042559968164E-09  -1.21543738430137E-18  -5.35772435129692E-02  -5.35772435222674E-02
      0.00000000000000E+00   0.00000000000000E+00   9.29813110530355E-09   0.00000000000000E+00   9.29813110530355E-09
      3.80085810237003E-18  -9.49468528907010E-02  -9.30792055889889E-02   0.00000000000000E+00  -1.26631880319211E-10
     -1.07495124016939E-22  -5.80107362530257E-09  -5.92770550562189E-09  -2.58542071806866E-18
      4.82006934908172E-09
      0.00000000000000E+00   2.55456952069015E-12   0.00000000000000E+00   4.46358795043681E-12  -4.76073322229813E-23
     -2.55901432647370E-09  -2.55455073852331E-09  -1.23605998354706E-18  -4.10332751188576E-02  -4.10332751267240E-02
      0.00000000000000E+00   0.00000000000000E+00   7.86635205662355E-09   0.00000000000000E+00   7.86635205662355E-09
      3.86617844617197E-18  -1.10065079712527E-01  -1.08391485419740E-01   0.00000000000000E+00  -1.27153940609671E-10
     -1.10822518950569E-22  -5.18464737749026E-09  -5.31180131810004E-09  -2.63011846262491E-18
      4.83127943267547E-09
      0.00000000000000E+00   1.64668429339375E-12   0.00000000000000E+00   3.74607760050648E-12  -4.78505997138143E-23
     -1.65035993104465E-09  -1.64661385344419E-09  -1.25371598399457E-18  -2.99914545090603E-02  -2.99914545152965E-02
      0.00000000000000E+00   0.00000000000000E+00   6.23615861534423E-09   0.00000000000000E+00   6.23615861534423E-09
      3.93608630555386E-18  -1.31795365724739E-01  -1.30349332924049E-01   0.00000000000000E+00  -1.25571368020324E-10
     -1.14953151403132E-22  -4.46397339387965E-09  -4.58954476190009E-09  -2.68237032155929E-18
      4.84641304552703E-09
      0.00000000000000E+00   8.99711045684932E-13   0.00000000000000E+00   2.30726634431145E-12  -4.80083251299908E-23
     -9.02050264866431E-10  -8.99742998522168E-10  -1.26626176368342E-18  -2.17839869344280E-02  -2.17839869392165E-02
      0.00000000000000E+00   0.00000000000000E+00   4.78853979665258E-09   0.00000000000000E+00   4.78853979665258E-09
      4.00855421296070E-18  -1.61755584854531E-01  -1.60530336456993E-01   0.00000000000000E+00  -1.24473233880149E-10
     -1.20035520131833E-22  -3.76432356425012E-09  -3.88879679813039E-09  -2.74229244927728E-18
      4.86641304552703E-09
      0.00000000000000E+00   4.57386791293483E-13   0.00000000000000E+00   1.03858254823081E-12  -4.80941612571427E-23
     -4.58357508642019E-10  -4.57318926093836E-10  -1.27402957011995E-18  -1.63085526653391E-02  -1.63085526690586E-02
      0.00000000000000E+00   0.00000000000000E+00   3.71944547265009E-09   0.00000000000000E+00   3.71944547265009E-09
      4.08294312241370E-18  -1.99481016060248E-01  -1.98453211947873E-01   0.00000000000000E+00  -1.24353794612643E-10
     -1.26131943292359E-22  -3.13777275194363E-09  -3.26212654655640E-09  -2.80891355229376E-18
      4.88641304552703E-09
      0.00000000000000E+00   2.67727408959940E-13   0.00000000000000E+00   4.46732172183880E-13  -4.81295385718630E-23
     -2.68150676845543E-10  -2.67703944673407E-10  -1.27803977795453E-18  -1.32455407146922E-02  -1.32455407176705E-02
      0.00000000000000E+00   0.00000000000000E+00   2.97830508345674E-09   0.00000000000000E+00   2.97830508345674E-09
      4.14250922408284E-18  -2.32955547840242E-01  -2.32101511053310E-01   0.00000000000000E+00  -1.21167021633424E-10
     -1.31547701438581E-22  -2.58943411714979E-09  -2.71060113878334E-09  -2.86446944612831E-18
      4.90641304552703E-09
      0.00000000000000E+00   1.89567537596335E-13   0.00000000000000E+00   1.84568084266773E-13  -4.81452965094416E-23
     -1.89737306076313E-10  -1.89552737992095E-10  -1.28051586305548E-18  -1.12869126847572E-02  -1.12869126871225E-02
      0.00000000000000E+00   0.00000000000000E+00   2.36532867415914E-09   0.00000000000000E+00   2.36532867415914E-09
      4.18981579756602E-18  -2.60543351926913E-01  -2.59857822586704E-01   0.00000000000000E+00  -1.09200237216797E-10
     -1.36077003440713E-22  -2.06657569895005E-09  -2.17577593616699E-09  -2.90929993451054E-18
      4.92641304552703E-09
      0.00000000000000E+00   1.53931779559815E-13   0.00000000000000E+00   8.50290216048567E-14  -4.81520300407323E-23
     -1.54055364105120E-10  -1.53970335083564E-10  -1.28230311355222E-18  -9.92340402144921E-03  -9.92340402327730E-03
      0.00000000000000E+00   0.00000000000000E+00   1.82808734465233E-09   0.00000000000000E+00   1.82808734465233E-09
      4.22637754445907E-18  -2.81769096092608E-01  -2.81241626462059E-01   0.00000000000000E+00  -8.99952493427476E-11
     -1.39606545039054E-22  -1.58412176022587E-09  -1.67411700956875E-09  -2.94407443090684E-18
      4.94641304552703E-09
      0.00000000000000E+00   1.35195453169479E-13   0.00000000000000E+00   4.61414787783977E-14  -4.81539180742470E-23
     -1.35284732739635E-10  -1.35238591260904E-10  -1.28373329486138E-18  -8.93376930152120E-03  -8.93376930289502E-03
      0.00000000000000E+00   0.00000000000000E+00   1.37381725073055E-09   0.00000000000000E+00   1.37381725073055E-09
      4.25385388947368E-18  -2.97089242057812E-01  -2.96699000777872E-01   0.00000000000000E+00  -6.77584016502830E-11
     -1.42163528957311E-22  -1.17082025781917E-09  -1.23857865946960E-09  -2.97012059461230E-18
      4.96641304552703E-09
      0.00000000000000E+00   1.25184376813859E-13   0.00000000000000E+00   2.60617206492046E-14  -4.81534076781340E-23
     -1.25183170247369E-10  -1.25157108526768E-10  -1.28497504569670E-18  -8.19177088320878E-03  -8.19177088420496E-03
      0.00000000000000E+00   0.00000000000000E+00   9.96175465803222E-10   0.00000000000000E+00   9.96175465803222E-10
      4.27377739878975E-18  -3.07215767298996E-01  -3.06941337046871E-01   0.00000000000000E+00  -4.53069306574660E-11
     -1.43836068687807E-22  -8.25711426618903E-10  -8.71018357276513E-10  -2.98880235309304E-18
      4.98641304552703E-09
      0.00000000000000E+00   1.17285729414012E-13   0.00000000000000E+00   2.15756747512494E-14  -4.81508041091842E-23
     -1.17282524638892E-10  -1.17260948964188E-10  -1.28606884310947E-18  -7.64025215458842E-03  -7.64025215529416E-03
      0.00000000000000E+00   0.00000000000000E+00   7.05747612012985E-10   0.00000000000000E+00   7.05747612012985E-10
      4.28789235103000E-18  -3.13295572330106E-01  -3.13110162753023E-01   0.00000000000000E+00  -2.62871962294093E-11
     -1.44801247930519E-22  -5.62199466819231E-10  -5.88486663048785E-10  -3.00182350792053E-18
      5.00641304552703E-09
      0.00000000000000E+00   1.02406881986392E-13   0.00000000000000E+00   4.10057882735146E-14  -4.81430271151646E-23
     -1.02396111934634E-10  -1.02355106146408E-10  -1.28687361353508E-18  -7.29593194884670E-03  -7.29593194942386E-03
      0.00000000000000E+00   0.00000000000000E+00   5.77159068186549E-10   0.00000000000000E+00   5.77159068186549E-10
      4.29943553239373E-18  -3.17918011825142E-01  -3.17768421570165E-01   0.00000000000000E+00  -1.88598493946970E-11
     -1.45487375909176E-22  -4.55944112645216E-10  -4.74803962040058E-10  -3.01256191885865E-18
      5.02641304552703E-09
      0.00000000000000E+00   9.09262898354515E-14   0.00000000000000E+00   3.40354804659668E-14  -4.81320181496471E-23
     -9.09785854799670E-11  -9.09445499995492E-11  -1.28745970420446E-18  -7.06799173406020E-03  -7.06799173463362E-03
      0.00000000000000E+00   0.00000000000000E+00   5.73422647884150E-10   0.00000000000000E+00   5.73422647884150E-10
      4.31090398535141E-18  -3.22832055365790E-01  -3.22680046942490E-01   0.00000000000000E+00  -2.02011863359242E-11
     -1.46205615981129E-22  -4.62276911548565E-10  -4.82478097884636E-10  -3.02344428114696E-18
      5.03141304552703E-09
      0.00000000000000E+00   9.28550293168095E-14   0.00000000000000E+00  -1.31260984578935E-14  -4.81297796492153E-23
     -9.28619613690759E-11  -9.28750874675819E-11  -1.28761644513830E-18  -7.00733164693712E-03  -7.00733164747979E-03
      0.00000000000000E+00   0.00000000000000E+00   5.42671576549829E-10   0.00000000000000E+00   5.42671576549829E-10
      4.31361734323417E-18  -3.23921834315445E-01  -3.23780123422047E-01   0.00000000000000E+00  -1.75741372229306E-11
     -1.46362136088988E-22  -4.32222351859186E-10  -4.49796489082263E-10  -3.02600089809586E-18
      5.03816304552703E-09
      0.00000000000000E+00   8.54156056029999E-14   0.00000000000000E+00   6.02144792409396E-14  -4.81252857002165E-23
     -8.55187456310453E-11  -8.54585311518525E-11  -1.28777908220623E-18  -6.95019650314871E-03  -6.95019650371141E-03
      0.00000000000000E+00   0.00000000000000E+00   5.62706733727401E-10   0.00000000000000E+00   5.62706733727401E-10
      4.31741561368682E-18  -3.25585699318317E-01  -3.25435338590758E-01   0.00000000000000E+00  -2.03437076892284E-11
     -1.46602180664919E-22  -4.56904494886172E-10  -4.77248202575547E-10  -3.02963653148059E-18
      5.04727554552703E-09
      0.00000000000000E+00   8.20173503263214E-14   0.00000000000000E+00   2.60023172713872E-14  -4.81192274789654E-23
     -8.20076107681858E-11  -8.19816084509625E-11  -1.28796908477114E-18  -6.88038057917713E-03  -6.88038057977919E-03
      0.00000000000000E+00   0.00000000000000E+00   6.02055684323817E-10   0.00000000000000E+00   6.02055684323817E-10
      4.32290184611022E-18  -3.28145602196980E-01  -3.27981747664688E-01   0.00000000000000E+00  -2.39008904553673E-11
     -1.46979413567305E-22  -4.96173185417301E-10  -5.20074075872816E-10  -3.03493276133908E-18
      5.05957742052703E-09
      0.00000000000000E+00   7.60474424078321E-14   0.00000000000000E+00   3.17044178966631E-14  -4.81099001389633E-23
     -7.60369889679934E-11  -7.60052845501449E-11  -1.28815636355013E-18  -6.80414900680873E-03  -6.80414900748383E-03
      0.00000000000000E+00   0.00000000000000E+00   6.75103560681621E-10   0.00000000000000E+00   6.75103560681621E-10
      4.33120688572579E-18  -3.32384136041040E-01  -3.32195382156591E-01   0.00000000000000E+00  -3.05082385011718E-11
     -1.47621046648426E-22  -5.68590037629992E-10  -5.99098276131311E-10  -3.04305052217565E-18
      5.06372930333953E-09
      0.00000000000000E+00   7.08122923870031E-14   0.00000000000000E+00   7.02568011954821E-14  -4.81061860259646E-23
     -7.08436716866500E-11  -7.07734148855026E-11  -1.28819836423228E-18  -6.78773574886067E-03  -6.78773574956664E-03
      0.00000000000000E+00   0.00000000000000E+00   7.05973398582387E-10   0.00000000000000E+00   7.05973398582387E-10
      4.33413800454544E-18  -3.33944846911102E-01  -3.33744717767262E-01   0.00000000000000E+00  -3.37846505908827E-11
     -1.47858791247643E-22  -6.01415333106013E-10  -6.35199983697044E-10  -3.04593964031316E-18
      5.06933434513641E-09
      0.00000000000000E+00   6.08012160313827E-14   0.00000000000000E+00   9.76060798871153E-14  -4.81000593652994E-23
     -6.09087519763626E-11  -6.08111458965236E-11  -1.28820028410846E-18  -6.78669865412851E-03  -6.78669865491986E-03
      0.00000000000000E+00   0.00000000000000E+00   7.91351960490697E-10   0.00000000000000E+00   7.91351960490697E-10
      4.33857356536003E-18  -3.36503955531471E-01  -3.36273785713694E-01   0.00000000000000E+00  -4.20610888507252E-11
     -1.48254720235674E-22  -6.88479725743439E-10  -7.30540814594313E-10  -3.05037328125158E-18
      5.07690115156219E-09
      0.00000000000000E+00   5.39128607408182E-14   0.00000000000000E+00   5.63922555056867E-14  -4.80913907548962E-23
     -5.39821956471898E-11  -5.39258033917322E-11  -1.28815296920124E-18  -6.79194646146213E-03  -6.79194646238556E-03
      0.00000000000000E+00   0.00000000000000E+00   9.23435058997108E-10   0.00000000000000E+00   9.23435058997108E-10
      4.34556101969824E-18  -3.40789877256347E-01  -3.40515920472432E-01   0.00000000000000E+00  -5.38382114337200E-11
     -1.48933830430211E-22  -8.15671044171527E-10  -8.69509255605396E-10  -3.05740805049700E-18
      5.08711634023699E-09
      0.00000000000000E+00   5.15248975734225E-14   0.00000000000000E+00   2.29769845013535E-14  -4.80798911479841E-23
     -5.15840462769305E-11  -5.15610692924772E-11  -1.28806940495038E-18  -6.77665704797773E-03  -6.77665704905049E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07275829771945E-09   0.00000000000000E+00   1.07275829771945E-09
      4.35651944811191E-18  -3.47762103966916E-01  -3.47440352564341E-01   0.00000000000000E+00  -6.71368277484282E-11
     -1.50065744147594E-22  -9.54060400678278E-10  -1.02119722842686E-09  -3.06845004316153E-18
      5.10090684494798E-09
      0.00000000000000E+00   5.50149975873085E-14   0.00000000000000E+00  -1.73865091103150E-15  -4.80659951033870E-23
     -5.49850058406344E-11  -5.49867444915935E-11  -1.28801246294987E-18  -6.68839811022582E-03  -6.68839811141032E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18450472405199E-09   0.00000000000000E+00   1.18450472405199E-09
      4.37285436608913E-18  -3.58280212890400E-01  -3.57924331291428E-01   0.00000000000000E+00  -7.78890649537525E-11
     -1.51812485153033E-22  -1.05162891460662E-09  -1.12951797956052E-09  -3.08484190313926E-18
      5.11952402630781E-09
      0.00000000000000E+00   6.38320923592311E-14   0.00000000000000E+00  -1.49020438454030E-14  -4.80510314067368E-23
     -6.37843640330134E-11  -6.37992660769069E-11  -1.28811524528251E-18  -6.44447157918265E-03  -6.44447158040747E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22481741137299E-09   0.00000000000000E+00   1.22481741137299E-09
      4.39565701396935E-18  -3.72859070172103E-01  -3.72493263388669E-01   0.00000000000000E+00  -8.35914245680283E-11
     -1.54290416127458E-22  -1.07742672072787E-09  -1.16101814529605E-09  -3.10754176868684E-18
      5.13952402630781E-09
      0.00000000000000E+00   7.88946292612655E-14   0.00000000000000E+00  -3.19197580175015E-14  -4.80412837610919E-23
     -7.88849477950814E-11  -7.89168675531470E-11  -1.28854487607814E-18  -5.99610496368955E-03  -5.99610496490753E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21798464844841E-09   0.00000000000000E+00   1.21798464844841E-09
      4.42001670693831E-18  -3.88075808952003E-01  -3.87716918168501E-01   0.00000000000000E+00  -8.55617222019748E-11
     -1.56949018149489E-22  -1.05350605869311E-09  -1.13906778089525E-09  -3.13147183086017E-18
      5.15952402630781E-09
      0.00000000000000E+00   9.68961977539407E-14   0.00000000000000E+00  -4.22966305969740E-14  -4.80385496381449E-23
     -9.67699410049838E-11  -9.68122376356288E-11  -1.28934777167299E-18  -5.33717472043811E-03  -5.33717472163690E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19878638531108E-09   0.00000000000000E+00   1.19878638531108E-09
      4.44399243464454E-18  -4.02589651831079E-01  -4.02242448407214E-01   0.00000000000000E+00  -8.61401386646382E-11
     -1.59562338496100E-22  -1.01583400901062E-09  -1.10197414767541E-09  -3.15464466297154E-18
      5.17952402630781E-09
      0.00000000000000E+00   1.06539895160731E-13   0.00000000000000E+00  -2.42979704238446E-14  -4.80391800393622E-23
     -1.06533933578124E-10  -1.06558231548596E-10  -1.29035976845347E-18  -4.56794359893153E-03  -4.56794360009882E-03
      0.00000000000000E+00   0.00000000000000E+00   1.16728721734753E-09   0.00000000000000E+00   1.16728721734753E-09
      4.46733817899149E-18  -4.16420388890015E-01  -4.16086180987491E-01   0.00000000000000E+00  -8.59534740430408E-11
     -1.62112777625876E-22  -9.74775511755838E-10  -1.06072898579904E-09  -3.17697841053801E-18
      5.19952402630781E-09
      0.00000000000000E+00   1.01947658300355E-13   0.00000000000000E+00   1.16327315301127E-14  -4.80376960954585E-23
     -1.01944740991063E-10  -1.01933108259580E-10  -1.29129298009662E-18  -3.86056859990228E-03  -3.86056860102016E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11788341787397E-09   0.00000000000000E+00   1.11788341787397E-09
      4.48969584734896E-18  -4.29662911643487E-01  -4.29342812724190E-01   0.00000000000000E+00  -8.49510075070007E-11
     -1.64582198754414E-22  -9.30999302107104E-10  -1.01595030961427E-09  -3.19840286725234E-18
      5.21952402630781E-09
      0.00000000000000E+00   8.04559897937934E-14   0.00000000000000E+00   5.66190206740261E-14  -4.80280606427529E-23
     -8.05344134956705E-11  -8.04777944750445E-11  -1.29181123278100E-18  -3.41538805012649E-03  -3.41538805117312E-03
      0.00000000000000E+00   0.00000000000000E+00   1.04662475910759E-09   0.00000000000000E+00   1.04662475910759E-09
      4.51062834253112E-18  -4.42413511799260E-01  -4.42109105200101E-01   0.00000000000000E+00  -8.28777062249294E-11
     -1.66945858685616E-22  -8.83269258407450E-10  -9.66146964632546E-10  -3.21881710975012E-18
      5.23952402630781E-09
      0.00000000000000E+00  -7.59555976706246E-14   0.00000000000000E+00   4.15604561166918E-13  -4.79555778242425E-23
      7.55685190095245E-11   7.59841235706435E-11  -1.28922200133485E-18  -4.85325972248367E-03  -4.85325972324660E-03
      0.00000000000000E+00   0.00000000000000E+00   7.62931636750399E-10   0.00000000000000E+00   7.62931636750399E-10
      4.52588697526612E-18  -4.54919456237995E-01  -4.54655139293173E-01   0.00000000000000E+00  -7.07537463301579E-11
     -1.68927513698575E-22  -7.68162013990797E-10  -8.38915760321124E-10  -3.23666497393128E-18
      5.25952402630781E-09
      0.00000000000000E+00  -8.13193303235442E-13   0.00000000000000E+00   1.96685420392398E-12  -4.75900147764533E-23
      8.11239445687159E-10   8.13206299891036E-10  -1.27196230884588E-18  -1.50589892916076E-02  -1.50589892911616E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.46067866537993E-10   0.00000000000000E+00  -4.46067866537993E-10
      4.51696561793536E-18  -4.67988084388251E-01  -4.67872423085110E-01   0.00000000000000E+00  -1.43813787788210E-11
     -1.69305320347752E-22  -3.52757054574066E-10  -3.67138433353056E-10  -3.24500330908949E-18
      5.27952402630781E-09
      0.00000000000000E+00  -1.66762489347706E-12   0.00000000000000E+00   2.37704508797339E-12  -4.69281295273657E-23
      1.66521203896570E-09   1.66758908405362E-09  -1.23783844865549E-18  -3.49325433242113E-02  -3.49325433223888E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.82246268283346E-09   0.00000000000000E+00  -1.82246268283346E-09
      4.48051636427869E-18  -4.81614563917593E-01  -4.81663387943162E-01   0.00000000000000E+00   4.89757810286197E-11
     -1.67891625076557E-22   1.05897817751399E-10   1.54873598779850E-10  -3.24267791562321E-18
      5.28952402630781E-09
      0.00000000000000E+00  -2.10866332154761E-12   0.00000000000000E+00   2.48449011340163E-12  -4.65250303380153E-23
      2.10617858006289E-09   2.10866307017625E-09  -1.21648046224905E-18  -4.71316081921000E-02  -4.71316081895870E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.51301964185703E-09   0.00000000000000E+00  -2.51301964185703E-09
      4.45538616786012E-18  -4.88485448578213E-01  -4.88612884540576E-01   0.00000000000000E+00   7.80529412205050E-11
     -1.66767442736614E-22   3.26303630460439E-10   4.04356571680778E-10  -3.23890570561107E-18
      5.30302402630781E-09
      0.00000000000000E+00  -2.51342307842118E-12   0.00000000000000E+00   1.81270522473971E-12  -4.59134591271083E-23
      2.51159344944175E-09   2.51340615466644E-09  -1.18257762912973E-18  -6.60855648711789E-02  -6.60855648680661E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.11275600537569E-09   0.00000000000000E+00  -3.11275600537569E-09
      4.41336396178755E-18  -4.97768481588695E-01  -4.97957361030713E-01   0.00000000000000E+00   1.00392527835072E-10
     -1.64804054420483E-22   4.98957322874354E-10   5.99349850709261E-10  -3.23078633265783E-18
      5.32124902630781E-09
      0.00000000000000E+00  -3.09865774390754E-12   0.00000000000000E+00   1.92608988276055E-12  -4.49585967594425E-23
      3.09674346770680E-09   3.09866955758951E-09  -1.12791671329706E-18  -9.56599402002440E-02  -9.56599401963644E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.87954921470483E-09   0.00000000000000E+00  -3.87954921470483E-09
      4.34265917734956E-18  -5.10165913054279E-01  -5.10412000147422E-01   0.00000000000000E+00   1.24682202710965E-10
     -1.61479772401855E-22   6.56197454404535E-10   7.80879657115339E-10  -3.21474246405250E-18
      5.32624902630781E-09
      0.00000000000000E+00  -3.44169783737765E-12   0.00000000000000E+00   3.70209865487826E-12  -4.46631437995940E-23
      3.43803473679571E-09   3.44173683545054E-09  -1.11145431106432E-18  -1.04357626676478E-01  -1.04357626672159E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.31892090282565E-09   0.00000000000000E+00  -4.31892090282565E-09
      4.32106457283543E-18  -5.13555607264903E-01  -5.13832041969938E-01   0.00000000000000E+00   1.35052468266482E-10
     -1.60484027028170E-22   7.42131599108673E-10   8.77184067374995E-10  -3.20961026177111E-18
      5.33299902630781E-09
      0.00000000000000E+00  -3.81706727834481E-12   0.00000000000000E+00   3.08833009000386E-12  -4.42290641681870E-23
      3.81398804157693E-09   3.81707637166689E-09  -1.08735680965879E-18  -1.16899910032312E-01  -1.16899910027558E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.75391772741875E-09   0.00000000000000E+00  -4.75391772741875E-09
      4.28897562817535E-18  -5.18108997325246E-01  -5.18404238155570E-01   0.00000000000000E+00   1.46678607864492E-10
     -1.59014025007395E-22   7.90162747887657E-10   9.36841355751990E-10  -3.20161881851656E-18
      5.34211152630781E-09
      0.00000000000000E+00  -4.30044613026803E-12   0.00000000000000E+00   2.95175046114886E-12  -4.35110758242805E-23
      4.29748226740353E-09   4.30043401786463E-09  -1.05240994827342E-18  -1.34713977379541E-01  -1.34713977374362E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.17915103747813E-09   0.00000000000000E+00  -5.17915103747813E-09
      4.24178061434633E-18  -5.24079072289029E-01  -5.24356018061314E-01   0.00000000000000E+00   1.55296460838350E-10
     -1.56890451529942E-22   7.23420558775378E-10   8.78717019613570E-10  -3.18937066607291E-18
      5.35441340130781E-09
      0.00000000000000E+00  -5.04236791743043E-12   0.00000000000000E+00   3.28184226731450E-12  -4.18672398221313E-23
      5.03905465284067E-09   5.04233649510794E-09  -1.00299573534391E-18  -1.59184516344735E-01  -1.59184516339223E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.51241728616325E-09   0.00000000000000E+00  -5.51241728616325E-09
      4.17396754594411E-18  -5.31429465636862E-01  -5.31577703334082E-01   0.00000000000000E+00   1.57698946399837E-10
     -1.53926452712882E-22   3.12381844655611E-10   4.70080791055294E-10  -3.17097181060020E-18
      5.37102093255781E-09
      0.00000000000000E+00  -6.70163493982160E-12   0.00000000000000E+00   5.18273380441360E-12  -3.58364282276132E-23
      6.69647572265135E-09   6.70165845645572E-09  -9.36029387078613E-19  -1.91110394664107E-01  -1.91110394658380E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.72710046917512E-09   0.00000000000000E+00  -5.72710046917512E-09
      4.07885454593040E-18  -5.38713872022264E-01  -5.38407057536428E-01   0.00000000000000E+00   1.55314420226363E-10
     -1.49848886976144E-22  -1.12987240750691E-09  -9.74557987280694E-10  -3.14282515885179E-18
      5.39102093255781E-09
      0.00000000000000E+00  -1.07862459376519E-11   0.00000000000000E+00   1.02596633324333E-11  -1.40587002327821E-23
      1.07759813351046E-08   1.07862409984371E-08  -8.60189975246952E-19  -2.25759771234103E-01  -2.25759771228190E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.91234381140199E-09   0.00000000000000E+00  -5.91234381140199E-09
      3.96060766970236E-18  -5.39749765383947E-01  -5.38214640802925E-01   0.00000000000000E+00   1.56547156474116E-10
     -1.44549457345226E-22  -5.03044434350906E-09  -4.87389718703509E-09  -3.10041769445541E-18
      5.41102093255782E-09
      0.00000000000000E+00  -1.78206343603764E-11   0.00000000000000E+00   1.74794326334689E-11   3.05660666890597E-23
      1.78031609062101E-08   1.78206403388436E-08  -7.94528805041250E-19  -2.54785482859166E-01  -2.54785482853011E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.15592347652968E-09   0.00000000000000E+00  -6.15592347652968E-09
      3.83748920017176E-18  -5.27650018261198E-01  -5.23975662171411E-01   0.00000000000000E+00   1.64808831966365E-10
     -1.38287844045864E-22  -1.18295256942801E-08  -1.16647168623138E-08  -3.04296039513051E-18
      5.43102093255782E-09
      0.00000000000000E+00  -2.65348630266266E-11   0.00000000000000E+00   2.16059514301187E-11   8.58539449378643E-23
      2.65132558935473E-08   2.65348618449775E-08  -7.42726318959132E-19  -2.77450985987368E-01  -2.77450985980926E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.44163523859168E-09   0.00000000000000E+00  -6.44163523859168E-09
      3.70865649539993E-18  -4.98571631319986E-01  -4.92241985678327E-01   0.00000000000000E+00   1.74465981742762E-10
     -1.30549927633817E-22  -2.02676925881285E-08  -2.00932266063859E-08  -2.96593017644080E-18
      5.45102093255782E-09
      0.00000000000000E+00  -3.41742327333370E-11   0.00000000000000E+00   1.89552688448989E-11   1.34826783001816E-22
      3.41553597744086E-08   3.41743150432537E-08  -7.05496438860496E-19  -2.94063676114386E-01  -2.94063676107658E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.72728624423462E-09   0.00000000000000E+00  -6.72728624423462E-09
      3.57411077051524E-18  -4.51831727748797E-01  -4.43185175131745E-01   0.00000000000000E+00   1.75637567197148E-10
     -1.21370795103416E-22  -2.76226663662161E-08  -2.74470287990190E-08  -2.86861433165474E-18
      5.47102093255782E-09
      0.00000000000000E+00  -3.82218303020727E-11   0.00000000000000E+00   1.00726813024934E-11   1.62506108353590E-22
      3.82118307405252E-08   3.82219034218279E-08  -6.81887856064598E-19  -3.05316365788244E-01  -3.05316365781247E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.99710556798059E-09   0.00000000000000E+00  -6.99710556798059E-09
      3.43416865915563E-18  -3.88929303751264E-01  -3.79092321085644E-01   0.00000000000000E+00   1.65781454812758E-10
     -1.11468616552265E-22  -3.13905793086600E-08  -3.12247978538473E-08  -2.75228080309103E-18
      5.49102093255782E-09
      0.00000000000000E+00  -3.77637087528816E-11   0.00000000000000E+00  -1.09139875398082E-12   1.63419307784231E-22
      3.77647824933040E-08   3.77636910945502E-08  -6.69862224663866E-19  -3.12145009623856E-01  -3.12145009616619E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23716716949411E-09   0.00000000000000E+00  -7.23716716949411E-09
      3.28942531576574E-18  -3.14091839163580E-01  -3.04474581956065E-01   0.00000000000000E+00   1.44548551501444E-10
     -1.01648789818156E-22  -3.06710724765574E-08  -3.05265239250560E-08  -2.61956309110188E-18
      5.51102093255782E-09
      0.00000000000000E+00  -3.49689652443937E-11   0.00000000000000E+00  -6.89520978990918E-12   1.47700041597887E-22
      3.49758909562498E-08   3.49689957464600E-08  -6.63556657019714E-19  -3.16857501944208E-01  -3.16857501936861E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34659468549157E-09   0.00000000000000E+00  -7.34659468549157E-09
      3.14249342205591E-18  -2.38569730522287E-01  -2.29867221295981E-01   0.00000000000000E+00   1.07810278454058E-10
     -9.14232111367899E-23  -2.77302113394225E-08  -2.76224010609685E-08  -2.47893676503620E-18
      5.53102093255782E-09
      0.00000000000000E+00  -3.23893221104459E-11   0.00000000000000E+00  -6.37578138182223E-12   1.29118900925461E-22
      3.23956357704779E-08   3.23892599890962E-08  -6.57192220534817E-19  -3.21654467194266E-01  -3.21654467186959E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30698634544314E-09   0.00000000000000E+00  -7.30698634544314E-09
      2.99635369514705E-18  -1.71124914443703E-01  -1.63222554107663E-01   0.00000000000000E+00   7.09132448152968E-11
     -8.31061083790387E-23  -2.51531868884683E-08  -2.50822736436531E-08  -2.33916147461223E-18
      5.54102093255782E-09
      0.00000000000000E+00  -3.10532567182880E-11   0.00000000000000E+00  -6.59995095174166E-12   1.19224782594018E-22
      3.10598428010353E-08   3.10532428500837E-08  -6.54155370235910E-19  -3.24009628555013E-01  -3.24009628547721E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29165217116160E-09   0.00000000000000E+00  -7.29165217116160E-09
      2.92343717343543E-18  -1.39691183334031E-01  -1.32204867407475E-01   0.00000000000000E+00   5.40407913812665E-11
     -8.03707940085958E-23  -2.38156314703032E-08  -2.37615906789220E-08  -2.26928180319953E-18
      5.55452093255782E-09
      0.00000000000000E+00  -2.97308761919741E-11   0.00000000000000E+00  -4.84008233671409E-12   1.08259302527339E-22
      2.97357436724025E-08   2.97309035900659E-08  -6.48667395692027E-19  -3.27731032137570E-01  -3.27731032130362E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.20752486460054E-09   0.00000000000000E+00  -7.20752486460054E-09
      2.82613558776333E-18  -1.01787510036336E-01  -9.46912599583483E-02   0.00000000000000E+00   4.12379647347472E-11
     -7.55794073830103E-23  -2.25646166902000E-08  -2.25233787254653E-08  -2.17746819207130E-18
      5.57274593255782E-09
      0.00000000000000E+00  -2.77589696841285E-11   0.00000000000000E+00  -5.33133738506366E-12   9.90772778529687E-23
      2.77643002505468E-08   2.77589689131619E-08  -6.36890188457958E-19  -3.34309385368821E-01  -3.34309385361786E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.03611817163485E-09   0.00000000000000E+00  -7.03611817163485E-09
      2.69790233408528E-18  -6.06920010390924E-02  -5.41629875337219E-02   0.00000000000000E+00   3.02100159318325E-11
     -5.10014484316921E-23  -2.07530607574588E-08  -2.07228507415270E-08  -2.06101214562732E-18
      5.57774593255782E-09
      0.00000000000000E+00  -2.66384638901966E-11   0.00000000000000E+00  -1.10003583454417E-11   9.70267444883205E-23
      2.66494923320474E-08   2.66384919737021E-08  -6.32863209552640E-19  -3.36359840133316E-01  -3.36359840126356E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.96045647093406E-09   0.00000000000000E+00  -6.96045647093406E-09
      2.66310005173061E-18  -5.09673529065819E-02  -4.47675136608752E-02   0.00000000000000E+00   2.97279327031423E-11
     -3.61462844744391E-23  -1.97077634354713E-08  -1.96780355027682E-08  -2.03023684217797E-18
      5.58449593255782E-09
      0.00000000000000E+00  -2.52549147689025E-11   0.00000000000000E+00  -1.01079433810096E-11   9.69469764169651E-23
      2.52650580123345E-08   2.52549500689536E-08  -6.25260115368079E-19  -3.39883854010624E-01  -3.39883854003833E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.79037404754494E-09   0.00000000000000E+00  -6.79037404754494E-09
      2.61726502690968E-18  -4.07178351917268E-02  -3.49003033399683E-02   0.00000000000000E+00   2.45416693075611E-11
     -1.06218437527677E-23  -1.84891176907165E-08  -1.84645760214089E-08  -1.99200491154161E-18
      5.59360843255782E-09
      0.00000000000000E+00  -2.36728891705028E-11   0.00000000000000E+00  -8.54992899031435E-12   1.01260445398093E-22
      2.36814196468885E-08   2.36728697178983E-08  -6.11688511528862E-19  -3.45777337456059E-01  -3.45777337449489E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.56994190259177E-09   0.00000000000000E+00  -6.56994190259177E-09
      2.55739643132232E-18  -3.12108951098558E-02  -2.58223604912069E-02   0.00000000000000E+00   1.92536272708930E-11
      2.73524836265993E-23  -1.71221814425775E-08  -1.71029278153066E-08  -1.94570791979346E-18
      5.60591030755782E-09
      0.00000000000000E+00  -2.21840859803688E-11   0.00000000000000E+00  -5.94640368894532E-12   1.11746531022123E-22
      2.21899796398878E-08   2.21840332361989E-08  -5.89811865057247E-19  -3.54929520121190E-01  -3.54929520114842E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.34772916073287E-09   0.00000000000000E+00  -6.34772916073287E-09
      2.47930746065313E-18  -2.35516080105662E-02  -1.85621330432618E-02   0.00000000000000E+00   1.37640861758349E-11
      7.43593578785699E-23  -1.58500681616418E-08  -1.58363040754659E-08  -1.88949559559588E-18
      5.62251783880782E-09
      0.00000000000000E+00  -2.10046158651497E-11   0.00000000000000E+00  -3.47182689774041E-12   1.27094833992587E-22
      2.10080719461775E-08   2.10046001192799E-08  -5.58175757907921E-19  -3.67936860589799E-01  -3.67936860583638E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16127286174124E-09   0.00000000000000E+00  -6.16127286174124E-09
      2.37698392906198E-18  -1.79556370583669E-02  -1.32790067064741E-02   0.00000000000000E+00   9.32374568293603E-12
      1.26252084563960E-22  -1.48526510032218E-08  -1.48433272575388E-08  -1.81880817115406E-18
      5.64251783880782E-09
      0.00000000000000E+00  -2.01092215221136E-11   0.00000000000000E+00  -2.17449062215473E-12   1.39616405189792E-22
      2.01113901720549E-08   2.01092156814329E-08  -5.20531897990443E-19  -3.83351945227167E-01  -3.83351945221149E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.01719200870382E-09   0.00000000000000E+00  -6.01719200870382E-09
      2.25664008888791E-18  -1.42484784732674E-02  -9.80855186882867E-03   0.00000000000000E+00   6.71602061012767E-12
      1.69145415451170E-22  -1.40987396933395E-08  -1.40920236727292E-08  -1.73610819089746E-18
      5.66251783880782E-09
      0.00000000000000E+00  -1.93787803271021E-11   0.00000000000000E+00  -1.76940533246029E-12   1.42119380381328E-22
      1.93805451551262E-08   1.93787757497939E-08  -4.84653833584078E-19  -3.98096516204393E-01  -3.98096516198489E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.90460921029905E-09   0.00000000000000E+00  -5.90460921029905E-09
      2.13854790468192E-18  -1.19586002640027E-02  -7.71333512958423E-03   0.00000000000000E+00   5.44425507750699E-12
      1.89641315345425E-22  -1.34796107945725E-08  -1.34741665394949E-08  -1.65389407109785E-18
      5.68251783880782E-09
      0.00000000000000E+00  -1.87284277429356E-11   0.00000000000000E+00  -1.57514268911619E-12   1.34495450528208E-22
      1.87299634776873E-08   1.87283883349983E-08  -4.50728562935755E-19  -4.12135881275016E-01  -4.12135881269212E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.80437835002696E-09   0.00000000000000E+00  -5.80437835002696E-09
      2.02246033768138E-18  -1.04002415091848E-02  -6.32830893409320E-03   0.00000000000000E+00   4.66433800044149E-12
      1.89055656283352E-22  -1.29286743229720E-08  -1.29240099849714E-08  -1.57173177474563E-18
      5.70251783880782E-09
      0.00000000000000E+00  -1.81622967827884E-11   0.00000000000000E+00  -1.37028799870196E-12   1.18910260362957E-22
      1.81636503275474E-08   1.81622800395488E-08  -4.18532624921461E-19  -4.25554494734787E-01  -4.25554494729073E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.71394954812968E-09   0.00000000000000E+00  -5.71394954812968E-09
      1.90818134671879E-18  -9.28380556744047E-03  -5.36174109324233E-03   0.00000000000000E+00   4.04991392332582E-12
      1.71822887067174E-22  -1.24523804053425E-08  -1.24483304914190E-08  -1.48964872179733E-18
      5.72251783880782E-09
      0.00000000000000E+00  -1.76828672545651E-11   0.00000000000000E+00  -1.15881566995580E-12   9.85290037192568E-23
      1.76840458021131E-08   1.76828869864433E-08  -3.87772079673753E-19  -4.38449437061576E-01  -4.38449437055944E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.63214973322867E-09   0.00000000000000E+00  -5.63214973322867E-09
      1.79553835205422E-18  -8.45691418761210E-03  -4.66011594084251E-03   0.00000000000000E+00   3.53713203593901E-12
      1.43985965138925E-22  -1.20542743852508E-08  -1.20507372532147E-08  -1.40776627238047E-18
      5.74251783880782E-09
      0.00000000000000E+00  -1.73127329636188E-11   0.00000000000000E+00  -8.91313710903267E-13   7.66892965608766E-23
      1.73136269551656E-08   1.73127356414548E-08  -3.58042142592275E-19  -4.50969618804055E-01  -4.50969618798469E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58662947903142E-09   0.00000000000000E+00  -5.58662947903142E-09
      1.68380576247359E-18  -7.83153987644363E-03  -4.13702026388665E-03   0.00000000000000E+00   3.11852973289618E-12
      1.11787023040634E-22  -1.17292246921562E-08  -1.17261061624232E-08  -1.32576361988131E-18
      5.76251783880782E-09
      0.00000000000000E+00  -1.73413885216275E-11   0.00000000000000E+00   9.04416997523140E-14   5.63933873088856E-23
      1.73412873232749E-08   1.73413777649747E-08  -3.27763336637020E-19  -4.63784283833104E-01  -4.63784283827295E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.80954940545641E-09   0.00000000000000E+00  -5.80954940545641E-09
      1.56761477436446E-18  -7.40761437391393E-03  -3.77430352754088E-03   0.00000000000000E+00   2.69699442779791E-12
      8.06208491040402E-23  -1.15345253539462E-08  -1.15318283595183E-08  -1.23985143772744E-18
      5.78251783880782E-09
      0.00000000000000E+00  -1.77313612758107E-11   0.00000000000000E+00   9.82404644563698E-13   3.92317953048859E-23
      1.77303893972999E-08   1.77313718019445E-08  -2.96075693058286E-19  -4.77290087433709E-01  -4.77290087427473E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.23528751391782E-09   0.00000000000000E+00  -6.23528751391782E-09
      1.44290902408610E-18  -7.15037281959404E-03  -3.52832192017029E-03   0.00000000000000E+00   2.27576714773744E-12
      5.36818201373297E-23  -1.14983600551744E-08  -1.14960842880266E-08  -1.14683333102782E-18
      5.79251783880782E-09
      0.00000000000000E+00  -1.79318583371347E-11   0.00000000000000E+00   1.01137569837467E-12   3.12815861579353E-23
      1.79309273838265E-08   1.79319387595249E-08  -2.80125246941896E-19  -4.84142835319437E-01  -4.84142835312987E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.44932610811128E-09   0.00000000000000E+00  -6.44932610811128E-09
      1.37841576300499E-18  -7.04134290267013E-03  -3.42353560352281E-03   0.00000000000000E+00   2.18259171925021E-12
      4.10685439870624E-23  -1.14847952431329E-08  -1.14826126514136E-08  -1.09829051606310E-18
      5.80601783880782E-09
      0.00000000000000E+00  -1.81027813930779E-11   0.00000000000000E+00   6.46823820320957E-13   2.28657809870739E-23
      1.81021058537213E-08   1.81027526775417E-08  -2.58597359792356E-19  -4.93442861540882E-01  -4.93442861534303E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.57994082101381E-09   0.00000000000000E+00  -6.57994082101381E-09
      1.28958656192131E-18  -6.92175929325258E-03  -3.29128528182512E-03   0.00000000000000E+00   1.90791940576035E-12
      2.78440942797266E-23  -1.15247197759338E-08  -1.15228118565280E-08  -1.03098920212895E-18
      5.82424283880782E-09
      0.00000000000000E+00  -1.82592848252796E-11   0.00000000000000E+00   4.44298709123098E-13   1.50552667060491E-23
      1.82588157699618E-08   1.82592600686709E-08  -2.30071255121015E-19  -5.05891337015139E-01  -5.05891337008483E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.65572539958684E-09   0.00000000000000E+00  -6.65572539958684E-09
      1.16828596651384E-18  -6.79078998953498E-03  -3.13488125874480E-03   0.00000000000000E+00   1.72450933844950E-12
      1.56837520720490E-23  -1.16052591784226E-08  -1.16035346690841E-08  -9.38214711392820E-19
      5.82924283880782E-09
      0.00000000000000E+00  -1.83625183099008E-11   0.00000000000000E+00   1.03300236995041E-12   1.30775883724835E-23
      1.83615093013442E-08   1.83625423037141E-08  -2.22348337284541E-19  -5.09296908351758E-01  -5.09296908345032E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.72640445463657E-09   0.00000000000000E+00  -6.72640445463657E-09
      1.13465394424065E-18  -6.77078567478909E-03  -3.10460424080470E-03   0.00000000000000E+00   1.54667039021857E-12
      1.25556838740986E-23  -1.16376845194676E-08  -1.16361378490774E-08  -9.12305606956112E-19
      5.83599283880782E-09
      0.00000000000000E+00  -1.85161745552490E-11   0.00000000000000E+00   1.14172312181038E-12   1.09424938280183E-23
      1.85150490355692E-08   1.85161907586911E-08  -2.11969087864731E-19  -5.13894233016472E-01  -5.13894233009703E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76906879963346E-09   0.00000000000000E+00  -6.76906879963346E-09
      1.08896272984313E-18  -6.77490218205790E-03  -3.07375242983374E-03   0.00000000000000E+00   1.02465908033027E-12
      9.22236324532550E-24  -1.17481466181379E-08  -1.17471219590575E-08  -8.76993641978397E-19
      5.84510533880782E-09
      0.00000000000000E+00  -1.86443898083907E-11   0.00000000000000E+00   7.15189880461574E-13   8.81679334096610E-24
      1.86437060673985E-08   1.86444212572790E-08  -1.98243136403769E-19  -5.20007752696918E-01  -5.20007752690180E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73782967331338E-09   0.00000000000000E+00  -6.73782967331338E-09
      1.02756425694506E-18  -6.78057945894952E-03  -3.02918510252993E-03   0.00000000000000E+00   9.05304686016426E-13
      5.96185130368583E-24  -1.19074968886517E-08  -1.19065915839656E-08  -8.29321120541289E-19
      5.85740721380782E-09
      0.00000000000000E+00  -1.85086432867980E-11   0.00000000000000E+00  -5.23218433951860E-13   6.84710107364683E-24
      1.85091456573893E-08   1.85086224389553E-08  -1.80897735402087E-19  -5.27784220762857E-01  -5.27784220756408E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.44956549306384E-09   0.00000000000000E+00  -6.44956549306384E-09
      9.48222508445073E-19  -6.74170746584187E-03  -2.94227519672370E-03   0.00000000000000E+00   1.01608791141522E-12
      3.08868053082496E-24  -1.20600730338029E-08  -1.20590569458915E-08  -7.67324773042986E-19
      5.87401474505782E-09
      0.00000000000000E+00  -1.75120360433591E-11   0.00000000000000E+00  -2.94169834063811E-12   5.09146913854140E-24
      1.75149515326389E-08   1.75120098342982E-08  -1.61956059460146E-19  -5.36320760785470E-01  -5.36320760780103E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.36695239867356E-09   0.00000000000000E+00  -5.36695239867356E-09
      8.59090678766840E-19  -6.58686245032249E-03  -2.76033316424002E-03   0.00000000000000E+00   1.04079177740041E-12
      8.28944012828152E-25  -1.21460982274020E-08  -1.21450574356246E-08  -6.97134619306694E-19
      5.89401474505782E-09
      0.00000000000000E+00  -1.44570045496252E-11   0.00000000000000E+00  -7.52131737224180E-12   3.46641004443901E-24
      1.44645122912453E-08   1.44569909738731E-08  -1.52585770241922E-19  -5.40440056587740E-01  -5.40440056585444E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.29608262461308E-09   0.00000000000000E+00  -2.29608262461308E-09
      8.13169026274578E-19  -6.23932998594560E-03  -2.40780550608484E-03   0.00000000000000E+00   5.04017714317226E-13
     -7.97123383265143E-25  -1.21614123669743E-08  -1.21609083492600E-08  -6.60583256032656E-19
      5.91401474505782E-09
      0.00000000000000E+00  -8.63818122384231E-12   0.00000000000000E+00  -1.43415020969900E-11   1.67321567998789E-24
      8.65247182104440E-09   8.63813031894741E-09  -1.67865438927075E-19  -5.33150539325168E-01  -5.33150539328682E-01
      0.00000000000000E+00   0.00000000000000E+00   3.51397013338988E-09   0.00000000000000E+00   3.51397013338988E-09
      8.83448428942375E-19  -5.67793113567590E-03  -1.84918073388065E-03   0.00000000000000E+00  -7.80836631606160E-13
     -2.23100030304544E-24  -1.21513196157057E-08  -1.21521004523373E-08  -7.15582990015301E-19
      5.93401474505782E-09
      0.00000000000000E+00  -6.97836313302788E-13   0.00000000000000E+00  -1.95836002913664E-11  -9.71315708188529E-25
      7.17474632726260E-10   6.97891032434892E-10  -2.19174433897680E-19  -5.09792497281329E-01  -5.09792497292766E-01
      0.00000000000000E+00   0.00000000000000E+00   1.14371784234390E-08   0.00000000000000E+00   1.14371784234390E-08
      1.11219199741116E-18  -4.94194347437824E-03  -1.11855886146579E-03   0.00000000000000E+00  -2.83617492469259E-12
     -4.74326144790362E-24  -1.21322332809493E-08  -1.21350694558740E-08  -8.93017563513476E-19
      5.95401474505782E-09
      0.00000000000000E+00   6.93730853549612E-12   0.00000000000000E+00  -1.88749738354013E-11  -6.16527957240446E-24
     -6.91846252692305E-09  -6.93733750075846E-09  -3.14342185404903E-19  -4.68677592617629E-01  -4.68677592636668E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90392515780129E-08   0.00000000000000E+00   1.90392515780129E-08
      1.49297702897142E-18  -4.18352774523913E-03  -3.70590278092898E-04   0.00000000000000E+00  -5.81533384598441E-12
     -1.19700053177646E-23  -1.20960987434085E-08  -1.21019140772545E-08  -1.17863484356651E-18
      5.97401474505782E-09
      0.00000000000000E+00   1.15489246354232E-11   0.00000000000000E+00  -1.15015814941245E-11  -1.82821774989859E-23
     -1.15374091650979E-08  -1.15489107465920E-08  -4.56843946703824E-19  -4.10744617204510E-01  -4.10744617228109E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35985073678513E-08   0.00000000000000E+00   2.35985073678513E-08
      1.96494717632844E-18  -3.57413094468523E-03   2.22320417804934E-04   0.00000000000000E+00  -1.06174454358034E-11
     -3.32218024107164E-23  -1.20389791758235E-08  -1.20495966212593E-08  -1.50810322962462E-18
      5.99401474505782E-09
      0.00000000000000E+00   1.16200124620219E-11   0.00000000000000E+00  -4.09179105269903E-13  -3.46925169982358E-23
     -1.16196135819836E-08  -1.16200227610889E-08  -6.37210132842928E-19  -3.38922481689046E-01  -3.38922481712595E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35494077413242E-08   0.00000000000000E+00   2.35494077413242E-08
      2.43593533115492E-18  -3.60737493146194E-03   1.51196994889829E-04   0.00000000000000E+00  -1.92047172526714E-11
     -6.43482644158439E-23  -1.19101802629826E-08  -1.19293849802353E-08  -1.79872519831200E-18
      6.01401474505782E-09
      0.00000000000000E+00   9.03063378593007E-12   0.00000000000000E+00   6.03950762700967E-12  -4.12553813604597E-23
     -9.03670306392106E-09  -9.03066355629409E-09  -8.16592019215702E-19  -2.62160360283077E-01  -2.62160360303276E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01985461094448E-08   0.00000000000000E+00   2.01985461094448E-08
      2.83990625334382E-18  -8.72061817658998E-03  -5.20197679508746E-03   0.00000000000000E+00  -3.22617911479602E-11
     -7.74980685024361E-23  -1.11356207620026E-08  -1.11678825531506E-08  -2.02331423412812E-18
      6.03401474505782E-09
      0.00000000000000E+00   7.18978971807961E-12   0.00000000000000E+00   4.11763107151451E-12  -4.34133913852595E-23
     -7.19386263249306E-09  -7.18974500142159E-09  -9.63611199576330E-19  -1.91879198458274E-01  -1.91879198475006E-01
      0.00000000000000E+00   0.00000000000000E+00   1.67323523066560E-08   0.00000000000000E+00   1.67323523066560E-08
      3.17455329947694E-18  -2.43985760618070E-02  -2.13920077771016E-02   0.00000000000000E+00  -5.04809705124697E-11
     -8.52904277831062E-23  -9.49212633472188E-09  -9.54260730523443E-09  -2.21094209990061E-18
      6.05401474505782E-09
      0.00000000000000E+00   5.89000299711869E-12   0.00000000000000E+00   2.70903602257754E-12  -4.51850671690194E-23
     -5.89272224324336E-09  -5.89001320722083E-09  -1.08129707423764E-18  -1.30269805802600E-01  -1.30269805816641E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40407070311758E-08   0.00000000000000E+00   1.40407070311758E-08
      3.45536744010045E-18  -4.78745688404163E-02  -4.53065454530715E-02   0.00000000000000E+00  -7.67547838589447E-11
     -9.39133040291880E-23  -8.07393904009588E-09  -8.15069382395492E-09  -2.37407036586282E-18
      6.05403427630782E-09
      0.00000000000000E+00   5.88733949973967E-12   0.00000000000000E+00   3.73721382927116E-12  -4.51867458047108E-23
     -5.89104159868585E-09  -5.88730438485662E-09  -1.08141197671142E-18  -1.30209193896175E-01  -1.30209193910211E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40350916059028E-08   0.00000000000000E+00   1.40350916059028E-08
      3.45564156298338E-18  -4.78974744693099E-02  -4.53303664772550E-02   0.00000000000000E+00  -7.63172363591410E-11
     -9.39215189772154E-23  -8.07146998470608E-09  -8.14778722106532E-09  -2.37422958627196E-18
      6.05406064349532E-09
      0.00000000000000E+00   5.88228803919326E-12   0.00000000000000E+00   5.55017063611862E-12  -4.51888935073791E-23
     -5.88779785393781E-09  -5.88224768330174E-09  -1.08156699844668E-18  -1.30126808545647E-01  -1.30126808559671E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40241557361892E-08   0.00000000000000E+00   1.40241557361892E-08
      3.45601134052721E-18  -4.79284348193676E-02  -4.53631782933349E-02   0.00000000000000E+00  -7.57478981975052E-11
     -9.39324594927059E-23  -8.06616015473055E-09  -8.14190805292815E-09  -2.37444434208053E-18
      6.05409623919845E-09
      0.00000000000000E+00   5.87429754705620E-12   0.00000000000000E+00   7.59946191175480E-12  -4.51916213302920E-23
     -5.88193116884995E-09  -5.87433170693824E-09  -1.08177604074923E-18  -1.30014960205719E-01  -1.30014960219725E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40061939046653E-08   0.00000000000000E+00   1.40061939046653E-08
      3.45650990084735E-18  -4.79703783487149E-02  -4.54082855080516E-02   0.00000000000000E+00  -7.57256322217990E-11
     -9.39471661347560E-23  -8.05613656551830E-09  -8.13186219774019E-09  -2.37473386009812E-18
      6.05414429339767E-09
      0.00000000000000E+00   5.86318433385409E-12   0.00000000000000E+00   9.23072174424722E-12  -4.51951376564617E-23
     -5.87240914032286E-09  -5.86317841857866E-09  -1.08205775984239E-18  -1.29863370048172E-01  -1.29863370062151E-01
      0.00000000000000E+00   0.00000000000000E+00   1.39797459139644E-08   0.00000000000000E+00   1.39797459139644E-08
      3.45718168634253E-18  -4.80273163679944E-02  -4.54700404120143E-02   0.00000000000000E+00  -7.68200516513766E-11
     -9.39672192509997E-23  -8.03974744372355E-09  -8.11656749537502E-09  -2.37512392650014E-18
      6.05420916656661E-09
      0.00000000000000E+00   5.84858102063810E-12   0.00000000000000E+00   9.97330229371077E-12  -4.51998219796807E-23
     -5.85855926404770E-09  -5.84858596175403E-09  -1.08243717434658E-18  -1.29658324440592E-01  -1.29658324454536E-01
      0.00000000000000E+00   0.00000000000000E+00   1.39439099291428E-08   0.00000000000000E+00   1.39439099291428E-08
      3.45808627196712E-18  -4.81047200162674E-02  -4.55541348964908E-02   0.00000000000000E+00  -7.91024745525894E-11
     -9.39948940624555E-23  -8.01622149283610E-09  -8.09532396738879E-09  -2.37564909762054E-18
      6.05429674534469E-09
      0.00000000000000E+00   5.83048760740821E-12   0.00000000000000E+00   9.73260923182989E-12  -4.52062899729055E-23
     -5.84026573971351E-09  -5.83053313048172E-09  -1.08294781757094E-18  -1.29381510435903E-01  -1.29381510449801E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38985376111827E-08   0.00000000000000E+00   1.38985376111827E-08
      3.45930348890815E-18  -4.82100313262759E-02  -4.56680514028617E-02   0.00000000000000E+00  -8.21290705422675E-11
     -9.40332369841257E-23  -7.98587541016812E-09  -8.06800448071048E-09  -2.37635567133722E-18
      6.05441497669509E-09
      0.00000000000000E+00   5.80908778363886E-12   0.00000000000000E+00   8.76235536012708E-12  -4.52154321631983E-23
     -5.81787175120777E-09  -5.80910939584769E-09  -1.08363461565902E-18  -1.29008411700685E-01  -1.29008411714529E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38441914163185E-08   0.00000000000000E+00   1.38441914163185E-08
      3.46094030635454E-18  -4.83533695063399E-02  -4.58217604206898E-02   0.00000000000000E+00  -8.53214132519649E-11
     -9.40861401043676E-23  -7.94976060721006E-09  -8.03508202046212E-09  -2.37730569069552E-18
      6.05457458901813E-09
      0.00000000000000E+00   5.78428970459283E-12   0.00000000000000E+00   7.47247627434416E-12  -4.52284232352276E-23
     -5.79179669779683E-09  -5.78432422152253E-09  -1.08455771057110E-18  -1.28506148965131E-01  -1.28506148978913E-01
      0.00000000000000E+00   0.00000000000000E+00   1.37818109708392E-08   0.00000000000000E+00   1.37818109708392E-08
      3.46314005321935E-18  -4.85485058077111E-02  -4.60287402277074E-02   0.00000000000000E+00  -8.83193897137228E-11
     -9.41585701955105E-23  -7.90916735960040E-09  -7.99748674931422E-09  -2.37858234264824E-18
      6.05479006565424E-09
      0.00000000000000E+00   5.75581783605849E-12   0.00000000000000E+00   6.23058993677739E-12  -4.52467262090176E-23
     -5.76201255555276E-09  -5.75578196561603E-09  -1.08579746568789E-18  -1.27830653088441E-01  -1.27830653102153E-01
      0.00000000000000E+00   0.00000000000000E+00   1.37120855642067E-08   0.00000000000000E+00   1.37120855642067E-08
      3.46609468729076E-18  -4.88142029804933E-02  -4.63074117122075E-02   0.00000000000000E+00  -9.10043708759998E-11
     -9.42570363907085E-23  -7.86529922771101E-09  -7.95630359858711E-09  -2.38029722160287E-18
      6.05508095911299E-09
      0.00000000000000E+00   5.72229450697775E-12   0.00000000000000E+00   5.25462954711822E-12  -4.52721308975227E-23
     -5.72755979616518E-09  -5.72230516661811E-09  -1.08746088114416E-18  -1.26923034925745E-01  -1.26923034939380E-01
      0.00000000000000E+00   0.00000000000000E+00   1.36345858760047E-08   0.00000000000000E+00   1.36345858760047E-08
      3.47006089913482E-18  -4.91760749511550E-02  -4.66831529789558E-02   0.00000000000000E+00  -9.33453219307658E-11
     -9.43902682609216E-23  -7.81893538745718E-09  -7.91228070938804E-09  -2.38260001799066E-18
      6.05547366528230E-09
      0.00000000000000E+00   5.68169913313202E-12   0.00000000000000E+00   4.59765912070216E-12  -4.53068537471354E-23
     -5.68628480864865E-09  -5.68168714952799E-09  -1.08968961361147E-18  -1.25704977718383E-01  -1.25704977731930E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35468590427628E-08   0.00000000000000E+00   1.35468590427628E-08
      3.47538083425567E-18  -4.96692237634583E-02  -4.71911435983695E-02   0.00000000000000E+00  -9.53267342169259E-11
     -9.45700712143386E-23  -7.76984515901655E-09  -7.86517189323357E-09  -2.38569122064420E-18
      6.05600381861087E-09
      0.00000000000000E+00   5.63072530398184E-12   0.00000000000000E+00   4.19411909705843E-12  -4.53537370963440E-23
     -5.63491136864473E-09  -5.63071724954772E-09  -1.09266975162547E-18  -1.24072960684381E-01  -1.24072960697825E-01
      0.00000000000000E+00   0.00000000000000E+00   1.34438515255956E-08   0.00000000000000E+00   1.34438515255956E-08
      3.48250813689073E-18  -5.03420378550128E-02  -4.78803526077512E-02   0.00000000000000E+00  -9.69868284896468E-11
     -9.48123973273740E-23  -7.71614744755757E-09  -7.81313427604732E-09  -2.38983838526526E-18
      6.05671952560443E-09
      0.00000000000000E+00   5.56542369582729E-12   0.00000000000000E+00   3.93533526425814E-12  -4.54165172469284E-23
     -5.56932975710149E-09  -5.56539442183728E-09  -1.09664337504828E-18  -1.21891161725107E-01  -1.21891161738425E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33179174050793E-08   0.00000000000000E+00   1.33179174050793E-08
      3.49203986351727E-18  -5.12616896398645E-02  -4.88191007787420E-02   0.00000000000000E+00  -9.84580380688396E-11
     -9.51387286702437E-23  -7.65406494517410E-09  -7.75252298324304E-09  -2.39539648846899E-18
      6.05768573004575E-09
      0.00000000000000E+00   5.48101838233357E-12   0.00000000000000E+00   3.73299501478309E-12  -4.55000999426263E-23
     -5.48478683948306E-09  -5.48105384446833E-09  -1.10192152111687E-18  -1.18983048229025E-01  -1.18983048242184E-01
      0.00000000000000E+00   0.00000000000000E+00   1.31592540321731E-08   0.00000000000000E+00   1.31592540321731E-08
      3.50475439320753E-18  -5.25220957414367E-02  -5.01029234371097E-02   0.00000000000000E+00  -9.99491770476756E-11
     -9.55779086344840E-23  -7.57825101065769E-09  -7.67820018770547E-09  -2.40283287209066E-18
      6.05899010604152E-09
      0.00000000000000E+00   5.37218236874265E-12   0.00000000000000E+00   3.54198431088138E-12  -4.56107985140557E-23
     -5.37575254431937E-09  -5.37221056000853E-09  -1.10889720336371E-18  -1.15122074471399E-01  -1.15122074484356E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29562594270936E-08   0.00000000000000E+00   1.29562594270936E-08
      3.52165422699924E-18  -5.42554727738627E-02  -5.18659644196277E-02   0.00000000000000E+00  -1.01694823574974E-10
     -9.61685940144194E-23  -7.48235404351057E-09  -7.58404886708564E-09  -2.41275702363553E-18
      6.06075101363581E-09
      0.00000000000000E+00   5.23211914450118E-12   0.00000000000000E+00   3.35136799561493E-12  -4.57564996922872E-23
     -5.23544263884207E-09  -5.23209127084650E-09  -1.11805513394653E-18  -1.10022845942769E-01  -1.10022845955464E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26952784854504E-08   0.00000000000000E+00   1.26952784854504E-08
      3.54400943929594E-18  -5.66492144959786E-02  -5.42977856884874E-02   0.00000000000000E+00  -1.03919172363645E-10
     -9.69625383891233E-23  -7.35926804223949E-09  -7.46318721460323E-09  -2.42595430534942E-18
      6.06312823888811E-09
      0.00000000000000E+00   5.05164423588839E-12   0.00000000000000E+00   3.17185965116304E-12  -4.59466335315841E-23
     -5.05482750567549E-09  -5.05165564602437E-09  -1.12997035215236E-18  -1.03336499357431E-01  -1.03336499369790E-01
      0.00000000000000E+00   0.00000000000000E+00   1.23591673208200E-08   0.00000000000000E+00   1.23591673208200E-08
      3.57338996394836E-18  -5.99708160029429E-02  -5.76684355053585E-02   0.00000000000000E+00  -1.06827762433970E-10
     -9.80289582559458E-23  -7.20068391236192E-09  -7.30751167479599E-09  -2.44341961179600E-18
      6.06633749297871E-09
      0.00000000000000E+00   4.81707277706036E-12   0.00000000000000E+00   3.03725626436398E-12  -4.61915819949551E-23
     -4.82009459935928E-09  -4.81705734309496E-09  -1.14527569508002E-18  -9.46611974366732E-02  -9.46611974485964E-02
      0.00000000000000E+00   0.00000000000000E+00   1.19231399401617E-08   0.00000000000000E+00   1.19231399401617E-08
      3.61165434957413E-18  -6.46057650801716E-02  -6.23668484217028E-02   0.00000000000000E+00  -1.10594415137027E-10
     -9.94599762875713E-23  -6.99548818192929E-09  -7.10608259706641E-09  -2.46637865449410E-18
      6.07066998600102E-09
      0.00000000000000E+00   4.50268824159900E-12   0.00000000000000E+00   3.01930365062245E-12  -4.65002052262710E-23
     -4.50570333728641E-09  -4.50268403363583E-09  -1.16453984707855E-18  -8.36018667343238E-02  -8.36018667456673E-02
      0.00000000000000E+00   0.00000000000000E+00   1.13435210002220E-08   0.00000000000000E+00   1.13435210002220E-08
      3.66080007515602E-18  -7.11196988387286E-02  -6.89643527143951E-02   0.00000000000000E+00  -1.15266606512738E-10
     -1.01376047447959E-22  -6.72557036007323E-09  -6.84083696658607E-09  -2.49626022807748E-18
      6.07651885158114E-09
      0.00000000000000E+00   4.05540437139834E-12   0.00000000000000E+00   3.23486992999304E-12  -4.68722233770283E-23
     -4.05862411322916E-09  -4.05538924329921E-09  -1.18788809000936E-18  -6.99824468995459E-02  -6.99824469100780E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05320931741218E-08   0.00000000000000E+00   1.05320931741218E-08
      3.72240087240876E-18  -8.03742314342306E-02  -7.83336124162643E-02   0.00000000000000E+00  -1.20452905464423E-10
     -1.03925090288790E-22  -6.35625102535814E-09  -6.47670393082267E-09  -2.53451278239940E-18
      6.08441482011430E-09
      0.00000000000000E+00   3.38126400029510E-12   0.00000000000000E+00   3.73073198802390E-12  -4.72800873301174E-23
     -3.38500905074685E-09  -3.38127831875888E-09  -1.21404459953892E-18  -5.44222157660961E-02  -5.44222157754286E-02
      0.00000000000000E+00   0.00000000000000E+00   9.33250200223093E-09   0.00000000000000E+00   9.33250200223093E-09
      3.79609001455404E-18  -9.37456695045646E-02  -9.18706134998958E-02   0.00000000000000E+00  -1.24728823440153E-10
     -1.07256838913719E-22  -5.82649486003186E-09  -5.95122368347212E-09  -2.58204541501512E-18
      6.08974459887418E-09
      0.00000000000000E+00   2.82036819016873E-12   0.00000000000000E+00   4.76187447826366E-12  -4.74976804512241E-23
     -2.82512087540301E-09  -2.82035900092480E-09  -1.22870117154594E-18  -4.55574582511879E-02  -4.55574582595278E-02
      0.00000000000000E+00   0.00000000000000E+00   8.33984985109977E-09   0.00000000000000E+00   8.33984985109977E-09
      3.84053956915105E-18  -1.03257417120559E-01  -1.01518384743508E-01   0.00000000000000E+00  -1.27941873005721E-10
     -1.09444481059830E-22  -5.39154897716895E-09  -5.51949085017478E-09  -2.61183839760511E-18
      6.09693980020003E-09
      0.00000000000000E+00   2.13318586638202E-12   0.00000000000000E+00   4.38763134203506E-12  -4.77093222033169E-23
     -2.13756615474578E-09  -2.13317852340379E-09  -1.24353551278681E-18  -3.64236586596066E-02  -3.64236586667345E-02
      0.00000000000000E+00   0.00000000000000E+00   7.12787295942819E-09   0.00000000000000E+00   7.12787295942819E-09
      3.89182605011917E-18  -1.16827809799943E-01  -1.15254125209816E-01   0.00000000000000E+00  -1.27045712992468E-10
     -1.12234003397205E-22  -4.86764872303165E-09  -4.99469443602423E-09  -2.64829053733236E-18
      6.10665332198992E-09
      0.00000000000000E+00   1.41890934511908E-12   0.00000000000000E+00   3.41512329562468E-12  -4.78853663869170E-23
     -1.42231542555510E-09  -1.41890030225952E-09  -1.25662264431540E-18  -2.81522624002036E-02  -2.81522624060312E-02
      0.00000000000000E+00   0.00000000000000E+00   5.82760776558106E-09   0.00000000000000E+00   5.82760776558106E-09
      3.94843264513306E-18  -1.35954787258399E-01  -1.34565729754250E-01   0.00000000000000E+00  -1.25367092994089E-10
     -1.15734870853538E-22  -4.28334037032738E-09  -4.40870746332158E-09  -2.69181000081766E-18
      6.11976657640626E-09
      0.00000000000000E+00   8.34042058581550E-13   0.00000000000000E+00   2.08445012689418E-12  -4.80104477128158E-23
     -8.36098338083014E-10  -8.34013887956167E-10  -1.26663156308124E-18  -2.15525711817298E-02  -2.15525711864006E-02
      0.00000000000000E+00   0.00000000000000E+00   4.67079187988605E-09   0.00000000000000E+00   4.67079187988605E-09
      4.00968192737983E-18  -1.62044042980317E-01  -1.60835183174362E-01   0.00000000000000E+00  -1.24642011072747E-10
     -1.20109656428409E-22  -3.71213598085712E-09  -3.83677799192999E-09  -2.74305036429859E-18
      6.13746946986834E-09
      0.00000000000000E+00   4.60233978146917E-13   0.00000000000000E+00   9.88441962562687E-13  -4.80883595779156E-23
     -4.61225440530557E-10  -4.60236998568042E-10  -1.27355533863734E-18  -1.66662650996234E-02  -1.66662651033786E-02
      0.00000000000000E+00   0.00000000000000E+00   3.75518818981498E-09   0.00000000000000E+00   3.75518818981498E-09
      4.07615962383415E-18  -1.95757453957194E-01  -1.94719307133330E-01   0.00000000000000E+00  -1.24762178192172E-10
     -1.25544673487622E-22  -3.17018901305468E-09  -3.29495119124698E-09  -2.80260428519682E-18
      6.15746946986834E-09
      0.00000000000000E+00   2.75534211622580E-13   0.00000000000000E+00   4.33356914061857E-13  -4.81268588190651E-23
     -2.75919352323649E-10  -2.75485995409636E-10  -1.27771778014516E-18  -1.34936752034557E-02  -1.34936752064936E-02
      0.00000000000000E+00   0.00000000000000E+00   3.03796037529129E-09   0.00000000000000E+00   3.03796037529129E-09
      4.13691883133998E-18  -2.29773607543401E-01  -2.28903227147947E-01   0.00000000000000E+00  -1.21792434821268E-10
     -1.31033992521302E-22  -2.64068194506016E-09  -2.76247437988156E-09  -2.85920105119482E-18
      6.17746946986834E-09
      0.00000000000000E+00   1.94435308668334E-13   0.00000000000000E+00   1.90993804309738E-13  -4.81441386767059E-23
     -1.94577004780236E-10  -1.94386010975975E-10  -1.28028777561097E-18  -1.14595749677855E-02  -1.14595749702092E-02
      0.00000000000000E+00   0.00000000000000E+00   2.42365930363291E-09   0.00000000000000E+00   2.42365930363291E-09
      4.18539201741264E-18  -2.58007505861578E-01  -2.57305121005781E-01   0.00000000000000E+00  -1.10811842411668E-10
     -1.35661185849165E-22  -2.11846145024516E-09  -2.22927329265696E-09  -2.90510424180167E-18
      6.19746946986834E-09
      0.00000000000000E+00   1.56687121676041E-13   0.00000000000000E+00   8.99309137790487E-14  -4.81516469343320E-23
     -1.56738981524237E-10  -1.56649050610506E-10  -1.28212643740171E-18  -1.00475993110780E-02  -1.00475993129574E-02
      0.00000000000000E+00   0.00000000000000E+00   1.87944743317877E-09   0.00000000000000E+00   1.87944743317877E-09
      4.22298096607621E-18  -2.79874020665215E-01  -2.79331212715281E-01   0.00000000000000E+00  -9.21740067740087E-11
     -1.39293823952868E-22  -1.63062437579417E-09  -1.72279838256832E-09  -2.94085452867451E-18
      6.21746946986834E-09
      0.00000000000000E+00   1.36756813702007E-13   0.00000000000000E+00   4.88046255326540E-14  -4.81539441142025E-23
     -1.36803447880546E-10  -1.36754643255061E-10  -1.28358527165041E-18  -9.02574888995964E-03  -9.02574889137648E-03
      0.00000000000000E+00   0.00000000000000E+00   1.41684096441221E-09   0.00000000000000E+00   1.41684096441221E-09
      4.25131778536446E-18  -2.95768873415686E-01  -2.95365553945638E-01   0.00000000000000E+00  -7.00935651814539E-11
     -1.41947267219268E-22  -1.20999275597545E-09  -1.28008632115705E-09  -2.96773251371405E-18
      6.23746946986834E-09
      0.00000000000000E+00   1.26010979448727E-13   0.00000000000000E+00   2.76485500117553E-14  -4.81536277771481E-23
     -1.26021073527904E-10  -1.25993424977941E-10  -1.28484249249208E-18  -8.26187313548524E-03  -8.26187313651721E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03197803968690E-09   0.00000000000000E+00   1.03197803968690E-09
      4.27195734615820E-18  -3.06395880838473E-01  -3.06110433370808E-01   0.00000000000000E+00  -4.75770913190556E-11
     -1.43706069002281E-22  -8.58407523389800E-10  -9.05984614709000E-10  -2.98711485366611E-18
      6.25746946986834E-09
      0.00000000000000E+00   1.18387866260502E-13   0.00000000000000E+00   2.07174861489491E-14  -4.81513821448170E-23
     -1.18408806175812E-10  -1.18388088689711E-10  -1.28595781526706E-18  -7.68972710742083E-03  -7.68972710815030E-03
      0.00000000000000E+00   0.00000000000000E+00   7.29475957600035E-10   0.00000000000000E+00   7.29475957600035E-10
      4.28654686531020E-18  -3.12793430620420E-01  -3.12600899803141E-01   0.00000000000000E+00  -2.78347105683436E-11
     -1.44728054013619E-22  -5.83253158341875E-10  -6.11087868910363E-10  -3.00058905004313E-18
      6.27746946986834E-09
      0.00000000000000E+00   1.04151931993335E-13   0.00000000000000E+00   3.92016027076331E-14  -4.81442027282937E-23
     -1.04148804997814E-10  -1.04109603395154E-10  -1.28679664135767E-18  -7.32501716587333E-03  -7.32501716645563E-03
      0.00000000000000E+00   0.00000000000000E+00   5.82296943470064E-10   0.00000000000000E+00   5.82296943470064E-10
      4.29819280417960E-18  -3.17439192072824E-01  -3.17288535797050E-01   0.00000000000000E+00  -1.90157481380137E-11
     -1.45421267412501E-22  -4.59171591936696E-10  -4.78187340074855E-10  -3.01139616282192E-18
      6.29746946986834E-09
      0.00000000000000E+00   9.17528924703192E-14   0.00000000000000E+00   3.62775685149929E-14  -4.81333492297185E-23
     -9.17852190493273E-11  -9.17489414808604E-11  -1.28739772842296E-18  -7.09059772798963E-03  -7.09059772856085E-03
      0.00000000000000E+00   0.00000000000000E+00   5.71225137050845E-10   0.00000000000000E+00   5.71225137050845E-10
      4.30961730692061E-18  -3.22296497380637E-01  -3.22145434821582E-01   0.00000000000000E+00  -1.99093826253721E-11
     -1.46130709808061E-22  -4.59566812944501E-10  -4.79476195570019E-10  -3.02221957849766E-18
      6.30746946986834E-09
      0.00000000000000E+00   8.90893950913009E-14   0.00000000000000E+00   1.94576838825624E-14  -4.81278114659958E-23
     -8.90663484706994E-11  -8.90468907868650E-11  -1.28767361725339E-18  -6.98661900869923E-03  -6.98661900926131E-03
      0.00000000000000E+00   0.00000000000000E+00   5.62080659608724E-10   0.00000000000000E+00   5.62080659608724E-10
      4.31523811351670E-18  -3.24692237055940E-01  -3.24543204349730E-01   0.00000000000000E+00  -1.96811356836568E-11
     -1.46477846403727E-22  -4.53352633137952E-10  -4.73033768821755E-10  -3.02756449626331E-18
      6.32096946986834E-09
      0.00000000000000E+00   8.30276424356042E-14   0.00000000000000E+00   2.87877870196286E-14  -4.81190270087916E-23
     -8.30483896775058E-11  -8.30196018905343E-11  -1.28796935902255E-18  -6.87407516399295E-03  -6.87407516459854E-03
      0.00000000000000E+00   0.00000000000000E+00   6.05594032373068E-10   0.00000000000000E+00   6.05594032373068E-10
      4.32341363295374E-18  -3.28496560605291E-01  -3.28331918308077E-01   0.00000000000000E+00  -2.40195840344909E-11
     -1.47040145648749E-22  -4.98554846447862E-10  -5.22574430482500E-10  -3.03544427393118E-18
      6.33919446986834E-09
      0.00000000000000E+00   7.32921002916063E-14   0.00000000000000E+00   3.43417546927149E-14  -4.81044809179978E-23
     -7.33508321859249E-11  -7.33164904312802E-11  -1.28820172166956E-18  -6.76820141165374E-03  -6.76820141237332E-03
      0.00000000000000E+00   0.00000000000000E+00   7.19580446312072E-10   0.00000000000000E+00   7.19580446312072E-10
      4.33652798658778E-18  -3.35454252232420E-01  -3.35250637233221E-01   0.00000000000000E+00  -3.44274143648597E-11
     -1.48106993493231E-22  -6.11836541515815E-10  -6.46263955880823E-10  -3.04832626491821E-18
      6.34419446986834E-09
      0.00000000000000E+00   6.30973344615709E-14   0.00000000000000E+00   1.09431105993029E-13  -4.80991424399243E-23
     -6.32427833096909E-11  -6.31333522037460E-11  -1.28821537772630E-18  -6.76190030254922E-03  -6.76190030332565E-03
      0.00000000000000E+00   0.00000000000000E+00   7.76425504971634E-10   0.00000000000000E+00   7.76425504971634E-10
      4.34041011411264E-18  -3.37660172176187E-01  -3.37435437237809E-01   0.00000000000000E+00  -4.06653015662586E-11
     -1.48448033511572E-22  -6.72626851201507E-10  -7.13292152767914E-10  -3.05219473638633E-18
      6.35094446986834E-09
      0.00000000000000E+00   5.22596554710827E-14   0.00000000000000E+00   9.07922826709441E-14  -4.80909253600333E-23
     -5.23909710178454E-11  -5.23001787352225E-11  -1.28816242218980E-18  -6.77535084535542E-03  -6.77535084626140E-03
      0.00000000000000E+00   0.00000000000000E+00   9.05986715664263E-10   0.00000000000000E+00   9.05986715664263E-10
      4.34652552444337E-18  -3.41415964944286E-01  -3.41146993599561E-01   0.00000000000000E+00  -5.28318917577835E-11
     -1.49040930882632E-22  -8.00854645171247E-10  -8.53686536929180E-10  -3.05836310225357E-18
      6.36005696986834E-09
      0.00000000000000E+00   4.99635370408946E-14   0.00000000000000E+00   2.45211398106856E-14  -4.80803940669006E-23
     -5.00224323883705E-11  -4.99979112486078E-11  -1.28807348939571E-18  -6.77290760711739E-03  -6.77290760817511E-03
      0.00000000000000E+00   0.00000000000000E+00   1.05771703719837E-09   0.00000000000000E+00   1.05771703719837E-09
      4.35616397094484E-18  -3.47557827470086E-01  -3.47240322733456E-01   0.00000000000000E+00  -6.61859970140504E-11
     -1.50035521171288E-22  -9.41533128935501E-10  -1.00771912594970E-09  -3.06809048154912E-18
      6.37235884486834E-09
      0.00000000000000E+00   5.38210160036107E-14   0.00000000000000E+00  -4.60692974593370E-15  -4.80677451065428E-23
     -5.38375709542326E-11  -5.38421778840266E-11  -1.28800757366610E-18  -6.70573862979864E-03  -6.70573863097362E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17498114084434E-09   0.00000000000000E+00   1.17498114084434E-09
      4.37061844206686E-18  -3.56873871205282E-01  -3.56520629625352E-01   0.00000000000000E+00  -7.70594940003661E-11
     -1.51579034278032E-22  -1.04407946895979E-09  -1.12113896296031E-09  -3.08261086840076E-18
      6.38896637611834E-09
      0.00000000000000E+00   6.20870423522881E-14   0.00000000000000E+00  -1.55051021073270E-14  -4.80537854450327E-23
     -6.20271903022303E-11  -6.20426954043857E-11  -1.28806726832365E-18  -6.50777158044480E-03  -6.50777158166938E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22458319846572E-09   0.00000000000000E+00   1.22458319846572E-09
      4.39095574580361E-18  -3.69910538616537E-01  -3.69544252081272E-01   0.00000000000000E+00  -8.31898548150098E-11
     -1.53786822156061E-22  -1.07935064824608E-09  -1.16254050306124E-09  -3.10288847747996E-18
      6.40896637611834E-09
      0.00000000000000E+00   7.55882187217945E-14   0.00000000000000E+00  -2.73744523568259E-14  -4.80426404578117E-23
     -7.55557439074622E-11  -7.55831183598671E-11  -1.28842710172331E-18  -6.09919625792043E-03  -6.09919625914198E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22154765175206E-09   0.00000000000000E+00   1.22154765175206E-09
      4.41538669883865E-18  -3.85257614058920E-01  -3.84896550271060E-01   0.00000000000000E+00  -8.54154043990052E-11
     -1.56453243743828E-22  -1.06054912899311E-09  -1.14596453339227E-09  -3.12695959711533E-18
      6.42896637611834E-09
      0.00000000000000E+00   9.37734766888848E-14   0.00000000000000E+00  -4.22136755308002E-14  -4.80387224762784E-23
     -9.36578049695322E-11  -9.37000186451111E-11  -1.28916491338346E-18  -5.47660600686639E-03  -5.47660600806969E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20329885949368E-09   0.00000000000000E+00   1.20329885949368E-09
      4.43945267602852E-18  -3.99911198210017E-01  -3.99561592409198E-01   0.00000000000000E+00  -8.61179709582924E-11
     -1.59077225158084E-22  -1.02348086989024E-09  -1.10959884084869E-09  -3.15028776264506E-18
      6.44896637611834E-09
      0.00000000000000E+00   1.05805137263071E-13   0.00000000000000E+00  -2.98402820352951E-14  -4.80391374320520E-23
     -1.05750007610406E-10  -1.05779847892489E-10  -1.29015867646410E-18  -4.71554292764829E-03  -4.71554292882298E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17468987098867E-09   0.00000000000000E+00   1.17468987098867E-09
      4.46294647344829E-18  -4.13866096743473E-01  -4.13529311150909E-01   0.00000000000000E+00  -8.60666379392652E-11
     -1.61641269325844E-22  -9.82843385156637E-10  -1.06891002309606E-09  -3.17278779698420E-18
      6.46896637611834E-09
      0.00000000000000E+00   1.03968242518920E-13   0.00000000000000E+00   4.47879213592666E-15  -4.80384460226232E-23
     -1.03941527517269E-10  -1.03937048725181E-10  -1.29112933083963E-18  -3.98316199672945E-03  -3.98316199785810E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12865095709843E-09   0.00000000000000E+00   1.12865095709843E-09
      4.48551949259026E-18  -4.27212948184123E-01  -4.26890087997520E-01   0.00000000000000E+00  -8.52162284052450E-11
     -1.64127610866183E-22  -9.39497679967739E-10  -1.02471390837315E-09  -3.19439016175063E-18
      6.48896637611834E-09
      0.00000000000000E+00   8.71606556099429E-14   0.00000000000000E+00   4.40151242363209E-14  -4.80313500679666E-23
     -8.71906456835444E-11  -8.71466305593561E-11  -1.29177810784854E-18  -3.45729392959753E-03  -3.45729393066147E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06394302369086E-09   0.00000000000000E+00   1.06394302369086E-09
      4.50679835306408E-18  -4.40048230550558E-01  -4.39740468450325E-01   0.00000000000000E+00  -8.34622220771292E-11
     -1.66516154650007E-22  -8.93334171054219E-10  -9.76796393131514E-10  -3.21502024521555E-18
      6.50896637611834E-09
      0.00000000000000E+00  -1.39604000555441E-14   0.00000000000000E+00   2.68752567164888E-13  -4.79839861233171E-23
      1.36766623469148E-11   1.39454149140317E-11  -1.29042356411448E-18  -4.14976696194958E-03  -4.14976696281792E-03
      0.00000000000000E+00   0.00000000000000E+00   8.68335773588926E-10   0.00000000000000E+00   8.68335773588926E-10
      4.52416506853586E-18  -4.52551365609251E-01  -4.52273384441054E-01   0.00000000000000E+00  -7.54983724491079E-11
     -1.68638006292105E-22  -8.06782816053702E-10  -8.82281188502978E-10  -3.23374150442138E-18
      6.52896637611834E-09
      0.00000000000000E+00  -6.32259170936614E-13   0.00000000000000E+00   1.64503429935690E-12  -4.76885839180638E-23
      6.30598384387284E-10   6.32243418686593E-10  -1.27676127342248E-18  -1.22231405525623E-02  -1.22231405524105E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.51806873907213E-10   0.00000000000000E+00  -1.51806873907213E-10
      4.52112893105771E-18  -4.65464204613321E-01  -4.65312843315505E-01   0.00000000000000E+00  -2.82006966792552E-11
     -1.69405591568438E-22  -4.52235848099907E-10  -4.80436544779331E-10  -3.24436765763523E-18
      6.54896637611834E-09
      0.00000000000000E+00  -1.52251020868917E-12   0.00000000000000E+00   2.44731218962362E-12  -4.70722741975213E-23
      1.52003882263792E-09   1.52248613482750E-09  -1.24547676275286E-18  -3.05251195291860E-02  -3.05251195275945E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.59143698563221E-09   0.00000000000000E+00  -1.59143698563221E-09
      4.48930019134507E-18  -4.79023872797593E-01  -4.79045622554529E-01   0.00000000000000E+00   3.86945168613730E-11
     -1.68284621304564E-22   3.02563339434392E-11   6.89508508046439E-11  -3.24382342859221E-18
      6.55896637611834E-09
      0.00000000000000E+00  -1.98485661579186E-12   0.00000000000000E+00   2.57983313877248E-12  -4.66870630106449E-23
      1.98224360313612E-09   1.98482343627485E-09  -1.22530481010587E-18  -4.21183280735747E-02  -4.21183280712521E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.32267498747725E-09   0.00000000000000E+00  -2.32267498747725E-09
      4.46607344147030E-18  -4.85885632002829E-01  -4.85992112073539E-01   0.00000000000000E+00   7.04471410763317E-11
     -1.67271118314521E-22   2.67404410126034E-10   3.37851551202199E-10  -3.24076863136443E-18
      6.57246637611834E-09
      0.00000000000000E+00  -2.39806608848852E-12   0.00000000000000E+00   1.84026522088724E-12  -4.60963748722640E-23
      2.39619743109097E-09   2.39803769631181E-09  -1.19281619490584E-18  -6.04115894163631E-02  -6.04115894134158E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.94733954591746E-09   0.00000000000000E+00  -2.94733954591746E-09
      4.42628435760041E-18  -4.95179882014255E-01  -4.95352990802389E-01   0.00000000000000E+00   9.46631858381917E-11
     -1.65423408573251E-22   4.54638663767642E-10   5.49301849605669E-10  -3.23346816269457E-18
      6.59069137611834E-09
      0.00000000000000E+00  -2.94555256698259E-12   0.00000000000000E+00   1.82249631914967E-12  -4.51753628171236E-23
      2.94372336227390E-09   2.94554585859301E-09  -1.14039959577378E-18  -8.90048632574070E-02  -8.90048632537195E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.68750690423883E-09   0.00000000000000E+00  -3.68750690423883E-09
      4.35907954427066E-18  -5.07608883221624E-01  -5.07842704660170E-01   0.00000000000000E+00   1.19023197291354E-10
     -1.62258552023510E-22   6.22937848354683E-10   7.41961045645875E-10  -3.21867994849688E-18
      6.59569137611834E-09
      0.00000000000000E+00  -3.26774390510659E-12   0.00000000000000E+00   3.49707519731453E-12  -4.48922392389533E-23
      3.26425099194293E-09   3.26774806714019E-09  -1.12460525492626E-18  -9.74256715141629E-02  -9.74256715100506E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.11235839859392E-09   0.00000000000000E+00  -4.11235839859392E-09
      4.33851775227769E-18  -5.11009187403182E-01  -5.11275354974662E-01   0.00000000000000E+00   1.29782884682388E-10
     -1.61305113949742E-22   7.14827446771311E-10   8.44610331453537E-10  -3.21391249735142E-18
      6.60244137611834E-09
      0.00000000000000E+00  -3.62428517494621E-12   0.00000000000000E+00   2.95225532153014E-12  -4.44825980487795E-23
      3.62134469760113E-09   3.62429695292261E-09  -1.10139640691288E-18  -1.09621383789155E-01  -1.09621383784605E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.54908450070076E-09   0.00000000000000E+00  -4.54908450070076E-09
      4.30781143189796E-18  -5.15592733256343E-01  -5.15884170794808E-01   0.00000000000000E+00   1.42111817788479E-10
     -1.59886991116196E-22   7.82675729990076E-10   9.24787547778395E-10  -3.20641502498508E-18
      6.61155387611834E-09
      0.00000000000000E+00  -4.09205042154415E-12   0.00000000000000E+00   2.87277394201985E-12  -4.38392760665964E-23
      4.08914498331359E-09   4.09201775725556E-09  -1.06737441141194E-18  -1.27139538036893E-01  -1.27139538031877E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.01604796187927E-09   0.00000000000000E+00  -5.01604796187927E-09
      4.26210269484533E-18  -5.21657769158359E-01  -5.21948983451995E-01   0.00000000000000E+00   1.52866824274383E-10
     -1.57807856133675E-22   7.71163380349408E-10   9.24030204623632E-10  -3.19472828343339E-18
      6.62385575111834E-09
      0.00000000000000E+00  -4.77399759531003E-12   0.00000000000000E+00   3.05265990196075E-12  -4.25185735028537E-23
      4.77092920248209E-09   4.77398186238401E-09  -1.01857212064366E-18  -1.51556998218386E-01  -1.51556998212971E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.41464925400733E-09   0.00000000000000E+00  -5.41464925400733E-09
      4.19549235655369E-18  -5.29282325539670E-01  -5.29484294616763E-01   0.00000000000000E+00   1.57713603765944E-10
     -1.54864410146608E-22   4.82953787857598E-10   6.40667391623387E-10  -3.17692023591004E-18
      6.64046328236834E-09
      0.00000000000000E+00  -6.19896869308481E-12   0.00000000000000E+00   4.50103842900092E-12  -3.78962044984031E-23
      6.19450642733808E-09   6.19900746576704E-09  -9.51490123925404E-19  -1.83856180957094E-01  -1.83856180951418E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.67608549820752E-09   0.00000000000000E+00  -5.67608549820752E-09
      4.10122658926454E-18  -5.37361491871746E-01  -5.37196941492866E-01   0.00000000000000E+00   1.56061338128765E-10
     -1.50809991211052E-22  -6.78983305688132E-10  -5.22921967559519E-10  -3.14973646533914E-18
      6.66046328236834E-09
      0.00000000000000E+00  -9.75556429670908E-12   0.00000000000000E+00   8.97098986929295E-12  -2.01086639688811E-23
      9.74659716615528E-09   9.75556815602455E-09  -8.74325305478120E-19  -2.19406222040699E-01  -2.19406222034830E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.86930739855997E-09   0.00000000000000E+00  -5.86930739855997E-09
      3.98384044129334E-18  -5.40326250435414E-01  -5.39102239943215E-01   0.00000000000000E+00   1.55798992932449E-10
     -1.45625667238155E-22  -4.04205975039699E-09  -3.88626075746469E-09  -3.10951513581522E-18
      6.68046328236834E-09
      0.00000000000000E+00  -1.62447623593697E-11   0.00000000000000E+00   1.61426615980734E-11   2.05256390000818E-23
      1.62286284238826E-08   1.62447710854807E-08  -8.06302476392083E-19  -2.49624058577894E-01  -2.49624058571791E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.10350716249484E-09   0.00000000000000E+00  -6.10350716249484E-09
      3.86177029804344E-18  -5.31182444436245E-01  -5.27988012792572E-01   0.00000000000000E+00   1.62681017236265E-10
     -1.39602351164411E-22  -1.03039449402218E-08  -1.01412639229857E-08  -3.05546782165136E-18
      6.70046328236834E-09
      0.00000000000000E+00  -2.48252650882457E-11   0.00000000000000E+00   2.12766906863510E-11   7.49625629997358E-23
      2.48039720920405E-08   2.48252487827269E-08  -7.51658434108419E-19  -2.73530583347331E-01  -2.73530583340946E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.38473107562407E-09   0.00000000000000E+00  -6.38473107562407E-09
      3.73407567653096E-18  -5.05565771200281E-01  -4.99756804163196E-01   0.00000000000000E+00   1.72962530889459E-10
     -1.32173016759870E-22  -1.86134802379921E-08  -1.84405177071028E-08  -2.98241724242254E-18
      6.72046328236834E-09
      0.00000000000000E+00  -3.28990604019477E-11   0.00000000000000E+00   2.00273818118276E-11   1.26513258745279E-22
      3.28790241932359E-08   3.28990515750479E-08  -7.11637804707442E-19  -2.91271388472803E-01  -2.91271388466130E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.67283758750393E-09   0.00000000000000E+00  -6.67283758750393E-09
      3.60061892478088E-18  -4.62199504298574E-01  -4.53937602372270E-01   0.00000000000000E+00   1.76264110738001E-10
     -1.23236645652559E-22  -2.64024780982819E-08  -2.62262139875440E-08  -2.88898112007344E-18
      6.74046328236834E-09
      0.00000000000000E+00  -3.77885068319276E-11   0.00000000000000E+00   1.21563406991181E-11   1.59148172425742E-22
      3.77763101796411E-08   3.77884665203404E-08  -6.85481570772393E-19  -3.03512292346354E-01  -3.03512292339409E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.94568840701715E-09   0.00000000000000E+00  -6.94568840701715E-09
      3.46170515664054E-18  -4.02254895371801E-01  -3.92538321167490E-01   0.00000000000000E+00   1.68459947282418E-10
     -1.13400406393135E-22  -3.10112380606056E-08  -3.08427781133233E-08  -2.77622358586815E-18
      6.76046328236834E-09
      0.00000000000000E+00  -3.81426601385998E-11   0.00000000000000E+00   9.22931095228057E-13   1.65006731474227E-22
      3.81417723167318E-08   3.81426952478272E-08  -6.71503578380871E-19  -3.11079331463516E-01  -3.11079331456319E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.19625812026821E-09   0.00000000000000E+00  -7.19625812026821E-09
      3.31777999423518E-18  -3.29103490650232E-01  -3.19353987374383E-01   0.00000000000000E+00   1.49824730322328E-10
     -1.03554024430683E-22  -3.10962618578812E-08  -3.09464371275589E-08  -2.64627641585431E-18
      6.78046328236834E-09
      0.00000000000000E+00  -3.55339022229572E-11   0.00000000000000E+00  -6.43099260764457E-12   1.51200951917473E-22
      3.55403616736657E-08   3.55339306810582E-08  -6.64689418623937E-19  -3.15971551436596E-01  -3.15971551429256E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34003632061034E-09   0.00000000000000E+00  -7.34003632061034E-09
      3.17097926782297E-18  -2.52685426580388E-01  -2.43802899956405E-01   0.00000000000000E+00   1.15766615515380E-10
     -9.34233464863819E-23  -2.83096609759632E-08  -2.81938943604479E-08  -2.50628984919903E-18
      6.80046328236834E-09
      0.00000000000000E+00  -3.28346772411652E-11   0.00000000000000E+00  -6.67038395680298E-12   1.32606007095749E-22
      3.28413720769464E-08   3.28347016929897E-08  -6.58518451670021E-19  -3.20685085046171E-01  -3.20685085038850E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32034535097746E-09   0.00000000000000E+00  -7.32034535097746E-09
      3.02457236080342E-18  -1.83527644518259E-01  -1.75489174278708E-01   0.00000000000000E+00   7.70804109218663E-11
     -8.43740621933336E-23  -2.55914367529341E-08  -2.55143563420123E-08  -2.36605390913340E-18
      6.81046328236834E-09
      0.00000000000000E+00  -3.14340449987504E-11   0.00000000000000E+00  -6.92046010966640E-12   1.22486066152882E-22
      3.14409696118067E-08   3.14340491516971E-08  -6.55631264135555E-19  -3.22979470743338E-01  -3.22979470736029E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30900444150090E-09   0.00000000000000E+00  -7.30900444150090E-09
      2.95148231638841E-18  -1.51242989674929E-01  -1.43642180128175E-01   0.00000000000000E+00   5.84137226469743E-11
     -8.13444431898558E-23  -2.41834584328431E-08  -2.41250447101962E-08  -2.29585105225286E-18
      6.82396328236834E-09
      0.00000000000000E+00  -3.00983469855414E-11   0.00000000000000E+00  -4.89075834769727E-12   1.11096190062102E-22
      3.01032783507240E-08   3.00983875923764E-08  -6.50423148428380E-19  -3.26595343791376E-01  -3.26595343784148E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.22828577542328E-09   0.00000000000000E+00  -7.22828577542328E-09
      2.85390045842020E-18  -1.12123337672176E-01  -1.04917860350118E-01   0.00000000000000E+00   4.43448523163586E-11
     -7.73990845332928E-23  -2.29144466692694E-08  -2.28701018169531E-08  -2.20347730999182E-18
      6.84218828236834E-09
      0.00000000000000E+00  -2.82848726493788E-11   0.00000000000000E+00  -4.90505788505759E-12   1.00351323348436E-22
      2.82898155550684E-08   2.82849104971835E-08  -6.40025762158777E-19  -3.32694335621753E-01  -3.32694335614668E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.08436881300732E-09   0.00000000000000E+00  -7.08436881300732E-09
      2.72478783680314E-18  -6.83023120332095E-02  -6.16228032423992E-02   0.00000000000000E+00   3.24155762776148E-11
     -5.94044955802462E-23  -2.12329572604537E-08  -2.12005416841762E-08  -2.08476207464436E-18
      6.84718828236834E-09
      0.00000000000000E+00  -2.72628244137334E-11   0.00000000000000E+00  -1.00367407379712E-11   9.76065978133683E-23
      2.72728851507696E-08   2.72628484100317E-08  -6.36634076178749E-19  -3.34529518919055E-01  -3.34529518912025E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02991564634549E-09   0.00000000000000E+00  -7.02991564634549E-09
      2.68963825857141E-18  -5.76282906444652E-02  -5.12536295939794E-02   0.00000000000000E+00   3.12103974145044E-11
     -4.75750500348978E-23  -2.02641431611005E-08  -2.02329327636861E-08  -2.05300418239266E-18
      6.85393828236834E-09
      0.00000000000000E+00  -2.59483425348193E-11   0.00000000000000E+00  -9.60398104280760E-12   9.62887207845018E-23
      2.59579223820007E-08   2.59483184009580E-08  -6.30088164974493E-19  -3.37695556976200E-01  -3.37695556969323E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.87768617259750E-09   0.00000000000000E+00  -6.87768617259750E-09
      2.64321387690638E-18  -4.59571109606380E-02  -3.99486374484698E-02   0.00000000000000E+00   2.61853565110205E-11
     -2.54251820702355E-23  -1.90968175848713E-08  -1.90706322283603E-08  -2.01312571193188E-18
      6.86305078236834E-09
      0.00000000000000E+00  -2.43045972730162E-11   0.00000000000000E+00  -8.88376452537333E-12   9.90043200835075E-23
      2.43134482957910E-08   2.43045645312658E-08  -6.17794994048024E-19  -3.43157556707938E-01  -3.43157556701281E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.65687691209344E-09   0.00000000000000E+00  -6.65687691209344E-09
      2.58255308604493E-18  -3.47461536172479E-02  -2.91859881372485E-02   0.00000000000000E+00   2.11199487702879E-11
      1.14010093819345E-23  -1.76688075679428E-08  -1.76476876191725E-08  -1.96475809199690E-18
      6.87535265736834E-09
      0.00000000000000E+00  -2.26264102347603E-11   0.00000000000000E+00  -6.70687122367038E-12   1.08285987268630E-22
      2.26330924270159E-08   2.26263855557923E-08  -5.96900090391810E-19  -3.51985925610483E-01  -3.51985925604071E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.41245301657166E-09   0.00000000000000E+00  -6.41245301657166E-09
      2.50366789059169E-18  -2.55867120141309E-02  -2.04782620550239E-02   0.00000000000000E+00   1.53738932053875E-11
      6.00759364753473E-23  -1.62293064324261E-08  -1.62139325392206E-08  -1.90676780019988E-18
      6.89196018861834E-09
      0.00000000000000E+00  -2.12617811293308E-11   0.00000000000000E+00  -4.02310619920699E-12   1.23726905985039E-22
      2.12658075160867E-08   2.12617844098876E-08  -5.65594534383350E-19  -3.64898897938222E-01  -3.64898897932022E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.20039429299911E-09   0.00000000000000E+00  -6.20039429299911E-09
      2.40069464860839E-18  -1.90212974717951E-02  -1.42759646823638E-02   0.00000000000000E+00   1.02861570893229E-11
      1.15108850470596E-22  -1.50716762739779E-08  -1.50613901168885E-08  -1.83510011422503E-18
      6.91196018861834E-09
      0.00000000000000E+00  -2.02750931175104E-11   0.00000000000000E+00  -2.39995001254240E-12   1.37787623458299E-22
      2.02775050962444E-08   2.02751051462320E-08  -5.27743481043757E-19  -3.80401229637904E-01  -3.80401229631861E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.04265871988903E-09   0.00000000000000E+00  -6.04265871988903E-09
      2.27984147421060E-18  -1.48368451937957E-02  -1.03526772367815E-02   0.00000000000000E+00   7.16248582843082E-12
      1.62299441685673E-22  -1.42396089121715E-08  -1.42324464263429E-08  -1.75209799316685E-18
      6.93196018861834E-09
      0.00000000000000E+00  -1.95159963644902E-11   0.00000000000000E+00  -1.83966446402829E-12   1.42327905071592E-22
      1.95178668026209E-08   1.95160271381570E-08  -4.91487320079219E-19  -3.95284216211413E-01  -3.95284216205488E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.92551808199930E-09   0.00000000000000E+00  -5.92551808199930E-09
      2.16133111257062E-18  -1.23359006540012E-02  -8.05398067436262E-03   0.00000000000000E+00   5.65602939240587E-12
      1.87191303691334E-22  -1.35961650855503E-08  -1.35905090561577E-08  -1.66984379249140E-18
      6.95196018861835E-09
      0.00000000000000E+00  -1.88497546407868E-11   0.00000000000000E+00  -1.61372378873595E-12   1.36565473026008E-22
      1.88513723989519E-08   1.88497586751633E-08  -4.57189921095407E-19  -4.09456432956641E-01  -4.09456432950817E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.82306452081917E-09   0.00000000000000E+00  -5.82306452081917E-09
      2.04486982215423E-18  -1.06636685912385E-02  -6.55938425036237E-03   0.00000000000000E+00   4.80042566494022E-12
      1.90453532230999E-22  -1.30314945800093E-08  -1.30266941543442E-08  -1.58767990105883E-18
      6.97196018861835E-09
      0.00000000000000E+00  -1.82659894910957E-11   0.00000000000000E+00  -1.41332431330435E-12   1.22317034692531E-22
      1.82673955095435E-08   1.82659821852303E-08  -4.24677535488746E-19  -4.22988619321680E-01  -4.22988619315950E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.73078864191789E-09   0.00000000000000E+00  -5.73078864191789E-09
      1.93025404931588E-18  -9.47515916032281E-03  -5.52572750474314E-03   0.00000000000000E+00   4.16275858891541E-12
      1.76040808412296E-22  -1.25393563019015E-08  -1.25351935433124E-08  -1.50557651382713E-18
      6.99196018861835E-09
      0.00000000000000E+00  -1.77703034443867E-11   0.00000000000000E+00  -1.19852943797199E-12   1.02626578571387E-22
      1.77715155938041E-08   1.77703170643662E-08  -3.93657093315969E-19  -4.35978771868634E-01  -4.35978771862987E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64722080422098E-09   0.00000000000000E+00  -5.64722080422098E-09
      1.81730963323146E-18  -8.60058183468469E-03  -4.78098606256793E-03   0.00000000000000E+00   3.62887866427407E-12
      1.49799540594560E-22  -1.21267251388097E-08  -1.21230962601453E-08  -1.42365253991549E-18
      7.01196018861835E-09
      0.00000000000000E+00  -1.73687582533154E-11   0.00000000000000E+00  -9.68424324897894E-13   8.08382753129847E-23
      1.73697223814732E-08   1.73687539571484E-08  -3.63788944490718E-19  -4.48546061348490E-01  -4.48546061342904E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58619915137814E-09   0.00000000000000E+00  -5.58619915137814E-09
      1.70558565020389E-18  -7.93905804623329E-03  -4.22675367908266E-03   0.00000000000000E+00   3.19682023010516E-12
      1.18018266097803E-22  -1.17857516260004E-08  -1.17825548057702E-08  -1.34179670571318E-18
      7.03196018861835E-09
      0.00000000000000E+00  -1.72883941082588E-11   0.00000000000000E+00  -1.78120599472946E-13   6.00738973322633E-23
      1.72885418096573E-08   1.72883636890579E-08  -3.33792519345428E-19  -4.61226730541661E-01  -4.61226730535929E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.73277982075199E-09   0.00000000000000E+00  -5.73277982075199E-09
      1.59093005378885E-18  -7.47312452124865E-03  -3.83232945695011E-03   0.00000000000000E+00   2.78389260441624E-12
      8.63441409841784E-23  -1.15583677609105E-08  -1.15555838683060E-08  -1.25713753444343E-18
      7.05196018861835E-09
      0.00000000000000E+00  -1.76577017965703E-11   0.00000000000000E+00   9.30866850638142E-13   4.22665219329119E-23
      1.76567336787521E-08   1.76576645456028E-08  -3.02292809798884E-19  -4.74631767108295E-01  -4.74631767102133E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16219020435834E-09   0.00000000000000E+00  -6.16219020435834E-09
      1.46768624970169E-18  -7.19405061075067E-03  -3.57219224534563E-03   0.00000000000000E+00   2.34665954089132E-12
      5.84604988453162E-23  -1.14978210007854E-08  -1.14954743412444E-08  -1.16539343990280E-18
      7.07196018861835E-09
      0.00000000000000E+00  -1.79707086609735E-11   0.00000000000000E+00   7.94287096846853E-13   2.80881115671462E-23
      1.79698682541580E-08   1.79706625412549E-08  -2.70361501336104E-19  -4.88341674518129E-01  -4.88341674511672E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.45744028074947E-09   0.00000000000000E+00  -6.45744028074947E-09
      1.33853744408670E-18  -6.98511852542273E-03  -3.35766656200042E-03   0.00000000000000E+00   2.06912237498651E-12
      3.61334942262753E-23  -1.15152913828805E-08  -1.15132222605055E-08  -1.06817594275059E-18
      7.07321018861835E-09
      0.00000000000000E+00  -1.80020277163613E-11   0.00000000000000E+00   1.24289155356068E-12   2.71466528253496E-23
      1.80008187117400E-08   1.80020616032936E-08  -2.68394588863663E-19  -4.89193949480799E-01  -4.89193949474283E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.51580635430204E-09   0.00000000000000E+00  -6.51580635430204E-09
      1.33039268614382E-18  -6.96356712113277E-03  -3.34461183060597E-03   0.00000000000000E+00   3.06218537015090E-12
      3.45866198064544E-23  -1.14893174343624E-08  -1.14862552489922E-08  -1.06199809728016E-18
      7.07489768861835E-09
      0.00000000000000E+00  -1.80311424980561E-11   0.00000000000000E+00   8.80221411118117E-13   2.58738543922956E-23
      1.80302022009008E-08   1.80310824223119E-08  -2.65729331727783E-19  -4.90349015859786E-01  -4.90349015853225E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.56080951732600E-09   0.00000000000000E+00  -6.56080951732600E-09
      1.31932132008333E-18  -6.94139129684581E-03  -3.32747122047053E-03   0.00000000000000E+00   2.51283429122343E-12
      3.25495372724610E-23  -1.14727857392768E-08  -1.14702729049856E-08  -1.05359198835555E-18
      7.07717581361835E-09
      0.00000000000000E+00  -1.80680640824135E-11   0.00000000000000E+00   8.22360705697024E-13   2.42466244805496E-23
      1.80672033993414E-08   1.80680257600471E-08  -2.62121570429813E-19  -4.91913681894801E-01  -4.91913681888205E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.59613436674646E-09   0.00000000000000E+00  -6.59613436674646E-09
      1.30429450147909E-18  -6.92100116852535E-03  -3.30657078846003E-03   0.00000000000000E+00   1.99819497103105E-12
      2.99803441603057E-23  -1.14738895882717E-08  -1.14718913933006E-08  -1.04217293104927E-18
      7.08025128236835E-09
      0.00000000000000E+00  -1.81175683957684E-11   0.00000000000000E+00   8.16455446720853E-13   2.22339899050316E-23
      1.81167932438437E-08   1.81176096992904E-08  -2.57246065776065E-19  -4.94030940563724E-01  -4.94030940557094E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.63000424624208E-09   0.00000000000000E+00  -6.63000424624208E-09
      1.28390413060740E-18  -6.89974535824091E-03  -3.28036363929327E-03   0.00000000000000E+00   1.76163328864516E-12
      2.68115893962697E-23  -1.14893670863367E-08  -1.14876054530481E-08  -1.02665806483134E-18
      7.08440316518085E-09
      0.00000000000000E+00  -1.81786451460114E-11   0.00000000000000E+00   7.46720423756754E-13   1.98159360801948E-23
      1.81778883712741E-08   1.81786350916978E-08  -2.50670114643061E-19  -4.96892124100278E-01  -4.96892124093613E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66481606801457E-09   0.00000000000000E+00  -6.66481606801457E-09
      1.25623259532614E-18  -6.87370478434454E-03  -3.24606363336919E-03   0.00000000000000E+00   1.68058414924295E-12
      2.30115171599806E-23  -1.15154996078321E-08  -1.15138190236828E-08  -1.00556248068308E-18
      7.09000820697772E-09
      0.00000000000000E+00  -1.82525801594634E-11   0.00000000000000E+00   6.71829794701713E-13   1.70230576049889E-23
      1.82518941689363E-08   1.82525659987310E-08  -2.41823076786712E-19  -5.00752698347019E-01  -5.00752698340319E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.70051245229011E-09   0.00000000000000E+00  -6.70051245229011E-09
      1.21867594297057E-18  -6.84102354187942E-03  -3.20133543291185E-03   0.00000000000000E+00   1.62627137111249E-12
      1.86381248299432E-23  -1.15536798178117E-08  -1.15520535464406E-08  -9.76852866183861E-19
      7.09757501340350E-09
      0.00000000000000E+00  -1.83558136440847E-11   0.00000000000000E+00   6.92914895549081E-13   1.39798457411192E-23
      1.83550946863776E-08   1.83557876012732E-08  -2.29958582231130E-19  -5.05953572309034E-01  -5.05953572302295E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73841176114942E-09   0.00000000000000E+00  -6.73841176114942E-09
      1.16768768555675E-18  -6.80692273849177E-03  -3.14665299353798E-03   0.00000000000000E+00   1.49524439411943E-12
      1.38965282598051E-23  -1.16188710845180E-08  -1.16173758401239E-08  -9.37729103325618E-19
      7.10268260774091E-09
      0.00000000000000E+00  -1.84511484813061E-11   0.00000000000000E+00   9.38838655305830E-13   1.22013189028217E-23
      1.84502386269474E-08   1.84511774656027E-08  -2.22005930708376E-19  -5.09458236673566E-01  -5.09458236666791E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.77516836007414E-09   0.00000000000000E+00  -6.77516836007414E-09
      1.13308287400589E-18  -6.79511796287583E-03  -3.11637425340458E-03   0.00000000000000E+00   1.31497098585613E-12
      1.11194744837610E-23  -1.16773240765144E-08  -1.16760091055285E-08  -9.11076943297509E-19
      7.10957786009640E-09
      0.00000000000000E+00  -1.85823946107756E-11   0.00000000000000E+00   9.58390202925419E-13   1.02829227497603E-23
      1.85814639463792E-08   1.85824223365821E-08  -2.11359553356083E-19  -5.14171728186736E-01  -5.14171728179938E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.79737608848536E-09   0.00000000000000E+00  -6.79737608848536E-09
      1.08621325052058E-18  -6.79434551010619E-03  -3.08124699000939E-03   0.00000000000000E+00   1.06113242694242E-12
      8.14970287724210E-24  -1.17861073805238E-08  -1.17850462480968E-08  -8.74853697164502E-19
      7.11888645077631E-09
      0.00000000000000E+00  -1.86775457585226E-11   0.00000000000000E+00   5.24961600754449E-13   8.35741407618625E-24
      1.86770217471287E-08   1.86775467087295E-08  -1.97335574305756E-19  -5.20417091145899E-01  -5.20417091139155E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74436455826182E-09   0.00000000000000E+00  -6.74436455826182E-09
      1.02343272145159E-18  -6.79026932073189E-03  -3.03049709372810E-03   0.00000000000000E+00   9.83090985101343E-13
      5.22866363629469E-24  -1.19341652414526E-08  -1.19331821504675E-08  -8.26097147145836E-19
      7.13145304819420E-09
      0.00000000000000E+00  -1.84927541472611E-11   0.00000000000000E+00  -7.04464200775054E-13   6.55296239258390E-24
      1.84934588104993E-08   1.84927543462986E-08  -1.79723029647966E-19  -5.28314411765070E-01  -5.28314411758650E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.41982278896809E-09   0.00000000000000E+00  -6.41982278896809E-09
      9.42757392968459E-19  -6.74006200841610E-03  -2.93625824466447E-03   0.00000000000000E+00   1.06803473936241E-12
      2.64117960615087E-24  -1.20739995920698E-08  -1.20729315573304E-08  -7.63034363320493E-19
      7.14841795470835E-09
      0.00000000000000E+00  -1.73934644876242E-11   0.00000000000000E+00  -3.17831378905838E-12   4.90635776565569E-24
      1.73966575577548E-08   1.73934792439658E-08  -1.60850835643113E-19  -5.36818994298603E-01  -5.36818994293359E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.24434118862941E-09   0.00000000000000E+00  -5.24434118862941E-09
      8.53787634975074E-19  -6.57154327811939E-03  -2.74372825922284E-03   0.00000000000000E+00   1.04209707328959E-12
      5.83178514909734E-25  -1.21501801524097E-08  -1.21491380553364E-08  -6.92936799331962E-19
      7.16841795470835E-09
      0.00000000000000E+00  -1.41831235432723E-11   0.00000000000000E+00  -7.90459867550113E-12   3.33742619553608E-24
      1.41910711142661E-08   1.41831665155907E-08  -1.52644317643305E-19  -5.40398433058953E-01  -5.40398433056931E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.02232281986384E-09   0.00000000000000E+00  -2.02232281986384E-09
      8.13341178577797E-19  -6.21119082976031E-03  -2.37968665360623E-03   0.00000000000000E+00   4.50597958857775E-13
     -9.27763072458659E-25  -1.21612942936856E-08  -1.21608436957267E-08  -6.60696860934492E-19
      7.18841795470835E-09
      0.00000000000000E+00  -8.19383638523229E-12   0.00000000000000E+00  -1.47623445505215E-11   1.53345595885435E-24
      8.20856457942412E-09   8.19380223487360E-09  -1.69832090184039E-19  -5.32233921419740E-01  -5.32233921423698E-01
      0.00000000000000E+00   0.00000000000000E+00   3.95755307232427E-09   0.00000000000000E+00   3.95755307232427E-09
      8.92492240024282E-19  -5.63652307845531E-03  -1.80800739646120E-03   0.00000000000000E+00  -8.84438519853067E-13
     -2.35197120777093E-24  -1.21504708686780E-08  -1.21513553071979E-08  -7.22660149840242E-19
      7.20841795470835E-09
      0.00000000000000E+00  -1.90669674442826E-13   0.00000000000000E+00  -1.97398596970308E-11  -1.19115450919240E-24
      2.10446339457782E-10   1.90706479760750E-10  -2.23645444448984E-19  -5.07801692073506E-01  -5.07801692085449E-01
      0.00000000000000E+00   0.00000000000000E+00   1.19429291371679E-08   0.00000000000000E+00   1.19429291371679E-08
      1.13135082276764E-18  -4.89411098054193E-03  -1.07117815368398E-03   0.00000000000000E+00  -2.98808920361756E-12
     -4.99471606997011E-24  -1.21306475277250E-08  -1.21336356169287E-08  -9.07705378318655E-19
      7.22841795470835E-09
      0.00000000000000E+00   7.33159799232803E-12   0.00000000000000E+00  -1.86006438484402E-11  -6.65305027671500E-24
     -7.31296788170944E-09  -7.33156852555789E-09  -3.21664882395058E-19  -4.65611348086466E-01  -4.65611348105897E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94309207347182E-08   0.00000000000000E+00   1.94309207347182E-08
      1.51996923746200E-18  -4.14013286917159E-03  -3.28002714719761E-04   0.00000000000000E+00  -6.04160055314305E-12
     -1.27472555564720E-23  -1.20933106086072E-08  -1.20993522091603E-08  -1.19830435506695E-18
      7.24841795470835E-09
      0.00000000000000E+00   1.16888041701903E-11   0.00000000000000E+00  -1.08799208146803E-11  -1.93127200836562E-23
     -1.16778839901852E-08  -1.16887639109999E-08  -4.66994643562215E-19  -4.06714624985171E-01  -4.06714625008905E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37345112039595E-08   0.00000000000000E+00   2.37345112039595E-08
      1.99465946154120E-18  -3.54608509817613E-03   2.49153242196256E-04   0.00000000000000E+00  -1.10109959947469E-11
     -3.51341716003818E-23  -1.20347362969649E-08  -1.20457472929597E-08  -1.52766481797898E-18
      7.26841795470835E-09
      0.00000000000000E+00   1.14934504141499E-11   0.00000000000000E+00   2.40547000892722E-13  -3.54138585642884E-23
     -1.14937262342844E-08  -1.14934856872836E-08  -6.48698071243181E-19  -3.34240958292396E-01  -3.34240958315802E-01
      0.00000000000000E+00   0.00000000000000E+00   2.34062471914297E-08   0.00000000000000E+00   2.34062471914297E-08
      2.46278440536979E-18  -3.68442267745695E-03   6.89113734491552E-05   0.00000000000000E+00  -1.98861646278039E-11
     -6.57302985047007E-23  -1.18928753395182E-08  -1.19127615041461E-08  -1.81408633412661E-18
      7.28841795470835E-09
      0.00000000000000E+00   8.88854997747002E-12   0.00000000000000E+00   6.07250733794592E-12  -4.14279169064798E-23
     -8.89455629969590E-09  -8.88848379235800E-09  -8.26561308344668E-19  -2.57619726159896E-01  -2.57619726179865E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99690978156770E-08   0.00000000000000E+00   1.99690978156770E-08
      2.86216636168333E-18  -9.38554988599876E-03  -5.89440423682301E-03   0.00000000000000E+00  -3.31863998252151E-11
     -7.79537491649780E-23  -1.10474276234938E-08  -1.10806140233191E-08  -2.03560505333866E-18
      7.30841795470835E-09
      0.00000000000000E+00   7.10079216772552E-12   0.00000000000000E+00   3.98201023524773E-12  -4.35269317456971E-23
     -7.10473050561646E-09  -7.10074849538125E-09  -9.71553063438907E-19  -1.87875825387153E-01  -1.87875825403701E-01
      0.00000000000000E+00   0.00000000000000E+00   1.65475728410383E-08   0.00000000000000E+00   1.65475728410383E-08
      3.19311781850409E-18  -2.56476596658992E-02  -2.26712694476441E-02   0.00000000000000E+00  -5.18643282994462E-11
     -8.58046254354189E-23  -9.39496001735754E-09  -9.44682434565707E-09  -2.22156475506519E-18
      7.32841795470835E-09
      0.00000000000000E+00   5.81772118893637E-12   0.00000000000000E+00   2.66391995783691E-12  -4.52857427576604E-23
     -5.82033344712965E-09  -5.81766952717186E-09  -1.08767279116974E-18  -1.26786676172790E-01  -1.26786676186684E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38933611683755E-08   0.00000000000000E+00   1.38933611683755E-08
      3.47098504187161E-18  -4.94989932069428E-02  -4.69546003809502E-02   0.00000000000000E+00  -7.85476404018135E-11
     -9.44456869151899E-23  -7.99714400080162E-09  -8.07569164120353E-09  -2.38331225070186E-18
}
